/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import android.app.Activity;
import android.app.Fragment;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.net.FirstPartyHostDetector;
import com.datadog.android.core.internal.persistence.DataWriter;
import com.datadog.android.core.internal.time.TimeProvider;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.internal.utils.ThrowableExtKt;
import com.datadog.android.core.internal.utils.ViewUtilsKt;
import com.datadog.android.core.model.NetworkInfo;
import com.datadog.android.core.model.UserInfo;
import com.datadog.android.log.Logger;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.Time;
import com.datadog.android.rum.internal.domain.scope.RumActionScope;
import com.datadog.android.rum.internal.domain.scope.RumEventExtKt;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumResourceScope;
import com.datadog.android.rum.internal.domain.scope.RumScope;
import com.datadog.android.rum.internal.vitals.VitalInfo;
import com.datadog.android.rum.internal.vitals.VitalListener;
import com.datadog.android.rum.internal.vitals.VitalMonitor;
import com.datadog.android.rum.model.ActionEvent;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.LongTaskEvent;
import com.datadog.android.rum.model.ViewEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u0000 \u009d\u00012\u00020\u0001:\u0002\u009d\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00040\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J,\u0010g\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001c2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00040\nH\u0002J\u001e\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020k2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J\u001e\u0010n\u001a\u00020i2\u0006\u0010j\u001a\u00020k2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J\u001e\u0010o\u001a\u00020i2\u0006\u0010j\u001a\u00020k2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J\u0010\u0010p\u001a\u00020i2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010q\u001a\u00020rH\u0016J\u0010\u0010s\u001a\u00020\u00152\u0006\u0010j\u001a\u00020tH\u0002J \u0010u\u001a\u0004\u0018\u00010\u00012\u0006\u0010j\u001a\u00020k2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0016J\b\u0010v\u001a\u00020ZH\u0002J\u0010\u0010w\u001a\u00020i2\u0006\u0010j\u001a\u00020xH\u0002J\u001e\u0010y\u001a\u00020i2\u0006\u0010j\u001a\u00020z2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J\u001e\u0010{\u001a\u00020i2\u0006\u0010j\u001a\u00020|2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J\u001e\u0010}\u001a\u00020i2\u0006\u0010j\u001a\u00020~2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J\u001f\u0010\u007f\u001a\u00020i2\u0007\u0010j\u001a\u00030\u0080\u00012\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J\u001f\u0010\u0081\u0001\u001a\u00020i2\u0006\u0010j\u001a\u00020t2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J\u0012\u0010\u0082\u0001\u001a\u00020i2\u0007\u0010j\u001a\u00030\u0083\u0001H\u0002J \u0010\u0084\u0001\u001a\u00020i2\u0007\u0010j\u001a\u00030\u0085\u00012\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J \u0010\u0086\u0001\u001a\u00020i2\u0007\u0010j\u001a\u00030\u0087\u00012\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J\u0012\u0010\u0088\u0001\u001a\u00020i2\u0007\u0010j\u001a\u00030\u0089\u0001H\u0002J \u0010\u008a\u0001\u001a\u00020i2\u0007\u0010j\u001a\u00030\u008b\u00012\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J\u0012\u0010\u008c\u0001\u001a\u00020i2\u0007\u0010j\u001a\u00030\u008d\u0001H\u0002J \u0010\u008e\u0001\u001a\u00020i2\u0007\u0010j\u001a\u00030\u008f\u00012\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J \u0010\u0090\u0001\u001a\u00020i2\u0007\u0010j\u001a\u00030\u0091\u00012\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J \u0010\u0092\u0001\u001a\u00020i2\u0007\u0010j\u001a\u00030\u0093\u00012\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J \u0010\u0094\u0001\u001a\u00020i2\u0007\u0010j\u001a\u00030\u0095\u00012\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J \u0010\u0096\u0001\u001a\u00020i2\u0007\u0010j\u001a\u00030\u0097\u00012\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J \u0010\u0098\u0001\u001a\u00020i2\u0007\u0010j\u001a\u00030\u0099\u00012\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J\u001f\u0010\u009a\u0001\u001a\u00020i2\u0006\u0010j\u001a\u00020k2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040mH\u0002J\u0014\u0010\u009b\u0001\u001a\u00020i2\t\u0010\u009c\u0001\u001a\u0004\u0018\u00010\u0001H\u0002R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0001X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\"\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u0012\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u000e\u00100\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010'R\u000e\u00102\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\u000404X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010:\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010;R\u0010\u0010<\u001a\u0004\u0018\u00010=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010'R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010C\u001a\u00020\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010-\"\u0004\bE\u0010FR\u001a\u0010G\u001a\u00020\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010-\"\u0004\bI\u0010FR\u001a\u0010J\u001a\u00020\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010-\"\u0004\bL\u0010FR\u001a\u0010M\u001a\u00020\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010-\"\u0004\bO\u0010FR\u001a\u0010P\u001a\u00020\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010-\"\u0004\bR\u0010FR\u000e\u0010S\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010T\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010U\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010-R\u000e\u0010W\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010X\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010Y\u001a\u00020ZX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010^R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010`R\u0014\u0010a\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010BR\u000e\u0010c\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010e\u001a\u00020\u00062\u0006\u0010d\u001a\u00020\u0006@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010B\u00a8\u0006\u009e\u0001"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumViewScope;", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "parentScope", "key", "", "name", "", "eventTime", "Lcom/datadog/android/rum/internal/domain/Time;", "initialAttributes", "", "firstPartyHostDetector", "Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;", "cpuVitalMonitor", "Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "memoryVitalMonitor", "frameRateVitalMonitor", "timeProvider", "Lcom/datadog/android/core/internal/time/TimeProvider;", "(Lcom/datadog/android/rum/internal/domain/scope/RumScope;Ljava/lang/Object;Ljava/lang/String;Lcom/datadog/android/rum/internal/domain/Time;Ljava/util/Map;Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/core/internal/time/TimeProvider;)V", "actionCount", "", "activeActionScope", "getActiveActionScope$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "setActiveActionScope$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/domain/scope/RumScope;)V", "activeResourceScopes", "", "getActiveResourceScopes$dd_sdk_android_release", "()Ljava/util/Map;", "attributes", "getAttributes$dd_sdk_android_release", "cpuTicks", "", "Ljava/lang/Double;", "cpuVitalListener", "Lcom/datadog/android/rum/internal/vitals/VitalListener;", "getCpuVitalMonitor$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "crashCount", "customTimings", "errorCount", "eventTimestamp", "getEventTimestamp$dd_sdk_android_release", "()J", "getFirstPartyHostDetector$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;", "frameRateVitalListener", "getFrameRateVitalMonitor$dd_sdk_android_release", "frozenFrameCount", "keyRef", "Ljava/lang/ref/Reference;", "getKeyRef$dd_sdk_android_release", "()Ljava/lang/ref/Reference;", "lastFrameRateInfo", "Lcom/datadog/android/rum/internal/vitals/VitalInfo;", "lastMemoryInfo", "loadingTime", "Ljava/lang/Long;", "loadingType", "Lcom/datadog/android/rum/model/ViewEvent$LoadingType;", "longTaskCount", "memoryVitalListener", "getMemoryVitalMonitor$dd_sdk_android_release", "getName$dd_sdk_android_release", "()Ljava/lang/String;", "pendingActionCount", "getPendingActionCount$dd_sdk_android_release", "setPendingActionCount$dd_sdk_android_release", "(J)V", "pendingErrorCount", "getPendingErrorCount$dd_sdk_android_release", "setPendingErrorCount$dd_sdk_android_release", "pendingFrozenFrameCount", "getPendingFrozenFrameCount$dd_sdk_android_release", "setPendingFrozenFrameCount$dd_sdk_android_release", "pendingLongTaskCount", "getPendingLongTaskCount$dd_sdk_android_release", "setPendingLongTaskCount$dd_sdk_android_release", "pendingResourceCount", "getPendingResourceCount$dd_sdk_android_release", "setPendingResourceCount$dd_sdk_android_release", "refreshRateScale", "resourceCount", "serverTimeOffsetInMs", "getServerTimeOffsetInMs$dd_sdk_android_release", "sessionId", "startedNanos", "stopped", "", "getStopped$dd_sdk_android_release", "()Z", "setStopped$dd_sdk_android_release", "(Z)V", "getTimeProvider$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/time/TimeProvider;", "url", "getUrl$dd_sdk_android_release", "version", "<set-?>", "viewId", "getViewId$dd_sdk_android_release", "addExtraAttributes", "delegateEventToAction", "", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "writer", "Lcom/datadog/android/core/internal/persistence/DataWriter;", "delegateEventToChildren", "delegateEventToResources", "detectRefreshRateScale", "getRumContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "getStartupTime", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$ApplicationStarted;", "handleEvent", "isViewComplete", "onActionDropped", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$ActionDropped;", "onActionSent", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$ActionSent;", "onAddCustomTiming", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$AddCustomTiming;", "onAddError", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$AddError;", "onAddLongTask", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$AddLongTask;", "onApplicationStarted", "onErrorDropped", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$ErrorDropped;", "onErrorSent", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$ErrorSent;", "onKeepAlive", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$KeepAlive;", "onLongTaskDropped", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$LongTaskDropped;", "onLongTaskSent", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$LongTaskSent;", "onResourceDropped", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$ResourceDropped;", "onResourceSent", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$ResourceSent;", "onStartAction", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartAction;", "onStartResource", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartResource;", "onStartView", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartView;", "onStopView", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StopView;", "onUpdateViewLoadingTime", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$UpdateViewLoadingTime;", "sendViewUpdate", "updateActiveActionScope", "scope", "Companion", "dd-sdk-android_release"})
public class RumViewScope
implements RumScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RumScope parentScope;
    @NotNull
    private final String name;
    @NotNull
    private final FirstPartyHostDetector firstPartyHostDetector;
    @NotNull
    private final VitalMonitor cpuVitalMonitor;
    @NotNull
    private final VitalMonitor memoryVitalMonitor;
    @NotNull
    private final VitalMonitor frameRateVitalMonitor;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final String url;
    @NotNull
    private final Reference<Object> keyRef;
    @NotNull
    private final Map<String, Object> attributes;
    @NotNull
    private String sessionId;
    @NotNull
    private String viewId;
    private final long startedNanos;
    private final long serverTimeOffsetInMs;
    private final long eventTimestamp;
    @Nullable
    private RumScope activeActionScope;
    @NotNull
    private final Map<String, RumScope> activeResourceScopes;
    private long resourceCount;
    private long actionCount;
    private long errorCount;
    private long crashCount;
    private long longTaskCount;
    private long frozenFrameCount;
    private long pendingResourceCount;
    private long pendingActionCount;
    private long pendingErrorCount;
    private long pendingLongTaskCount;
    private long pendingFrozenFrameCount;
    private long version;
    @Nullable
    private Long loadingTime;
    @Nullable
    private ViewEvent.LoadingType loadingType;
    @NotNull
    private final Map<String, Long> customTimings;
    private boolean stopped;
    @Nullable
    private Double cpuTicks;
    @NotNull
    private VitalListener cpuVitalListener;
    @Nullable
    private VitalInfo lastMemoryInfo;
    @NotNull
    private VitalListener memoryVitalListener;
    private double refreshRateScale;
    @Nullable
    private VitalInfo lastFrameRateInfo;
    @NotNull
    private VitalListener frameRateVitalListener;
    private static final long ONE_SECOND_NS = TimeUnit.SECONDS.toNanos(1L);
    @NotNull
    public static final String ACTION_DROPPED_WARNING = "RUM Action (%s on %s) was dropped, because another action is still active for the same view";
    @NotNull
    public static final String RUM_BACKGROUND_VIEW_URL = "com/datadog/background/view";
    @NotNull
    public static final String RUM_BACKGROUND_VIEW_NAME = "Background";
    private static final long FROZEN_FRAME_THRESHOLD_NS = TimeUnit.MILLISECONDS.toNanos(700L);
    public static final int SLOW_RENDERED_THRESHOLD_FPS = 55;

    /*
     * WARNING - void declaration
     */
    public RumViewScope(@NotNull RumScope parentScope, @NotNull Object key, @NotNull String name, @NotNull Time eventTime, @NotNull Map<String, ? extends Object> initialAttributes, @NotNull FirstPartyHostDetector firstPartyHostDetector, @NotNull VitalMonitor cpuVitalMonitor, @NotNull VitalMonitor memoryVitalMonitor, @NotNull VitalMonitor frameRateVitalMonitor, @NotNull TimeProvider timeProvider) {
        void $this$attributes_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        Intrinsics.checkNotNullParameter(initialAttributes, (String)"initialAttributes");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostDetector, (String)"firstPartyHostDetector");
        Intrinsics.checkNotNullParameter((Object)cpuVitalMonitor, (String)"cpuVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)memoryVitalMonitor, (String)"memoryVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)frameRateVitalMonitor, (String)"frameRateVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.parentScope = parentScope;
        this.name = name;
        this.firstPartyHostDetector = firstPartyHostDetector;
        this.cpuVitalMonitor = cpuVitalMonitor;
        this.memoryVitalMonitor = memoryVitalMonitor;
        this.frameRateVitalMonitor = frameRateVitalMonitor;
        this.timeProvider = timeProvider;
        this.url = StringsKt.replace$default((String)ViewUtilsKt.resolveViewUrl(key), (char)'.', (char)'/', (boolean)false, (int)4, null);
        this.keyRef = new WeakReference<Object>(key);
        Object object = MapsKt.toMutableMap(initialAttributes);
        boolean bl = false;
        boolean bl2 = false;
        Map map = object;
        RumViewScope rumViewScope = this;
        boolean bl3 = false;
        $this$attributes_u24lambda_u2d0.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        Unit unit = Unit.INSTANCE;
        rumViewScope.attributes = object;
        this.sessionId = this.parentScope.getRumContext().getSessionId();
        object = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"randomUUID().toString()");
        this.viewId = object;
        this.startedNanos = eventTime.getNanoTime();
        this.serverTimeOffsetInMs = this.timeProvider.getServerOffsetMillis();
        this.eventTimestamp = eventTime.getTimestamp() + this.serverTimeOffsetInMs;
        boolean bl4 = false;
        this.activeResourceScopes = new LinkedHashMap();
        this.version = 1L;
        bl4 = false;
        this.customTimings = new LinkedHashMap();
        this.cpuVitalListener = new VitalListener(this){
            private double initialTickCount;
            final /* synthetic */ RumViewScope this$0;
            {
                this.this$0 = $receiver;
                this.initialTickCount = Double.NaN;
            }

            public void onVitalUpdate(@NotNull VitalInfo info) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                double d = this.initialTickCount;
                boolean bl = false;
                if (Double.isNaN(d)) {
                    this.initialTickCount = info.getMaxValue();
                } else {
                    RumViewScope.access$setCpuTicks$p(this.this$0, info.getMaxValue() - this.initialTickCount);
                }
            }
        };
        this.memoryVitalListener = new VitalListener(this){
            final /* synthetic */ RumViewScope this$0;
            {
                this.this$0 = $receiver;
            }

            public void onVitalUpdate(@NotNull VitalInfo info) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                RumViewScope.access$setLastMemoryInfo$p(this.this$0, info);
            }
        };
        this.refreshRateScale = 1.0;
        this.frameRateVitalListener = new VitalListener(this){
            final /* synthetic */ RumViewScope this$0;
            {
                this.this$0 = $receiver;
            }

            public void onVitalUpdate(@NotNull VitalInfo info) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                RumViewScope.access$setLastFrameRateInfo$p(this.this$0, info);
            }
        };
        GlobalRum.INSTANCE.updateRumContext$dd_sdk_android_release(this.getRumContext());
        this.attributes.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        this.cpuVitalMonitor.register(this.cpuVitalListener);
        this.memoryVitalMonitor.register(this.memoryVitalListener);
        this.frameRateVitalMonitor.register(this.frameRateVitalListener);
        this.detectRefreshRateScale(key);
    }

    @NotNull
    public final String getName$dd_sdk_android_release() {
        return this.name;
    }

    @NotNull
    public final FirstPartyHostDetector getFirstPartyHostDetector$dd_sdk_android_release() {
        return this.firstPartyHostDetector;
    }

    @NotNull
    public final VitalMonitor getCpuVitalMonitor$dd_sdk_android_release() {
        return this.cpuVitalMonitor;
    }

    @NotNull
    public final VitalMonitor getMemoryVitalMonitor$dd_sdk_android_release() {
        return this.memoryVitalMonitor;
    }

    @NotNull
    public final VitalMonitor getFrameRateVitalMonitor$dd_sdk_android_release() {
        return this.frameRateVitalMonitor;
    }

    @NotNull
    public final TimeProvider getTimeProvider$dd_sdk_android_release() {
        return this.timeProvider;
    }

    @NotNull
    public final String getUrl$dd_sdk_android_release() {
        return this.url;
    }

    @NotNull
    public final Reference<Object> getKeyRef$dd_sdk_android_release() {
        return this.keyRef;
    }

    @NotNull
    public final Map<String, Object> getAttributes$dd_sdk_android_release() {
        return this.attributes;
    }

    @NotNull
    public final String getViewId$dd_sdk_android_release() {
        return this.viewId;
    }

    public final long getServerTimeOffsetInMs$dd_sdk_android_release() {
        return this.serverTimeOffsetInMs;
    }

    public final long getEventTimestamp$dd_sdk_android_release() {
        return this.eventTimestamp;
    }

    @Nullable
    public final RumScope getActiveActionScope$dd_sdk_android_release() {
        return this.activeActionScope;
    }

    public final void setActiveActionScope$dd_sdk_android_release(@Nullable RumScope rumScope) {
        this.activeActionScope = rumScope;
    }

    @NotNull
    public final Map<String, RumScope> getActiveResourceScopes$dd_sdk_android_release() {
        return this.activeResourceScopes;
    }

    public final long getPendingResourceCount$dd_sdk_android_release() {
        return this.pendingResourceCount;
    }

    public final void setPendingResourceCount$dd_sdk_android_release(long l) {
        this.pendingResourceCount = l;
    }

    public final long getPendingActionCount$dd_sdk_android_release() {
        return this.pendingActionCount;
    }

    public final void setPendingActionCount$dd_sdk_android_release(long l) {
        this.pendingActionCount = l;
    }

    public final long getPendingErrorCount$dd_sdk_android_release() {
        return this.pendingErrorCount;
    }

    public final void setPendingErrorCount$dd_sdk_android_release(long l) {
        this.pendingErrorCount = l;
    }

    public final long getPendingLongTaskCount$dd_sdk_android_release() {
        return this.pendingLongTaskCount;
    }

    public final void setPendingLongTaskCount$dd_sdk_android_release(long l) {
        this.pendingLongTaskCount = l;
    }

    public final long getPendingFrozenFrameCount$dd_sdk_android_release() {
        return this.pendingFrozenFrameCount;
    }

    public final void setPendingFrozenFrameCount$dd_sdk_android_release(long l) {
        this.pendingFrozenFrameCount = l;
    }

    public final boolean getStopped$dd_sdk_android_release() {
        return this.stopped;
    }

    public final void setStopped$dd_sdk_android_release(boolean bl) {
        this.stopped = bl;
    }

    @Override
    @Nullable
    public RumScope handleEvent(@NotNull RumRawEvent event, @NotNull DataWriter<Object> writer) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        RumRawEvent rumRawEvent = event;
        if (rumRawEvent instanceof RumRawEvent.ResourceSent) {
            this.onResourceSent((RumRawEvent.ResourceSent)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.ActionSent) {
            this.onActionSent((RumRawEvent.ActionSent)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.ErrorSent) {
            this.onErrorSent((RumRawEvent.ErrorSent)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.LongTaskSent) {
            this.onLongTaskSent((RumRawEvent.LongTaskSent)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.ResourceDropped) {
            this.onResourceDropped((RumRawEvent.ResourceDropped)event);
        } else if (rumRawEvent instanceof RumRawEvent.ActionDropped) {
            this.onActionDropped((RumRawEvent.ActionDropped)event);
        } else if (rumRawEvent instanceof RumRawEvent.ErrorDropped) {
            this.onErrorDropped((RumRawEvent.ErrorDropped)event);
        } else if (rumRawEvent instanceof RumRawEvent.LongTaskDropped) {
            this.onLongTaskDropped((RumRawEvent.LongTaskDropped)event);
        } else if (rumRawEvent instanceof RumRawEvent.StartView) {
            this.onStartView((RumRawEvent.StartView)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.StopView) {
            this.onStopView((RumRawEvent.StopView)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.StartAction) {
            this.onStartAction((RumRawEvent.StartAction)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.StartResource) {
            this.onStartResource((RumRawEvent.StartResource)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.AddError) {
            this.onAddError((RumRawEvent.AddError)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.AddLongTask) {
            this.onAddLongTask((RumRawEvent.AddLongTask)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.ApplicationStarted) {
            this.onApplicationStarted((RumRawEvent.ApplicationStarted)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.UpdateViewLoadingTime) {
            this.onUpdateViewLoadingTime((RumRawEvent.UpdateViewLoadingTime)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.AddCustomTiming) {
            this.onAddCustomTiming((RumRawEvent.AddCustomTiming)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.KeepAlive) {
            this.onKeepAlive((RumRawEvent.KeepAlive)event, writer);
        } else {
            this.delegateEventToChildren(event, writer);
        }
        return this.isViewComplete() ? (RumScope)null : (RumScope)this;
    }

    @Override
    @NotNull
    public RumContext getRumContext() {
        RumScope rumScope;
        Object object;
        RumContext parentContext = this.parentScope.getRumContext();
        if (!Intrinsics.areEqual((Object)parentContext.getSessionId(), (Object)this.sessionId)) {
            this.sessionId = parentContext.getSessionId();
            object = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"randomUUID().toString()");
            this.viewId = object;
        }
        object = (rumScope = this.activeActionScope) instanceof RumActionScope ? (RumActionScope)rumScope : null;
        return RumContext.copy$default(parentContext, null, null, this.viewId, this.name, this.url, object == null ? null : ((RumActionScope)object).getActionId$dd_sdk_android_release(), 3, null);
    }

    private final void onStartView(RumRawEvent.StartView event, DataWriter<Object> writer) {
        if (!this.stopped) {
            this.stopped = true;
            this.sendViewUpdate(event, writer);
            this.delegateEventToChildren(event, writer);
        }
    }

    private final void onStopView(RumRawEvent.StopView event, DataWriter<Object> writer) {
        boolean shouldStop;
        this.delegateEventToChildren(event, writer);
        Object startedKey = this.keyRef.get();
        boolean bl = shouldStop = Intrinsics.areEqual((Object)event.getKey(), (Object)startedKey) || startedKey == null;
        if (shouldStop && !this.stopped) {
            this.attributes.putAll(event.getAttributes());
            this.stopped = true;
            this.sendViewUpdate(event, writer);
        }
    }

    private final void onStartAction(RumRawEvent.StartAction event, DataWriter<Object> writer) {
        this.delegateEventToChildren(event, writer);
        if (this.stopped) {
            return;
        }
        if (this.activeActionScope != null) {
            if (event.getType() == RumActionType.CUSTOM && !event.getWaitForStop()) {
                RumScope customActionScope = RumActionScope.Companion.fromEvent(this, event, this.serverTimeOffsetInMs);
                RumViewScope rumViewScope = this;
                long l = rumViewScope.pendingActionCount;
                rumViewScope.pendingActionCount = l + 1L;
                customActionScope.handleEvent(new RumRawEvent.SendCustomActionNow(null, 1, null), writer);
                return;
            }
            Logger logger = RuntimeUtilsKt.getDevLogger();
            String string = ACTION_DROPPED_WARNING;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{event.getType(), event.getName()};
            boolean bl = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
            Logger.w$default(logger, string2, null, null, 6, null);
            return;
        }
        this.updateActiveActionScope(RumActionScope.Companion.fromEvent(this, event, this.serverTimeOffsetInMs));
        RumViewScope rumViewScope = this;
        long l = rumViewScope.pendingActionCount;
        rumViewScope.pendingActionCount = l + 1L;
    }

    private final void onStartResource(RumRawEvent.StartResource event, DataWriter<Object> writer) {
        this.delegateEventToChildren(event, writer);
        if (this.stopped) {
            return;
        }
        RumRawEvent.StartResource updatedEvent = RumRawEvent.StartResource.copy$default(event, null, null, null, this.addExtraAttributes(event.getAttributes()), null, 23, null);
        Object object = this.activeResourceScopes;
        String string = event.getKey();
        RumScope rumScope = RumResourceScope.Companion.fromEvent(this, updatedEvent, this.firstPartyHostDetector, this.serverTimeOffsetInMs);
        boolean bl = false;
        object.put((String)string, (RumScope)rumScope);
        object = this;
        long l = ((RumViewScope)object).pendingResourceCount;
        ((RumViewScope)object).pendingResourceCount = l + 1L;
    }

    private final void onAddError(RumRawEvent.AddError event, DataWriter<Object> writer) {
        boolean bl;
        Object object;
        ErrorEvent.Action action;
        Object object2;
        Object object3;
        Throwable throwable;
        this.delegateEventToChildren(event, writer);
        if (this.stopped) {
            return;
        }
        RumContext context = this.getRumContext();
        UserInfo user = CoreFeature.INSTANCE.getUserInfoProvider$dd_sdk_android_release().getUserInfo();
        Map<String, Object> updatedAttributes = this.addExtraAttributes(event.getAttributes());
        Object object4 = updatedAttributes.remove("_dd.error.is_crash");
        Boolean isFatal = object4 instanceof Boolean ? (Boolean)object4 : null;
        NetworkInfo networkInfo = CoreFeature.INSTANCE.getNetworkInfoProvider$dd_sdk_android_release().getLatestNetworkInfo();
        String string = event.getType();
        String errorType = string == null ? ((throwable = event.getThrowable()) == null ? null : ((object3 = throwable.getClass()) == null ? null : ((Class)object3).getCanonicalName())) : string;
        throwable = event.getThrowable();
        String throwableMessage = throwable == null ? "" : ((object3 = throwable.getMessage()) == null ? "" : object3);
        object3 = throwableMessage;
        boolean bl2 = false;
        String message = !StringsKt.isBlank((CharSequence)object3) && !Intrinsics.areEqual((Object)event.getMessage(), (Object)throwableMessage) ? event.getMessage() + ": " + throwableMessage : event.getMessage();
        long l = event.getEventTime().getTimestamp() + this.serverTimeOffsetInMs;
        Object object5 = event.getStacktrace();
        ErrorEvent.Error error = new ErrorEvent.Error(null, message, RumEventExtKt.toSchemaSource(event.getSource()), (String)(object5 == null ? ((object2 = event.getThrowable()) == null ? null : ThrowableExtKt.loggableStackTrace((Throwable)object2)) : object5), event.isFatal() || ((object5 = isFatal) == null ? false : (Boolean)object5), errorType, null, null, RumEventExtKt.toSchemaSourceType(event.getSourceType()), null, 705, null);
        object2 = context.getActionId();
        if (object2 == null) {
            action = null;
        } else {
            object = object2;
            boolean bl3 = false;
            bl = false;
            Object it = object;
            boolean bl4 = false;
            action = new ErrorEvent.Action((String)it);
        }
        object5 = action;
        Object object6 = context.getViewId();
        bl = false;
        Object object7 = object6;
        if (object7 == null) {
            object7 = "";
        }
        object = object7;
        object6 = context.getViewName();
        Object object8 = context.getViewUrl();
        boolean bl5 = false;
        Object object9 = object8;
        if (object9 == null) {
            object9 = "";
        }
        Object object10 = object9;
        object2 = new ErrorEvent.View((String)object, null, (String)object10, (String)object6, null, 18, null);
        object = new ErrorEvent.Usr(user.getId(), user.getName(), user.getEmail(), user.getAdditionalProperties());
        object6 = RumEventExtKt.toErrorConnectivity(networkInfo);
        object10 = new ErrorEvent.Application(context.getApplicationId());
        object8 = new ErrorEvent.ErrorEventSession(context.getSessionId(), ErrorEvent.ErrorEventSessionType.USER, null, 4, null);
        ErrorEvent.Context context2 = new ErrorEvent.Context(updatedAttributes);
        ErrorEvent.Dd dd = new ErrorEvent.Dd(new ErrorEvent.DdSession(ErrorEvent.Plan.PLAN_1));
        ErrorEvent errorEvent = new ErrorEvent(l, (ErrorEvent.Application)object10, null, (ErrorEvent.ErrorEventSession)object8, (ErrorEvent.View)object2, (ErrorEvent.Usr)object, (ErrorEvent.Connectivity)object6, null, dd, context2, error, (ErrorEvent.Action)object5, 132, null);
        writer.write(errorEvent);
        if (event.isFatal()) {
            RumViewScope rumViewScope = this;
            long l2 = rumViewScope.errorCount;
            rumViewScope.errorCount = l2 + 1L;
            rumViewScope = this;
            l2 = rumViewScope.crashCount;
            rumViewScope.crashCount = l2 + 1L;
            this.sendViewUpdate(event, writer);
        } else {
            RumViewScope rumViewScope = this;
            long l3 = rumViewScope.pendingErrorCount;
            rumViewScope.pendingErrorCount = l3 + 1L;
        }
    }

    private final void onAddCustomTiming(RumRawEvent.AddCustomTiming event, DataWriter<Object> writer) {
        Map<String, Long> map = this.customTimings;
        String string = event.getName();
        long l = event.getEventTime().getNanoTime() - this.startedNanos;
        long l2 = 1L;
        boolean bl = false;
        Long l3 = Math.max(l, l2);
        boolean bl2 = false;
        map.put(string, l3);
        this.sendViewUpdate(event, writer);
    }

    private final void onKeepAlive(RumRawEvent.KeepAlive event, DataWriter<Object> writer) {
        this.delegateEventToChildren(event, writer);
        if (this.stopped) {
            return;
        }
        this.sendViewUpdate(event, writer);
    }

    private final void delegateEventToChildren(RumRawEvent event, DataWriter<Object> writer) {
        this.delegateEventToResources(event, writer);
        this.delegateEventToAction(event, writer);
    }

    private final void delegateEventToAction(RumRawEvent event, DataWriter<Object> writer) {
        RumScope updatedAction;
        RumScope currentAction = this.activeActionScope;
        if (currentAction != null && (updatedAction = currentAction.handleEvent(event, writer)) == null) {
            this.updateActiveActionScope(null);
        }
    }

    private final void updateActiveActionScope(RumScope scope) {
        this.activeActionScope = scope;
        GlobalRum.INSTANCE.updateRumContext$dd_sdk_android_release(this.getRumContext());
    }

    private final void delegateEventToResources(RumRawEvent event, DataWriter<Object> writer) {
        Map<String, RumScope> map = this.activeResourceScopes;
        boolean bl = false;
        Iterator<Map.Entry<String, RumScope>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, RumScope> entry = iterator.next();
            RumScope scope = entry.getValue().handleEvent(event, writer);
            if (scope != null) continue;
            iterator.remove();
        }
    }

    private final void onResourceSent(RumRawEvent.ResourceSent event, DataWriter<Object> writer) {
        if (Intrinsics.areEqual((Object)event.getViewId(), (Object)this.viewId)) {
            RumViewScope rumViewScope = this;
            long l = rumViewScope.pendingResourceCount;
            rumViewScope.pendingResourceCount = l + -1L;
            rumViewScope = this;
            l = rumViewScope.resourceCount;
            rumViewScope.resourceCount = l + 1L;
            this.sendViewUpdate(event, writer);
        }
    }

    private final void onActionSent(RumRawEvent.ActionSent event, DataWriter<Object> writer) {
        if (Intrinsics.areEqual((Object)event.getViewId(), (Object)this.viewId)) {
            RumViewScope rumViewScope = this;
            long l = rumViewScope.pendingActionCount;
            rumViewScope.pendingActionCount = l + -1L;
            rumViewScope = this;
            l = rumViewScope.actionCount;
            rumViewScope.actionCount = l + 1L;
            this.sendViewUpdate(event, writer);
        }
    }

    private final void onErrorSent(RumRawEvent.ErrorSent event, DataWriter<Object> writer) {
        if (Intrinsics.areEqual((Object)event.getViewId(), (Object)this.viewId)) {
            RumViewScope rumViewScope = this;
            long l = rumViewScope.pendingErrorCount;
            rumViewScope.pendingErrorCount = l + -1L;
            rumViewScope = this;
            l = rumViewScope.errorCount;
            rumViewScope.errorCount = l + 1L;
            this.sendViewUpdate(event, writer);
        }
    }

    private final void onLongTaskSent(RumRawEvent.LongTaskSent event, DataWriter<Object> writer) {
        if (Intrinsics.areEqual((Object)event.getViewId(), (Object)this.viewId)) {
            RumViewScope rumViewScope = this;
            long l = rumViewScope.pendingLongTaskCount;
            rumViewScope.pendingLongTaskCount = l + -1L;
            rumViewScope = this;
            l = rumViewScope.longTaskCount;
            rumViewScope.longTaskCount = l + 1L;
            if (event.isFrozenFrame()) {
                rumViewScope = this;
                l = rumViewScope.pendingFrozenFrameCount;
                rumViewScope.pendingFrozenFrameCount = l + -1L;
                rumViewScope = this;
                l = rumViewScope.frozenFrameCount;
                rumViewScope.frozenFrameCount = l + 1L;
            }
            this.sendViewUpdate(event, writer);
        }
    }

    private final void onResourceDropped(RumRawEvent.ResourceDropped event) {
        if (Intrinsics.areEqual((Object)event.getViewId(), (Object)this.viewId)) {
            RumViewScope rumViewScope = this;
            long l = rumViewScope.pendingResourceCount;
            rumViewScope.pendingResourceCount = l + -1L;
        }
    }

    private final void onActionDropped(RumRawEvent.ActionDropped event) {
        if (Intrinsics.areEqual((Object)event.getViewId(), (Object)this.viewId)) {
            RumViewScope rumViewScope = this;
            long l = rumViewScope.pendingActionCount;
            rumViewScope.pendingActionCount = l + -1L;
        }
    }

    private final void onErrorDropped(RumRawEvent.ErrorDropped event) {
        if (Intrinsics.areEqual((Object)event.getViewId(), (Object)this.viewId)) {
            RumViewScope rumViewScope = this;
            long l = rumViewScope.pendingErrorCount;
            rumViewScope.pendingErrorCount = l + -1L;
        }
    }

    private final void onLongTaskDropped(RumRawEvent.LongTaskDropped event) {
        if (Intrinsics.areEqual((Object)event.getViewId(), (Object)this.viewId)) {
            RumViewScope rumViewScope = this;
            long l = rumViewScope.pendingLongTaskCount;
            rumViewScope.pendingLongTaskCount = l + -1L;
            if (event.isFrozenFrame()) {
                rumViewScope = this;
                l = rumViewScope.pendingFrozenFrameCount;
                rumViewScope.pendingFrozenFrameCount = l + -1L;
            }
        }
    }

    private final void sendViewUpdate(RumRawEvent event, DataWriter<Object> writer) {
        Double d;
        boolean bl;
        double d2;
        Double d3;
        Object object;
        Double d4;
        this.attributes.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        RumViewScope rumViewScope = this;
        long l = rumViewScope.version;
        rumViewScope.version = l + 1L;
        long updatedDurationNs = event.getEventTime().getNanoTime() - this.startedNanos;
        RumContext context = this.getRumContext();
        UserInfo user = CoreFeature.INSTANCE.getUserInfoProvider$dd_sdk_android_release().getUserInfo();
        Map<String, Long> map = this.customTimings;
        boolean bl2 = false;
        ViewEvent.CustomTimings timings = !map.isEmpty() ? new ViewEvent.CustomTimings((Map<String, Long>)new LinkedHashMap<String, Long>(this.customTimings)) : (ViewEvent.CustomTimings)null;
        VitalInfo memoryInfo = this.lastMemoryInfo;
        VitalInfo refreshRateInfo = this.lastFrameRateInfo;
        Boolean isSlowRendered = refreshRateInfo == null ? (Boolean)null : Boolean.valueOf(refreshRateInfo.getMeanValue() < 55.0);
        long l2 = this.eventTimestamp;
        Object object2 = context.getViewId();
        boolean bl3 = false;
        Object object3 = object2;
        if (object3 == null) {
            object3 = "";
        }
        Object object4 = object3;
        Object object5 = context.getViewName();
        boolean bl4 = false;
        Object object6 = object5;
        if (object6 == null) {
            object6 = "";
        }
        object2 = object6;
        Object object7 = context.getViewUrl();
        boolean bl5 = false;
        Object object8 = object7;
        if (object8 == null) {
            object8 = "";
        }
        object5 = object8;
        object7 = this.loadingTime;
        Object object9 = this.loadingType;
        ViewEvent.Action action = new ViewEvent.Action(this.actionCount);
        ViewEvent.Resource resource = new ViewEvent.Resource(this.resourceCount);
        Object object10 = new ViewEvent.Error(this.errorCount);
        ViewEvent.Crash crash = new ViewEvent.Crash(this.crashCount);
        ViewEvent.LongTask longTask = new ViewEvent.LongTask(this.longTaskCount);
        ViewEvent.FrozenFrame frozenFrame = new ViewEvent.FrozenFrame(this.frozenFrameCount);
        boolean bl6 = !this.stopped;
        Double d5 = this.cpuTicks;
        Double d6 = this.cpuTicks;
        if (d6 == null) {
            d4 = null;
        } else {
            object = d6;
            boolean bl7 = false;
            boolean bl8 = false;
            double it = ((Number)object).doubleValue();
            boolean bl9 = false;
            d4 = it * (double)ONE_SECOND_NS / (double)updatedDurationNs;
        }
        Double d7 = d4;
        object = memoryInfo;
        d6 = object == null ? null : Double.valueOf(((VitalInfo)object).getMeanValue());
        VitalInfo vitalInfo = memoryInfo;
        object = vitalInfo == null ? null : Double.valueOf(vitalInfo.getMaxValue());
        VitalInfo vitalInfo2 = refreshRateInfo;
        if (vitalInfo2 == null) {
            d3 = null;
        } else {
            double d8;
            d2 = d8 = vitalInfo2.getMeanValue();
            boolean bl10 = false;
            bl = false;
            double it = d2;
            boolean bl11 = false;
            d3 = it * this.refreshRateScale;
        }
        vitalInfo = d3;
        VitalInfo vitalInfo3 = refreshRateInfo;
        if (vitalInfo3 == null) {
            d = null;
        } else {
            double d9 = d2 = vitalInfo3.getMinValue();
            bl = false;
            boolean bl12 = false;
            double it = d9;
            boolean bl13 = false;
            d = it * this.refreshRateScale;
        }
        vitalInfo2 = d;
        ViewEvent.View view = new ViewEvent.View((String)object4, null, (String)object5, (String)object2, (Long)object7, (ViewEvent.LoadingType)((Object)object9), updatedDurationNs, null, null, null, null, null, null, null, null, null, timings, bl6, isSlowRendered, action, (ViewEvent.Error)object10, crash, longTask, frozenFrame, resource, null, d6, (Number)object, d5, d7, (Number)((Object)vitalInfo), (Number)((Object)vitalInfo2), 33619842, null);
        object4 = new ViewEvent.Usr(user.getId(), user.getName(), user.getEmail(), user.getAdditionalProperties());
        object2 = new ViewEvent.Application(context.getApplicationId());
        object5 = new ViewEvent.ViewEventSession(context.getSessionId(), ViewEvent.Type.USER, null, 4, null);
        object7 = new ViewEvent.Context(this.attributes);
        long l3 = this.version;
        object10 = new ViewEvent.DdSession(ViewEvent.Plan.PLAN_1);
        object9 = new ViewEvent.Dd((ViewEvent.DdSession)object10, l3);
        ViewEvent viewEvent = new ViewEvent(l2, (ViewEvent.Application)object2, null, (ViewEvent.ViewEventSession)object5, view, (ViewEvent.Usr)object4, null, null, (ViewEvent.Dd)object9, (ViewEvent.Context)object7, 196, null);
        writer.write(viewEvent);
    }

    private final Map<String, Object> addExtraAttributes(Map<String, ? extends Object> attributes) {
        Map map = MapsKt.toMutableMap(attributes);
        boolean bl = false;
        boolean bl2 = false;
        Map $this$addExtraAttributes_u24lambda_u2d5 = map;
        boolean bl3 = false;
        $this$addExtraAttributes_u24lambda_u2d5.putAll(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        return map;
    }

    private final void onUpdateViewLoadingTime(RumRawEvent.UpdateViewLoadingTime event, DataWriter<Object> writer) {
        Object startedKey = this.keyRef.get();
        if (!Intrinsics.areEqual((Object)event.getKey(), (Object)startedKey)) {
            return;
        }
        this.loadingTime = event.getLoadingTime();
        this.loadingType = event.getLoadingType();
        this.sendViewUpdate(event, writer);
    }

    private final void onApplicationStarted(RumRawEvent.ApplicationStarted event, DataWriter<Object> writer) {
        RumViewScope rumViewScope = this;
        long l = rumViewScope.pendingActionCount;
        rumViewScope.pendingActionCount = l + 1L;
        RumContext context = this.getRumContext();
        UserInfo user = CoreFeature.INSTANCE.getUserInfoProvider$dd_sdk_android_release().getUserInfo();
        long l2 = this.eventTimestamp;
        ActionEvent.Action action = new ActionEvent.Action(ActionEvent.ActionType.APPLICATION_START, UUID.randomUUID().toString(), this.getStartupTime(event), null, null, null, null, null, 248, null);
        Object object = context.getViewId();
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = "";
        }
        Object object3 = object2;
        object = context.getViewName();
        Object object4 = context.getViewUrl();
        boolean bl2 = false;
        Object object5 = object4;
        if (object5 == null) {
            object5 = "";
        }
        Object object6 = object5;
        ActionEvent.View view = new ActionEvent.View((String)object3, null, (String)object6, (String)object, null, 18, null);
        object3 = new ActionEvent.Usr(user.getId(), user.getName(), user.getEmail(), user.getAdditionalProperties());
        object = new ActionEvent.Application(context.getApplicationId());
        object6 = new ActionEvent.ActionEventSession(context.getSessionId(), ActionEvent.ActionEventSessionType.USER, null, 4, null);
        object4 = new ActionEvent.Context(GlobalRum.INSTANCE.getGlobalAttributes$dd_sdk_android_release());
        ActionEvent.Dd dd = new ActionEvent.Dd(new ActionEvent.DdSession(ActionEvent.Plan.PLAN_1));
        ActionEvent actionEvent = new ActionEvent(l2, (ActionEvent.Application)object, null, (ActionEvent.ActionEventSession)object6, view, (ActionEvent.Usr)object3, null, null, dd, (ActionEvent.Context)object4, action, 196, null);
        writer.write(actionEvent);
    }

    private final long getStartupTime(RumRawEvent.ApplicationStarted event) {
        long now = event.getEventTime().getNanoTime();
        long startupTime = event.getApplicationStartupNanos();
        long l = now - startupTime;
        long l2 = 1L;
        boolean bl = false;
        return Math.max(l, l2);
    }

    private final void onAddLongTask(RumRawEvent.AddLongTask event, DataWriter<Object> writer) {
        boolean bl;
        Object object;
        LongTaskEvent.Action action;
        this.delegateEventToChildren(event, writer);
        if (this.stopped) {
            return;
        }
        RumContext context = this.getRumContext();
        UserInfo user = CoreFeature.INSTANCE.getUserInfoProvider$dd_sdk_android_release().getUserInfo();
        Map<String, Object> updatedAttributes = this.addExtraAttributes(MapsKt.mapOf((Pair)TuplesKt.to((Object)"long_task.target", (Object)event.getTarget())));
        NetworkInfo networkInfo = CoreFeature.INSTANCE.getNetworkInfoProvider$dd_sdk_android_release().getLatestNetworkInfo();
        long timestamp = event.getEventTime().getTimestamp() + this.serverTimeOffsetInMs;
        boolean isFrozenFrame = event.getDurationNs() > FROZEN_FRAME_THRESHOLD_NS;
        long l = timestamp - TimeUnit.NANOSECONDS.toMillis(event.getDurationNs());
        LongTaskEvent.LongTask longTask = new LongTaskEvent.LongTask(null, event.getDurationNs(), isFrozenFrame, 1, null);
        Object object2 = context.getActionId();
        if (object2 == null) {
            action = null;
        } else {
            object = object2;
            boolean bl2 = false;
            bl = false;
            String it = object;
            boolean bl3 = false;
            action = new LongTaskEvent.Action(it);
        }
        LongTaskEvent.Action action2 = action;
        Object object3 = context.getViewId();
        bl = false;
        Object object4 = object3;
        if (object4 == null) {
            object4 = "";
        }
        object = object4;
        object3 = context.getViewName();
        Object object5 = context.getViewUrl();
        boolean bl4 = false;
        Object object6 = object5;
        if (object6 == null) {
            object6 = "";
        }
        Object object7 = object6;
        object2 = new LongTaskEvent.View((String)object, null, (String)object7, (String)object3, 2, null);
        object = new LongTaskEvent.Usr(user.getId(), user.getName(), user.getEmail(), user.getAdditionalProperties());
        object3 = RumEventExtKt.toLongTaskConnectivity(networkInfo);
        object7 = new LongTaskEvent.Application(context.getApplicationId());
        object5 = new LongTaskEvent.LongTaskEventSession(context.getSessionId(), LongTaskEvent.Type.USER, null, 4, null);
        LongTaskEvent.Context context2 = new LongTaskEvent.Context(updatedAttributes);
        LongTaskEvent.Dd dd = new LongTaskEvent.Dd(new LongTaskEvent.DdSession(LongTaskEvent.Plan.PLAN_1));
        LongTaskEvent longTaskEvent = new LongTaskEvent(l, (LongTaskEvent.Application)object7, null, (LongTaskEvent.LongTaskEventSession)object5, (LongTaskEvent.View)object2, (LongTaskEvent.Usr)object, (LongTaskEvent.Connectivity)object3, null, dd, context2, longTask, action2, 132, null);
        writer.write(longTaskEvent);
        RumViewScope rumViewScope = this;
        long l2 = rumViewScope.pendingLongTaskCount;
        rumViewScope.pendingLongTaskCount = l2 + 1L;
        if (isFrozenFrame) {
            rumViewScope = this;
            l2 = rumViewScope.pendingFrozenFrameCount;
            rumViewScope.pendingFrozenFrameCount = l2 + 1L;
        }
    }

    private final boolean isViewComplete() {
        long pending = this.pendingActionCount + this.pendingResourceCount + this.pendingErrorCount + this.pendingLongTaskCount;
        return this.stopped && this.activeResourceScopes.isEmpty() && pending <= 0L;
    }

    private final void detectRefreshRateScale(Object key) {
        Display display;
        Object object;
        Activity activity;
        Object object2 = key;
        Object object3 = object2 instanceof Activity ? (Activity)key : (object2 instanceof androidx.fragment.app.Fragment ? (Activity)((androidx.fragment.app.Fragment)key).getActivity() : (activity = object2 instanceof Fragment ? ((Fragment)key).getActivity() : null));
        if (activity == null) {
            return;
        }
        Activity activity2 = activity;
        if (Build.VERSION.SDK_INT >= 30) {
            object = activity2.getDisplay();
        } else {
            Object object4 = activity2.getSystemService("window");
            WindowManager windowManager = object4 instanceof WindowManager ? (WindowManager)object4 : null;
            object = display = windowManager == null ? null : windowManager.getDefaultDisplay();
        }
        if (display == null) {
            return;
        }
        Object display2 = object2 = display;
        this.refreshRateScale = 60.0 / (double)display2.getRefreshRate();
    }

    public static final /* synthetic */ void access$setCpuTicks$p(RumViewScope $this, Double d) {
        $this.cpuTicks = d;
    }

    public static final /* synthetic */ void access$setLastMemoryInfo$p(RumViewScope $this, VitalInfo vitalInfo) {
        $this.lastMemoryInfo = vitalInfo;
    }

    public static final /* synthetic */ void access$setLastFrameRateInfo$p(RumViewScope $this, VitalInfo vitalInfo) {
        $this.lastFrameRateInfo = vitalInfo;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JE\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumViewScope$Companion;", "", "()V", "ACTION_DROPPED_WARNING", "", "FROZEN_FRAME_THRESHOLD_NS", "", "getFROZEN_FRAME_THRESHOLD_NS$dd_sdk_android_release", "()J", "ONE_SECOND_NS", "getONE_SECOND_NS$dd_sdk_android_release", "RUM_BACKGROUND_VIEW_NAME", "RUM_BACKGROUND_VIEW_URL", "SLOW_RENDERED_THRESHOLD_FPS", "", "fromEvent", "Lcom/datadog/android/rum/internal/domain/scope/RumViewScope;", "parentScope", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartView;", "firstPartyHostDetector", "Lcom/datadog/android/core/internal/net/FirstPartyHostDetector;", "cpuVitalMonitor", "Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "memoryVitalMonitor", "frameRateVitalMonitor", "timeProvider", "Lcom/datadog/android/core/internal/time/TimeProvider;", "fromEvent$dd_sdk_android_release", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getONE_SECOND_NS$dd_sdk_android_release() {
            return ONE_SECOND_NS;
        }

        public final long getFROZEN_FRAME_THRESHOLD_NS$dd_sdk_android_release() {
            return FROZEN_FRAME_THRESHOLD_NS;
        }

        @NotNull
        public final RumViewScope fromEvent$dd_sdk_android_release(@NotNull RumScope parentScope, @NotNull RumRawEvent.StartView event, @NotNull FirstPartyHostDetector firstPartyHostDetector, @NotNull VitalMonitor cpuVitalMonitor, @NotNull VitalMonitor memoryVitalMonitor, @NotNull VitalMonitor frameRateVitalMonitor, @NotNull TimeProvider timeProvider) {
            Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)firstPartyHostDetector, (String)"firstPartyHostDetector");
            Intrinsics.checkNotNullParameter((Object)cpuVitalMonitor, (String)"cpuVitalMonitor");
            Intrinsics.checkNotNullParameter((Object)memoryVitalMonitor, (String)"memoryVitalMonitor");
            Intrinsics.checkNotNullParameter((Object)frameRateVitalMonitor, (String)"frameRateVitalMonitor");
            Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
            return new RumViewScope(parentScope, event.getKey(), event.getName(), event.getEventTime(), event.getAttributes(), firstPartyHostDetector, cpuVitalMonitor, memoryVitalMonitor, frameRateVitalMonitor, timeProvider);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

