/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.event;

import com.datadog.android.core.internal.persistence.Deserializer;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.Logger;
import com.datadog.android.rum.model.ActionEvent;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.LongTaskEvent;
import com.datadog.android.rum.model.ResourceEvent;
import com.datadog.android.rum.model.ViewEvent;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/rum/internal/domain/event/RumEventDeserializer;", "Lcom/datadog/android/core/internal/persistence/Deserializer;", "", "()V", "deserialize", "model", "", "parseEvent", "eventType", "jsonString", "Companion", "dd-sdk-android_release"})
public final class RumEventDeserializer
implements Deserializer<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String EVENT_TYPE_KEY_NAME = "type";
    @NotNull
    public static final String EVENT_TYPE_VIEW = "view";
    @NotNull
    public static final String EVENT_TYPE_RESOURCE = "resource";
    @NotNull
    public static final String EVENT_TYPE_ACTION = "action";
    @NotNull
    public static final String EVENT_TYPE_ERROR = "error";
    @NotNull
    public static final String EVENT_TYPE_LONG_TASK = "long_task";
    @NotNull
    public static final String DESERIALIZE_ERROR_MESSAGE_FORMAT = "Error while trying to deserialize the serialized RumEvent: %s";

    @Override
    @Nullable
    public Object deserialize(@NotNull String model) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        try {
            JsonObject jsonObject = JsonParser.parseString((String)model).getAsJsonObject();
            JsonPrimitive jsonPrimitive = jsonObject.getAsJsonPrimitive(EVENT_TYPE_KEY_NAME);
            object = this.parseEvent(jsonPrimitive == null ? null : jsonPrimitive.getAsString(), model);
        }
        catch (JsonParseException e) {
            Logger logger = RuntimeUtilsKt.getSdkLogger();
            String string = DESERIALIZE_ERROR_MESSAGE_FORMAT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{model};
            boolean bl = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
            Logger.e$default(logger, string2, e, null, 4, null);
            object = null;
        }
        catch (IllegalStateException e) {
            Logger logger = RuntimeUtilsKt.getSdkLogger();
            String string = DESERIALIZE_ERROR_MESSAGE_FORMAT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{model};
            boolean bl = false;
            String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, this, *args)");
            Logger.e$default(logger, string3, e, null, 4, null);
            object = null;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object parseEvent(String eventType, String jsonString) throws JsonParseException {
        String string = eventType;
        if (string == null) throw new JsonParseException(Intrinsics.stringPlus((String)"We could not deserialize the event with type: ", (Object)eventType));
        int n = -1;
        switch (string.hashCode()) {
            case 3619493: {
                if (string.equals(EVENT_TYPE_VIEW)) {
                    n = 1;
                }
                break;
            }
            case -341064690: {
                if (string.equals(EVENT_TYPE_RESOURCE)) {
                    n = 2;
                }
                break;
            }
            case -1422950858: {
                if (string.equals(EVENT_TYPE_ACTION)) {
                    n = 3;
                }
                break;
            }
            case 128111976: {
                if (string.equals(EVENT_TYPE_LONG_TASK)) {
                    n = 4;
                }
                break;
            }
            case 96784904: {
                if (string.equals(EVENT_TYPE_ERROR)) {
                    n = 5;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                Object object = ViewEvent.Companion.fromJson(jsonString);
                return object;
            }
            case 2: {
                Object object = ResourceEvent.Companion.fromJson(jsonString);
                return object;
            }
            case 3: {
                Object object = ActionEvent.Companion.fromJson(jsonString);
                return object;
            }
            case 5: {
                Object object = ErrorEvent.Companion.fromJson(jsonString);
                return object;
            }
            case 4: {
                Object object = LongTaskEvent.Companion.fromJson(jsonString);
                return object;
            }
            default: {
                throw new JsonParseException(Intrinsics.stringPlus((String)"We could not deserialize the event with type: ", (Object)eventType));
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/rum/internal/domain/event/RumEventDeserializer$Companion;", "", "()V", "DESERIALIZE_ERROR_MESSAGE_FORMAT", "", "EVENT_TYPE_ACTION", "EVENT_TYPE_ERROR", "EVENT_TYPE_KEY_NAME", "EVENT_TYPE_LONG_TASK", "EVENT_TYPE_RESOURCE", "EVENT_TYPE_VIEW", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

