/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.log.internal.user;

import com.datadog.android.core.internal.persistence.Deserializer;
import com.datadog.android.core.model.UserInfo;
import com.datadog.android.log.Logger;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/log/internal/user/UserInfoDeserializer;", "Lcom/datadog/android/core/internal/persistence/Deserializer;", "Lcom/datadog/android/core/model/UserInfo;", "internalLogger", "Lcom/datadog/android/log/Logger;", "(Lcom/datadog/android/log/Logger;)V", "deserialize", "model", "", "Companion", "dd-sdk-android_release"})
public final class UserInfoDeserializer
implements Deserializer<UserInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger internalLogger;
    @NotNull
    public static final String DESERIALIZE_ERROR_MESSAGE_FORMAT = "Error while trying to deserialize the serialized UserInfo: %s";

    public UserInfoDeserializer(@NotNull Logger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
    }

    @Override
    @Nullable
    public UserInfo deserialize(@NotNull String model) {
        UserInfo userInfo;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        try {
            userInfo = UserInfo.Companion.fromJson(model);
        }
        catch (JsonParseException e) {
            String string = DESERIALIZE_ERROR_MESSAGE_FORMAT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{model};
            boolean bl = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
            Logger.e$default(this.internalLogger, string2, e, null, 4, null);
            userInfo = null;
        }
        catch (IllegalStateException e) {
            String string = DESERIALIZE_ERROR_MESSAGE_FORMAT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{model};
            boolean bl = false;
            String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, this, *args)");
            Logger.e$default(this.internalLogger, string3, e, null, 4, null);
            userInfo = null;
        }
        return userInfo;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/log/internal/user/UserInfoDeserializer$Companion;", "", "()V", "DESERIALIZE_ERROR_MESSAGE_FORMAT", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

