/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.log.internal.logger;

import android.os.Build;
import android.util.Log;
import com.datadog.android.Datadog;
import com.datadog.android.log.Logger;
import com.datadog.android.log.internal.logger.CombinedLogHandler;
import com.datadog.android.log.internal.logger.ConditionalLogHandler;
import com.datadog.android.log.internal.logger.DatadogLogHandler;
import com.datadog.android.log.internal.logger.LogHandler;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b\u0012JU\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010\fH\u0002J\u0017\u0010$\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b%R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006'"}, d2={"Lcom/datadog/android/log/internal/logger/LogcatLogHandler;", "Lcom/datadog/android/log/internal/logger/LogHandler;", "serviceName", "", "useClassnameAsTag", "", "(Ljava/lang/String;Z)V", "getServiceName$dd_sdk_android_release", "()Ljava/lang/String;", "getUseClassnameAsTag$dd_sdk_android_release", "()Z", "findValidCallStackElement", "Ljava/lang/StackTraceElement;", "stackTrace", "", "findValidCallStackElement$dd_sdk_android_release", "([Ljava/lang/StackTraceElement;)Ljava/lang/StackTraceElement;", "getCallerStackElement", "getCallerStackElement$dd_sdk_android_release", "handleLog", "", "level", "", "message", "throwable", "", "attributes", "", "", "tags", "", "timestamp", "", "(ILjava/lang/String;Ljava/lang/Throwable;Ljava/util/Map;Ljava/util/Set;Ljava/lang/Long;)V", "resolveSuffix", "stackTraceElement", "resolveTag", "resolveTag$dd_sdk_android_release", "Companion", "dd-sdk-android_release"})
public final class LogcatLogHandler
implements LogHandler {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String serviceName;
    private final boolean useClassnameAsTag;
    private static final int MAX_TAG_LENGTH = 23;
    @NotNull
    private static final Regex ANONYMOUS_CLASS;
    @NotNull
    private static final String[] IGNORED_CLASS_NAMES;
    @NotNull
    private static final String[] IGNORED_PACKAGE_PREFIXES;

    public LogcatLogHandler(@NotNull String serviceName, boolean useClassnameAsTag) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        this.serviceName = serviceName;
        this.useClassnameAsTag = useClassnameAsTag;
    }

    @NotNull
    public final String getServiceName$dd_sdk_android_release() {
        return this.serviceName;
    }

    public final boolean getUseClassnameAsTag$dd_sdk_android_release() {
        return this.useClassnameAsTag;
    }

    @Override
    public void handleLog(int level, @NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes, @NotNull Set<String> tags2, @Nullable Long timestamp) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(tags2, (String)"tags");
        StackTraceElement stackElement = this.getCallerStackElement$dd_sdk_android_release();
        String tag = this.resolveTag$dd_sdk_android_release(stackElement);
        String suffix = this.resolveSuffix(stackElement);
        Log.println((int)level, (String)tag, (String)Intrinsics.stringPlus((String)message, (Object)suffix));
        if (throwable != null) {
            Log.println((int)level, (String)tag, (String)Log.getStackTraceString((Throwable)throwable));
        }
    }

    @NotNull
    public final String resolveTag$dd_sdk_android_release(@Nullable StackTraceElement stackTraceElement) {
        String string;
        String tag;
        boolean bl;
        CharSequence charSequence;
        String string2;
        if (stackTraceElement == null) {
            string2 = this.serviceName;
        } else {
            charSequence = stackTraceElement.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"stackTraceElement.className");
            charSequence = charSequence;
            Regex regex = ANONYMOUS_CLASS;
            String string3 = "";
            bl = false;
            string2 = tag = StringsKt.substringAfterLast$default((String)regex.replace(charSequence, string3), (char)'.', null, (int)2, null);
        }
        if (tag.length() >= 23 && Build.VERSION.SDK_INT < 24) {
            charSequence = tag;
            int n = 0;
            int n2 = 23;
            bl = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = ((String)charSequence2).substring(n, n2);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = tag;
        }
        return string;
    }

    private final String resolveSuffix(StackTraceElement stackTraceElement) {
        return stackTraceElement == null ? "" : "\t| at ." + stackTraceElement.getMethodName() + '(' + stackTraceElement.getFileName() + ':' + stackTraceElement.getLineNumber() + ')';
    }

    @Nullable
    public final StackTraceElement getCallerStackElement$dd_sdk_android_release() {
        if (Datadog.INSTANCE.isDebug$dd_sdk_android_release() && this.useClassnameAsTag) {
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTrace, (String)"stackTrace");
            return this.findValidCallStackElement$dd_sdk_android_release(stackTrace);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final StackTraceElement findValidCallStackElement$dd_sdk_android_release(@NotNull StackTraceElement[] stackTrace) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
            $this$firstOrNull$iv = stackTrace;
            $i$f$firstOrNull = false;
            var4_4 = $this$firstOrNull$iv;
            var5_5 = var4_4.length;
            for (var6_6 = 0; var6_6 < var5_5; ++var6_6) {
                block4: {
                    element = element$iv = var4_4[var6_6];
                    $i$a$-firstOrNull-LogcatLogHandler$findValidCallStackElement$1 = false;
                    if (ArraysKt.contains((Object[])LogcatLogHandler.IGNORED_CLASS_NAMES, (Object)element.getClassName())) ** GOTO lbl-1000
                    $this$none$iv = LogcatLogHandler.IGNORED_PACKAGE_PREFIXES;
                    $i$f$none = false;
                    var12_12 = $this$none$iv;
                    var13_13 = var12_12.length;
                    for (var14_14 = 0; var14_14 < var13_13; ++var14_14) {
                        it = element$iv = var12_12[var14_14];
                        $i$a$-none-LogcatLogHandler$findValidCallStackElement$1$1 = false;
                        var18_18 = element.getClassName();
                        Intrinsics.checkNotNullExpressionValue((Object)var18_18, (String)"element.className");
                        if (!StringsKt.startsWith$default((String)var18_18, (String)it, (boolean)false, (int)2, null)) continue;
                        v0 = false;
                        break block4;
                    }
                    v0 = true;
                }
                if (v0) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        return v2;
    }

    static {
        String string;
        Companion = new Companion(null);
        ANONYMOUS_CLASS = new Regex("(\\$\\d+)+$");
        String[] stringArray = new String[]{Logger.class.getCanonicalName(), LogHandler.class.getCanonicalName(), (string = LogHandler.class.getCanonicalName()) == null ? null : Intrinsics.stringPlus((String)string, (Object)"$DefaultImpls"), LogcatLogHandler.class.getCanonicalName(), ConditionalLogHandler.class.getCanonicalName(), CombinedLogHandler.class.getCanonicalName(), DatadogLogHandler.class.getCanonicalName()};
        IGNORED_CLASS_NAMES = stringArray;
        stringArray = new String[]{"com.datadog.android.timber", "timber.log"};
        IGNORED_PACKAGE_PREFIXES = stringArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/log/internal/logger/LogcatLogHandler$Companion;", "", "()V", "ANONYMOUS_CLASS", "Lkotlin/text/Regex;", "IGNORED_CLASS_NAMES", "", "", "getIGNORED_CLASS_NAMES$dd_sdk_android_release", "()[Ljava/lang/String;", "[Ljava/lang/String;", "IGNORED_PACKAGE_PREFIXES", "getIGNORED_PACKAGE_PREFIXES$dd_sdk_android_release", "MAX_TAG_LENGTH", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getIGNORED_CLASS_NAMES$dd_sdk_android_release() {
            return IGNORED_CLASS_NAMES;
        }

        @NotNull
        public final String[] getIGNORED_PACKAGE_PREFIXES$dd_sdk_android_release() {
            return IGNORED_PACKAGE_PREFIXES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

