/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.log;

import androidx.annotation.FloatRange;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.net.info.NetworkInfoProvider;
import com.datadog.android.core.internal.persistence.DataWriter;
import com.datadog.android.core.internal.sampling.RateBasedSampler;
import com.datadog.android.core.internal.utils.MapUtilsKt;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.internal.LogsFeature;
import com.datadog.android.log.internal.domain.LogGenerator;
import com.datadog.android.log.internal.logger.CombinedLogHandler;
import com.datadog.android.log.internal.logger.DatadogLogHandler;
import com.datadog.android.log.internal.logger.LogHandler;
import com.datadog.android.log.internal.logger.LogcatLogHandler;
import com.datadog.android.log.internal.logger.NoOpLogHandler;
import com.datadog.android.log.internal.user.NoOpUserInfoProvider;
import com.datadog.android.log.model.LogEvent;
import com.datadog.android.monitoring.internal.InternalLogsFeature;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\u0010$\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00015B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0011J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0012J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0013J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0014J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0015J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0016J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0017J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0007J\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J4\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00072\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001fH\u0007J4\u0010 \u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00072\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001fH\u0007J4\u0010!\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00072\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001fH\u0007JK\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001f2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0017H\u0000\u00a2\u0006\u0004\b&\u0010'J<\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00072\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001fH\u0007J\u000e\u0010*\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u000e\u0010+\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0007J\u0010\u0010,\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u000e\u0010-\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u001a\u0010.\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0002J\u001c\u0010/\u001a\u00020\r2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001301H\u0002J4\u00102\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00072\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001fH\u0007J4\u00103\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00072\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001fH\u0007J4\u00104\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00072\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001fH\u0007R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/datadog/android/log/Logger;", "", "handler", "Lcom/datadog/android/log/internal/logger/LogHandler;", "(Lcom/datadog/android/log/internal/logger/LogHandler;)V", "attributes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "getHandler$dd_sdk_android_release", "()Lcom/datadog/android/log/internal/logger/LogHandler;", "tags", "Ljava/util/concurrent/CopyOnWriteArraySet;", "addAttribute", "", "key", "value", "Lcom/google/gson/JsonArray;", "Lcom/google/gson/JsonObject;", "Ljava/util/Date;", "", "", "", "", "", "addTag", "tag", "addTagInternal", "d", "message", "throwable", "", "", "e", "i", "internalLog", "level", "localAttributes", "timestamp", "internalLog$dd_sdk_android_release", "(ILjava/lang/String;Ljava/lang/Throwable;Ljava/util/Map;Ljava/lang/Long;)V", "log", "priority", "removeAttribute", "removeTag", "removeTagInternal", "removeTagsWithKey", "safelyAddAttribute", "safelyRemoveTagsWithKey", "keyFilter", "Lkotlin/Function1;", "v", "w", "wtf", "Builder", "dd-sdk-android_release"})
public final class Logger {
    @NotNull
    private final LogHandler handler;
    @NotNull
    private final ConcurrentHashMap<String, Object> attributes;
    @NotNull
    private final CopyOnWriteArraySet<String> tags;

    public Logger(@NotNull LogHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
        this.attributes = new ConcurrentHashMap();
        this.tags = new CopyOnWriteArraySet();
    }

    @NotNull
    public final LogHandler getHandler$dd_sdk_android_release() {
        return this.handler;
    }

    @JvmOverloads
    public final void v(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_release$default(this, 2, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void v$default(Logger logger, String string, Throwable throwable, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        logger.v(string, throwable, map);
    }

    @JvmOverloads
    public final void d(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_release$default(this, 3, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void d$default(Logger logger, String string, Throwable throwable, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        logger.d(string, throwable, map);
    }

    @JvmOverloads
    public final void i(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_release$default(this, 4, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void i$default(Logger logger, String string, Throwable throwable, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        logger.i(string, throwable, map);
    }

    @JvmOverloads
    public final void w(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_release$default(this, 5, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void w$default(Logger logger, String string, Throwable throwable, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        logger.w(string, throwable, map);
    }

    @JvmOverloads
    public final void e(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_release$default(this, 6, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void e$default(Logger logger, String string, Throwable throwable, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        logger.e(string, throwable, map);
    }

    @JvmOverloads
    public final void wtf(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_release$default(this, 7, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void wtf$default(Logger logger, String string, Throwable throwable, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        logger.wtf(string, throwable, map);
    }

    @JvmOverloads
    public final void log(int priority, @NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_release$default(this, priority, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void log$default(Logger logger, int n, String string, Throwable throwable, Map map, int n2, Object object) {
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        if ((n2 & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        logger.log(n, string, throwable, map);
    }

    public final void addAttribute(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map map = this.attributes;
        Boolean bl = value;
        boolean bl2 = false;
        map.put(key, bl);
    }

    public final void addAttribute(@NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map map = this.attributes;
        Integer n = value;
        boolean bl = false;
        map.put(key, n);
    }

    public final void addAttribute(@NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map map = this.attributes;
        Long l = value;
        boolean bl = false;
        map.put(key, l);
    }

    public final void addAttribute(@NotNull String key, float value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map map = this.attributes;
        Float f = Float.valueOf(value);
        boolean bl = false;
        map.put(key, f);
    }

    public final void addAttribute(@NotNull String key, double value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map map = this.attributes;
        Double d = value;
        boolean bl = false;
        map.put(key, d);
    }

    public final void addAttribute(@NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.safelyAddAttribute(key, value);
    }

    public final void addAttribute(@NotNull String key, @Nullable Date value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.safelyAddAttribute(key, value);
    }

    public final void addAttribute(@NotNull String key, @Nullable JsonObject value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.safelyAddAttribute(key, value);
    }

    public final void addAttribute(@NotNull String key, @Nullable JsonArray value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.safelyAddAttribute(key, value);
    }

    public final void removeAttribute(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.attributes.remove(key);
    }

    public final void addTag(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.addTagInternal(key + ':' + value);
    }

    public final void addTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.addTagInternal(tag);
    }

    public final void removeTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.removeTagInternal(tag);
    }

    public final void removeTagsWithKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String prefix = Intrinsics.stringPlus((String)key, (Object)":");
        this.safelyRemoveTagsWithKey((Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
                super(1);
            }

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.startsWith$default((String)it, (String)this.$prefix, (boolean)false, (int)2, null);
            }
        }));
    }

    public final void internalLog$dd_sdk_android_release(int level, @NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> localAttributes, @Nullable Long timestamp) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(localAttributes, (String)"localAttributes");
        boolean bl = false;
        Map combinedAttributes = new LinkedHashMap();
        combinedAttributes.putAll((Map)this.attributes);
        combinedAttributes.putAll(localAttributes);
        this.handler.handleLog(level, message, throwable, combinedAttributes, (Set<String>)this.tags, timestamp);
    }

    public static /* synthetic */ void internalLog$dd_sdk_android_release$default(Logger logger, int n, String string, Throwable throwable, Map map, Long l, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            l = null;
        }
        logger.internalLog$dd_sdk_android_release(n, string, throwable, map, l);
    }

    private final void addTagInternal(String tag) {
        this.tags.add(tag);
    }

    private final void removeTagInternal(String tag) {
        this.tags.remove(tag);
    }

    private final void safelyAddAttribute(String key, Object value) {
        Object object = value;
        Object attributeValue = object == null ? MapUtilsKt.getNULL_MAP_VALUE() : object;
        object = this.attributes;
        boolean bl = false;
        object.put(key, attributeValue);
    }

    /*
     * WARNING - void declaration
     */
    private final void safelyRemoveTagsWithKey(Function1<? super String, Boolean> keyFilter) {
        void $this$filterTo$iv$iv;
        String[] $this$toTypedArray$iv = (String[])this.tags;
        boolean $i$f$toTypedArray = false;
        String[] thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] $this$filter$iv = stringArray;
        boolean $i$f$filter = false;
        thisCollection$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)keyFilter.invoke((Object)element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toRemove = (List)destination$iv$iv;
        this.tags.removeAll(toRemove);
    }

    @JvmOverloads
    public final void v(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.v$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void v(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.v$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void d(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.d$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void d(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.d$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void i(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.i$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void i(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.i$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void w(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.w$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void w(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.w$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void e(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.e$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void e(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.e$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void wtf(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.wtf$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void wtf(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.wtf$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void log(int priority, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.log$default(this, priority, message, throwable, null, 8, null);
    }

    @JvmOverloads
    public final void log(int priority, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.log$default(this, priority, message, null, null, 12, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u0012H\u0002J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0004J\u0015\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b!J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\nJ\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0004J\u0010\u0010&\u001a\u00020\u00002\b\b\u0001\u0010'\u001a\u00020\rJ\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/datadog/android/log/Logger$Builder;", "", "()V", "bundleWithRumEnabled", "", "bundleWithTraceEnabled", "datadogLogsEnabled", "isInternalLogger", "logcatLogsEnabled", "loggerName", "", "networkInfoEnabled", "sampleRate", "", "serviceName", "build", "Lcom/datadog/android/log/Logger;", "buildDatadogHandler", "Lcom/datadog/android/log/internal/logger/LogHandler;", "buildInternalLogGenerator", "Lcom/datadog/android/log/internal/domain/LogGenerator;", "buildInternalLogWriter", "Lcom/datadog/android/core/internal/persistence/DataWriter;", "Lcom/datadog/android/log/model/LogEvent;", "buildLogGenerator", "buildLogWriter", "buildLogcatHandler", "setBundleWithRumEnabled", "enabled", "setBundleWithTraceEnabled", "setDatadogLogsEnabled", "setInternal", "isInternal", "setInternal$dd_sdk_android_release", "setLogcatLogsEnabled", "setLoggerName", "name", "setNetworkInfoEnabled", "setSampleRate", "rate", "setServiceName", "dd-sdk-android_release"})
    public static final class Builder {
        @NotNull
        private String serviceName = CoreFeature.INSTANCE.getServiceName$dd_sdk_android_release();
        private boolean datadogLogsEnabled = true;
        private boolean logcatLogsEnabled;
        private boolean networkInfoEnabled;
        private boolean bundleWithTraceEnabled = true;
        private boolean bundleWithRumEnabled = true;
        @NotNull
        private String loggerName = CoreFeature.INSTANCE.getPackageName$dd_sdk_android_release();
        private float sampleRate = 1.0f;
        private boolean isInternalLogger;

        @NotNull
        public final Logger build() {
            LogHandler logHandler;
            if (this.datadogLogsEnabled && this.logcatLogsEnabled) {
                LogHandler[] logHandlerArray = new LogHandler[]{this.buildDatadogHandler(), this.buildLogcatHandler()};
                logHandler = new CombinedLogHandler(logHandlerArray);
            } else {
                logHandler = this.datadogLogsEnabled ? this.buildDatadogHandler() : (this.logcatLogsEnabled ? this.buildLogcatHandler() : (LogHandler)new NoOpLogHandler());
            }
            LogHandler handler = logHandler;
            return new Logger(handler);
        }

        @NotNull
        public final Builder setServiceName(@NotNull String serviceName) {
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            this.serviceName = serviceName;
            return this;
        }

        @NotNull
        public final Builder setDatadogLogsEnabled(boolean enabled) {
            this.datadogLogsEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setLogcatLogsEnabled(boolean enabled) {
            this.logcatLogsEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setNetworkInfoEnabled(boolean enabled) {
            this.networkInfoEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setLoggerName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.loggerName = name;
            return this;
        }

        @NotNull
        public final Builder setBundleWithTraceEnabled(boolean enabled) {
            this.bundleWithTraceEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setBundleWithRumEnabled(boolean enabled) {
            this.bundleWithRumEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setSampleRate(@FloatRange(from=0.0, to=1.0) float rate) {
            this.sampleRate = rate;
            return this;
        }

        @NotNull
        public final Builder setInternal$dd_sdk_android_release(boolean isInternal) {
            this.isInternalLogger = isInternal;
            return this;
        }

        private final LogHandler buildLogcatHandler() {
            return new LogcatLogHandler(this.serviceName, true);
        }

        private final LogHandler buildDatadogHandler() {
            DataWriter<LogEvent> dataWriter;
            DataWriter<LogEvent> dataWriter2 = dataWriter = this.isInternalLogger ? this.buildInternalLogWriter() : this.buildLogWriter();
            if (dataWriter == null) {
                return new NoOpLogHandler();
            }
            DataWriter<LogEvent> writer = dataWriter;
            LogGenerator logGenerator = this.isInternalLogger ? this.buildInternalLogGenerator() : this.buildLogGenerator();
            return new DatadogLogHandler(logGenerator, writer, this.bundleWithTraceEnabled, this.bundleWithRumEnabled, new RateBasedSampler(this.sampleRate));
        }

        private final DataWriter<LogEvent> buildInternalLogWriter() {
            return InternalLogsFeature.INSTANCE.isInitialized() ? InternalLogsFeature.INSTANCE.getPersistenceStrategy$dd_sdk_android_release().getWriter() : (DataWriter<LogEvent>)null;
        }

        private final DataWriter<LogEvent> buildLogWriter() {
            DataWriter dataWriter;
            if (LogsFeature.INSTANCE.isInitialized()) {
                dataWriter = LogsFeature.INSTANCE.getPersistenceStrategy$dd_sdk_android_release().getWriter();
            } else {
                Logger.e$default(RuntimeUtilsKt.getDevLogger(), "Datadog has not been initialized.\nPlease add the following code in your application's onCreate() method:\nval credentials = Credentials(\"<CLIENT_TOKEN>\", \"<ENVIRONMENT>\", \"<VARIANT>\", \"<APPLICATION_ID>\")\nDatadog.initialize(context, credentials, configuration, trackingConsent);", null, null, 6, null);
                dataWriter = null;
            }
            return dataWriter;
        }

        private final LogGenerator buildLogGenerator() {
            NetworkInfoProvider netInfoProvider = this.networkInfoEnabled ? CoreFeature.INSTANCE.getNetworkInfoProvider$dd_sdk_android_release() : (NetworkInfoProvider)null;
            return new LogGenerator(this.serviceName, this.loggerName, netInfoProvider, CoreFeature.INSTANCE.getUserInfoProvider$dd_sdk_android_release(), CoreFeature.INSTANCE.getTimeProvider$dd_sdk_android_release(), CoreFeature.INSTANCE.getSdkVersion$dd_sdk_android_release(), CoreFeature.INSTANCE.getEnvName$dd_sdk_android_release(), CoreFeature.INSTANCE.getPackageVersion$dd_sdk_android_release());
        }

        private final LogGenerator buildInternalLogGenerator() {
            NetworkInfoProvider netInfoProvider = this.networkInfoEnabled ? CoreFeature.INSTANCE.getNetworkInfoProvider$dd_sdk_android_release() : (NetworkInfoProvider)null;
            return new LogGenerator("dd-sdk-android", this.loggerName, netInfoProvider, new NoOpUserInfoProvider(), CoreFeature.INSTANCE.getTimeProvider$dd_sdk_android_release(), CoreFeature.INSTANCE.getSdkVersion$dd_sdk_android_release(), "prod", CoreFeature.INSTANCE.getPackageVersion$dd_sdk_android_release());
        }
    }
}

