/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.error.internal;

import android.content.Context;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.persistence.DataWriter;
import com.datadog.android.core.internal.thread.ThreadPoolExecutorExtKt;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.internal.utils.WorkManagerUtilsKt;
import com.datadog.android.log.Logger;
import com.datadog.android.log.internal.domain.LogGenerator;
import com.datadog.android.log.model.LogEvent;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import java.lang.ref.WeakReference;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0010H\u0016R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/datadog/android/error/internal/DatadogExceptionHandler;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "logGenerator", "Lcom/datadog/android/log/internal/domain/LogGenerator;", "writer", "Lcom/datadog/android/core/internal/persistence/DataWriter;", "Lcom/datadog/android/log/model/LogEvent;", "appContext", "Landroid/content/Context;", "(Lcom/datadog/android/log/internal/domain/LogGenerator;Lcom/datadog/android/core/internal/persistence/DataWriter;Landroid/content/Context;)V", "contextRef", "Ljava/lang/ref/WeakReference;", "previousHandler", "createCrashMessage", "", "throwable", "", "createLog", "thread", "Ljava/lang/Thread;", "register", "", "uncaughtException", "t", "e", "Companion", "dd-sdk-android_release"})
public final class DatadogExceptionHandler
implements Thread.UncaughtExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LogGenerator logGenerator;
    @NotNull
    private final DataWriter<LogEvent> writer;
    @NotNull
    private final WeakReference<Context> contextRef;
    @Nullable
    private Thread.UncaughtExceptionHandler previousHandler;
    @NotNull
    public static final String LOGGER_NAME = "crash";
    @NotNull
    public static final String MESSAGE = "Application crash detected";
    public static final long MAX_WAIT_FOR_IDLE_TIME_IN_MS = 100L;
    @NotNull
    public static final String EXECUTOR_NOT_IDLED_WARNING_MESSAGE = "Datadog SDK is in an unexpected state due to an ongoing crash. Some events could be lost";

    public DatadogExceptionHandler(@NotNull LogGenerator logGenerator, @NotNull DataWriter<LogEvent> writer, @Nullable Context appContext) {
        Intrinsics.checkNotNullParameter((Object)logGenerator, (String)"logGenerator");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        this.logGenerator = logGenerator;
        this.writer = writer;
        this.contextRef = new WeakReference<Context>(appContext);
    }

    @Override
    public void uncaughtException(@NotNull Thread t, @NotNull Throwable e) {
        boolean bl;
        boolean idled;
        AdvancedRumMonitor advancedRumMonitor;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.writer.write(this.createLog(t, e));
        Object object = GlobalRum.get();
        AdvancedRumMonitor advancedRumMonitor2 = advancedRumMonitor = object instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)object : null;
        if (advancedRumMonitor != null) {
            advancedRumMonitor.addCrash(this.createCrashMessage(e), RumErrorSource.SOURCE, e);
        }
        Object object2 = CoreFeature.INSTANCE.getPersistenceExecutorService$dd_sdk_android_release();
        object = object2 instanceof ThreadPoolExecutor ? (ThreadPoolExecutor)object2 : null;
        boolean bl2 = idled = object == null ? true : (bl = ThreadPoolExecutorExtKt.waitToIdle((ThreadPoolExecutor)object, 100L));
        if (!idled) {
            Logger.w$default(RuntimeUtilsKt.getDevLogger(), EXECUTOR_NOT_IDLED_WARNING_MESSAGE, null, null, 6, null);
        }
        if ((object = (Context)this.contextRef.get()) != null) {
            object2 = object;
            boolean bl3 = false;
            boolean bl4 = false;
            Object it = object2;
            boolean bl5 = false;
            WorkManagerUtilsKt.triggerUploadWorker((Context)it);
        }
        object = this.previousHandler;
        if (object != null) {
            object.uncaughtException(t, e);
        }
    }

    public final void register() {
        this.previousHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    private final LogEvent createLog(Thread thread, Throwable throwable) {
        return LogGenerator.generateLog$default(this.logGenerator, 9, this.createCrashMessage(throwable), throwable, MapsKt.emptyMap(), SetsKt.emptySet(), System.currentTimeMillis(), thread.getName(), false, false, null, null, 1920, null);
    }

    private final String createCrashMessage(Throwable throwable) {
        String string;
        String rawMessage = throwable.getMessage();
        CharSequence charSequence = rawMessage;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            String string2 = throwable.getClass().getCanonicalName();
            String className = string2 == null ? throwable.getClass().getSimpleName() : string2;
            string = Intrinsics.stringPlus((String)"Application crash detected: ", (Object)className);
        } else {
            string = rawMessage;
        }
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/datadog/android/error/internal/DatadogExceptionHandler$Companion;", "", "()V", "EXECUTOR_NOT_IDLED_WARNING_MESSAGE", "", "LOGGER_NAME", "MAX_WAIT_FOR_IDLE_TIME_IN_MS", "", "MESSAGE", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

