/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.error.internal;

import android.content.Context;
import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.SdkFeature;
import com.datadog.android.core.internal.net.DataUploader;
import com.datadog.android.core.internal.persistence.PersistenceStrategy;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.error.internal.CrashReportFilePersistenceStrategy;
import com.datadog.android.error.internal.DatadogExceptionHandler;
import com.datadog.android.log.internal.domain.LogGenerator;
import com.datadog.android.log.internal.net.LogsOkHttpUploaderV2;
import com.datadog.android.log.model.LogEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000bH\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/datadog/android/error/internal/CrashReportsFeature;", "Lcom/datadog/android/core/internal/SdkFeature;", "Lcom/datadog/android/log/model/LogEvent;", "Lcom/datadog/android/core/configuration/Configuration$Feature$CrashReport;", "()V", "originalUncaughtExceptionHandler", "Ljava/lang/Thread$UncaughtExceptionHandler;", "kotlin.jvm.PlatformType", "createPersistenceStrategy", "Lcom/datadog/android/core/internal/persistence/PersistenceStrategy;", "context", "Landroid/content/Context;", "configuration", "createUploader", "Lcom/datadog/android/core/internal/net/DataUploader;", "onInitialize", "", "onStop", "resetOriginalExceptionHandler", "setupExceptionHandler", "appContext", "dd-sdk-android_release"})
public final class CrashReportsFeature
extends SdkFeature<LogEvent, Configuration.Feature.CrashReport> {
    @NotNull
    public static final CrashReportsFeature INSTANCE = new CrashReportsFeature();
    private static Thread.UncaughtExceptionHandler originalUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();

    private CrashReportsFeature() {
    }

    @Override
    public void onInitialize(@NotNull Context context, @NotNull Configuration.Feature.CrashReport configuration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.setupExceptionHandler(context);
    }

    @Override
    public void onStop() {
        this.resetOriginalExceptionHandler();
    }

    @Override
    @NotNull
    public PersistenceStrategy<LogEvent> createPersistenceStrategy(@NotNull Context context, @NotNull Configuration.Feature.CrashReport configuration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return new CrashReportFilePersistenceStrategy(CoreFeature.INSTANCE.getTrackingConsentProvider$dd_sdk_android_release(), context, CoreFeature.INSTANCE.getPersistenceExecutorService$dd_sdk_android_release(), RuntimeUtilsKt.getSdkLogger());
    }

    @Override
    @NotNull
    public DataUploader createUploader(@NotNull Configuration.Feature.CrashReport configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return new LogsOkHttpUploaderV2(configuration.getEndpointUrl(), CoreFeature.INSTANCE.getClientToken$dd_sdk_android_release(), CoreFeature.INSTANCE.getSourceName$dd_sdk_android_release(), CoreFeature.INSTANCE.getSdkVersion$dd_sdk_android_release(), (Call.Factory)CoreFeature.INSTANCE.getOkHttpClient$dd_sdk_android_release(), RuntimeUtilsKt.getSdkLogger());
    }

    private final void setupExceptionHandler(Context appContext) {
        originalUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        new DatadogExceptionHandler(new LogGenerator(CoreFeature.INSTANCE.getServiceName$dd_sdk_android_release(), "crash", CoreFeature.INSTANCE.getNetworkInfoProvider$dd_sdk_android_release(), CoreFeature.INSTANCE.getUserInfoProvider$dd_sdk_android_release(), CoreFeature.INSTANCE.getTimeProvider$dd_sdk_android_release(), CoreFeature.INSTANCE.getSdkVersion$dd_sdk_android_release(), CoreFeature.INSTANCE.getEnvName$dd_sdk_android_release(), CoreFeature.INSTANCE.getPackageVersion$dd_sdk_android_release()), this.getPersistenceStrategy$dd_sdk_android_release().getWriter(), appContext).register();
    }

    private final void resetOriginalExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(originalUncaughtExceptionHandler);
    }
}

