/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.batch;

import com.datadog.android.core.internal.persistence.Batch;
import com.datadog.android.core.internal.persistence.DataReader;
import com.datadog.android.core.internal.persistence.PayloadDecoration;
import com.datadog.android.core.internal.persistence.file.FileHandler;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.log.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0015H\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\"H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileDataReader;", "Lcom/datadog/android/core/internal/persistence/DataReader;", "fileOrchestrator", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "decoration", "Lcom/datadog/android/core/internal/persistence/PayloadDecoration;", "handler", "Lcom/datadog/android/core/internal/persistence/file/FileHandler;", "internalLogger", "Lcom/datadog/android/log/Logger;", "(Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;Lcom/datadog/android/core/internal/persistence/PayloadDecoration;Lcom/datadog/android/core/internal/persistence/file/FileHandler;Lcom/datadog/android/log/Logger;)V", "getDecoration$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/PayloadDecoration;", "getFileOrchestrator$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "getHandler$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/FileHandler;", "getInternalLogger$dd_sdk_android_release", "()Lcom/datadog/android/log/Logger;", "lockedFiles", "", "Ljava/io/File;", "deleteFile", "", "file", "drop", "data", "Lcom/datadog/android/core/internal/persistence/Batch;", "dropAll", "getAndLockReadableFile", "lockAndReadNext", "release", "releaseFile", "delete", "", "fileName", "", "Companion", "dd-sdk-android_release"})
public final class BatchFileDataReader
implements DataReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileOrchestrator fileOrchestrator;
    @NotNull
    private final PayloadDecoration decoration;
    @NotNull
    private final FileHandler handler;
    @NotNull
    private final Logger internalLogger;
    @NotNull
    private final List<File> lockedFiles;
    @NotNull
    public static final String WARNING_UNKNOWN_BATCH_ID = "Attempting to unlock or delete an unknown file: %s";
    @NotNull
    public static final String WARNING_DELETE_FAILED = "Unable to delete file: %s";

    public BatchFileDataReader(@NotNull FileOrchestrator fileOrchestrator, @NotNull PayloadDecoration decoration, @NotNull FileHandler handler, @NotNull Logger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)fileOrchestrator, (String)"fileOrchestrator");
        Intrinsics.checkNotNullParameter((Object)decoration, (String)"decoration");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.fileOrchestrator = fileOrchestrator;
        this.decoration = decoration;
        this.handler = handler;
        this.internalLogger = internalLogger;
        boolean bl = false;
        this.lockedFiles = new ArrayList();
    }

    @NotNull
    public final FileOrchestrator getFileOrchestrator$dd_sdk_android_release() {
        return this.fileOrchestrator;
    }

    @NotNull
    public final PayloadDecoration getDecoration$dd_sdk_android_release() {
        return this.decoration;
    }

    @NotNull
    public final FileHandler getHandler$dd_sdk_android_release() {
        return this.handler;
    }

    @NotNull
    public final Logger getInternalLogger$dd_sdk_android_release() {
        return this.internalLogger;
    }

    @Override
    @Nullable
    public Batch lockAndReadNext() {
        File file = this.getAndLockReadableFile();
        if (file == null) {
            return null;
        }
        File file2 = file;
        byte[] data = this.handler.readData(file2, this.decoration.getPrefixBytes(), this.decoration.getSuffixBytes());
        String string = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        return new Batch(string, data);
    }

    @Override
    public void release(@NotNull Batch data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.releaseFile(data.getId(), false);
    }

    @Override
    public void drop(@NotNull Batch data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.releaseFile(data.getId(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void dropAll() {
        List<File> list = this.lockedFiles;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            void $this$forEach$iv;
            boolean bl3 = false;
            File[] $this$toTypedArray$iv = (File[])this.lockedFiles;
            boolean $i$f$toTypedArray = false;
            File[] thisCollection$iv = $this$toTypedArray$iv;
            File[] fileArray = thisCollection$iv.toArray(new File[0]);
            if (fileArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            $this$toTypedArray$iv = fileArray;
            boolean $i$f$forEach = false;
            for (void element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl4 = false;
                this.releaseFile(it, true);
            }
            Unit unit = Unit.INSTANCE;
        }
        Iterable $this$forEach$iv = this.fileOrchestrator.getAllFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl5 = false;
            this.deleteFile(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File getAndLockReadableFile() {
        List<File> list = this.lockedFiles;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            File readableFile = this.getFileOrchestrator$dd_sdk_android_release().getReadableFile(CollectionsKt.toSet((Iterable)this.lockedFiles));
            if (readableFile != null) {
                this.lockedFiles.add(readableFile);
            }
            File file = readableFile;
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void releaseFile(String fileName, boolean delete) {
        Object[] objectArray;
        Object object = this.lockedFiles;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Object v0;
            block6: {
                boolean bl3 = false;
                Iterable $this$firstOrNull$iv = this.lockedFiles;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    File it = (File)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            objectArray = v0;
        }
        Object[] file = objectArray;
        if (file != null) {
            this.releaseFile((File)file, delete);
        } else {
            object = WARNING_UNKNOWN_BATCH_ID;
            Locale locale = Locale.US;
            objectArray = new Object[]{fileName};
            boolean bl5 = false;
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(locale, this, *args)");
            Logger.w$default(this.internalLogger, string, null, null, 6, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void releaseFile(File file, boolean delete) {
        if (delete) {
            this.deleteFile(file);
        }
        List<File> list = this.lockedFiles;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            bl2 = this.lockedFiles.remove(file);
        }
    }

    private final void deleteFile(File file) {
        if (!this.handler.delete(file)) {
            String string = WARNING_DELETE_FAILED;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{file.getPath()};
            boolean bl = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
            Logger.w$default(this.internalLogger, string2, null, null, 6, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileDataReader$Companion;", "", "()V", "WARNING_DELETE_FAILED", "", "WARNING_UNKNOWN_BATCH_ID", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

