/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.advanced;

import com.datadog.android.core.internal.persistence.file.FileHandler;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.core.internal.persistence.file.advanced.DataMigrationOperation;
import com.datadog.android.core.internal.persistence.file.advanced.DataMigrator;
import com.datadog.android.core.internal.persistence.file.advanced.MoveDataMigrationOperation;
import com.datadog.android.core.internal.persistence.file.advanced.NoOpDataMigrationOperation;
import com.datadog.android.core.internal.persistence.file.advanced.WipeDataMigrationOperation;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.Logger;
import com.datadog.android.privacy.TrackingConsent;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/datadog/android/core/internal/persistence/file/advanced/ConsentAwareFileMigrator;", "Lcom/datadog/android/core/internal/persistence/file/advanced/DataMigrator;", "fileHandler", "Lcom/datadog/android/core/internal/persistence/file/FileHandler;", "executorService", "Ljava/util/concurrent/ExecutorService;", "internalLogger", "Lcom/datadog/android/log/Logger;", "(Lcom/datadog/android/core/internal/persistence/file/FileHandler;Ljava/util/concurrent/ExecutorService;Lcom/datadog/android/log/Logger;)V", "migrateData", "", "previousConsent", "Lcom/datadog/android/privacy/TrackingConsent;", "previousFileOrchestrator", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "newConsent", "newFileOrchestrator", "Companion", "dd-sdk-android_release"})
public final class ConsentAwareFileMigrator
implements DataMigrator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileHandler fileHandler;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final Logger internalLogger;
    @NotNull
    public static final String ERROR_REJECTED = "Unable to schedule migration on the executor";

    public ConsentAwareFileMigrator(@NotNull FileHandler fileHandler, @NotNull ExecutorService executorService, @NotNull Logger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)fileHandler, (String)"fileHandler");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.fileHandler = fileHandler;
        this.executorService = executorService;
        this.internalLogger = internalLogger;
    }

    @Override
    public void migrateData(@Nullable TrackingConsent previousConsent, @NotNull FileOrchestrator previousFileOrchestrator, @NotNull TrackingConsent newConsent, @NotNull FileOrchestrator newFileOrchestrator) {
        DataMigrationOperation dataMigrationOperation;
        Intrinsics.checkNotNullParameter((Object)previousFileOrchestrator, (String)"previousFileOrchestrator");
        Intrinsics.checkNotNullParameter((Object)((Object)newConsent), (String)"newConsent");
        Intrinsics.checkNotNullParameter((Object)newFileOrchestrator, (String)"newFileOrchestrator");
        Pair pair = TuplesKt.to((Object)((Object)previousConsent), (Object)((Object)newConsent));
        if (((Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to(null, (Object)((Object)TrackingConsent.PENDING))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to(null, (Object)((Object)TrackingConsent.GRANTED)))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to(null, (Object)((Object)TrackingConsent.NOT_GRANTED)))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.PENDING), (Object)((Object)TrackingConsent.NOT_GRANTED)))) {
            dataMigrationOperation = new WipeDataMigrationOperation(previousFileOrchestrator.getRootDir(), this.fileHandler, this.internalLogger);
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.GRANTED), (Object)((Object)TrackingConsent.PENDING))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.NOT_GRANTED), (Object)((Object)TrackingConsent.PENDING)))) {
            dataMigrationOperation = new WipeDataMigrationOperation(newFileOrchestrator.getRootDir(), this.fileHandler, this.internalLogger);
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.PENDING), (Object)((Object)TrackingConsent.GRANTED)))) {
            dataMigrationOperation = new MoveDataMigrationOperation(previousFileOrchestrator.getRootDir(), newFileOrchestrator.getRootDir(), this.fileHandler, this.internalLogger);
        } else if ((((Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.PENDING), (Object)((Object)TrackingConsent.PENDING))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.GRANTED), (Object)((Object)TrackingConsent.GRANTED)))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.GRANTED), (Object)((Object)TrackingConsent.NOT_GRANTED)))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.NOT_GRANTED), (Object)((Object)TrackingConsent.NOT_GRANTED)))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.NOT_GRANTED), (Object)((Object)TrackingConsent.GRANTED)))) {
            dataMigrationOperation = new NoOpDataMigrationOperation();
        } else {
            Logger.w$default(RuntimeUtilsKt.getSdkLogger(), "Unexpected consent migration from " + (Object)((Object)previousConsent) + " to " + (Object)((Object)newConsent), null, null, 6, null);
            dataMigrationOperation = new NoOpDataMigrationOperation();
        }
        DataMigrationOperation operation = dataMigrationOperation;
        try {
            this.executorService.submit(operation);
        }
        catch (RejectedExecutionException e) {
            Logger.e$default(this.internalLogger, ERROR_REJECTED, e, null, 4, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/persistence/file/advanced/ConsentAwareFileMigrator$Companion;", "", "()V", "ERROR_REJECTED", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

