/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file;

import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.log.Logger;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0002H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\t\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\u0002H\u0000\u001a\u0019\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000e*\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\u000f\u001a!\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000e*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\u0010\u0012\u001a!\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000e*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\u0010\u0014\u001a\u0019\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u000e*\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\u0017\u001a!\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u000e*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\u0010\u0018\u001a\f\u0010\u0019\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u001a\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\u001b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002H\u0000\u001a8\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e*\u00020\u00022\u0006\u0010\u001f\u001a\u0002H\u001e2\u0017\u0010 \u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u001e0!\u00a2\u0006\u0002\b\"H\u0002\u00a2\u0006\u0002\u0010#\u00a8\u0006$"}, d2={"canReadSafe", "", "Ljava/io/File;", "canWriteSafe", "createNewFileSafe", "deleteOnExitSafe", "", "deleteSafe", "existsSafe", "isDirectorySafe", "isFileSafe", "lengthSafe", "", "listFilesSafe", "", "(Ljava/io/File;)[Ljava/io/File;", "filter", "Ljava/io/FileFilter;", "(Ljava/io/File;Ljava/io/FileFilter;)[Ljava/io/File;", "Ljava/io/FilenameFilter;", "(Ljava/io/File;Ljava/io/FilenameFilter;)[Ljava/io/File;", "listSafe", "", "(Ljava/io/File;)[Ljava/lang/String;", "(Ljava/io/File;Ljava/io/FilenameFilter;)[Ljava/lang/String;", "mkdirSafe", "mkdirsSafe", "renameToSafe", "dest", "safeCall", "T", "default", "lambda", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljava/io/File;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "dd-sdk-android_release"})
public final class FileExtKt {
    private static final <T> T safeCall(File $this$safeCall, T t, Function1<? super File, ? extends T> lambda) {
        Object object;
        try {
            object = lambda.invoke((Object)$this$safeCall);
        }
        catch (SecurityException e) {
            Logger.e$default(RuntimeUtilsKt.getSdkLogger(), Intrinsics.stringPlus((String)"Security exception was thrown for file ", (Object)$this$safeCall.getPath()), e, null, 4, null);
            object = t;
        }
        return (T)object;
    }

    public static final boolean canWriteSafe(@NotNull File $this$canWriteSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$canWriteSafe, (String)"<this>");
        return FileExtKt.safeCall($this$canWriteSafe, false, canWriteSafe.1.INSTANCE);
    }

    public static final boolean canReadSafe(@NotNull File $this$canReadSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$canReadSafe, (String)"<this>");
        return FileExtKt.safeCall($this$canReadSafe, false, canReadSafe.1.INSTANCE);
    }

    public static final boolean createNewFileSafe(@NotNull File $this$createNewFileSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$createNewFileSafe, (String)"<this>");
        return FileExtKt.safeCall($this$createNewFileSafe, false, createNewFileSafe.1.INSTANCE);
    }

    public static final boolean deleteSafe(@NotNull File $this$deleteSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteSafe, (String)"<this>");
        return FileExtKt.safeCall($this$deleteSafe, false, deleteSafe.1.INSTANCE);
    }

    public static final void deleteOnExitSafe(@NotNull File $this$deleteOnExitSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteOnExitSafe, (String)"<this>");
        FileExtKt.safeCall($this$deleteOnExitSafe, Unit.INSTANCE, deleteOnExitSafe.1.INSTANCE);
    }

    public static final boolean existsSafe(@NotNull File $this$existsSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$existsSafe, (String)"<this>");
        return FileExtKt.safeCall($this$existsSafe, false, existsSafe.1.INSTANCE);
    }

    public static final boolean isFileSafe(@NotNull File $this$isFileSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$isFileSafe, (String)"<this>");
        return FileExtKt.safeCall($this$isFileSafe, false, isFileSafe.1.INSTANCE);
    }

    public static final boolean isDirectorySafe(@NotNull File $this$isDirectorySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectorySafe, (String)"<this>");
        return FileExtKt.safeCall($this$isDirectorySafe, false, isDirectorySafe.1.INSTANCE);
    }

    @Nullable
    public static final String[] listSafe(@NotNull File $this$listSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$listSafe, (String)"<this>");
        return FileExtKt.safeCall($this$listSafe, null, listSafe.1.INSTANCE);
    }

    @Nullable
    public static final String[] listSafe(@NotNull File $this$listSafe, @NotNull FilenameFilter filter) {
        Intrinsics.checkNotNullParameter((Object)$this$listSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        return FileExtKt.safeCall($this$listSafe, null, (Function1)new Function1<File, String[]>(filter){
            final /* synthetic */ FilenameFilter $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            @Nullable
            public final String[] invoke(@NotNull File $this$safeCall) {
                Intrinsics.checkNotNullParameter((Object)$this$safeCall, (String)"$this$safeCall");
                return $this$safeCall.list(this.$filter);
            }
        });
    }

    @Nullable
    public static final File[] listFilesSafe(@NotNull File $this$listFilesSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$listFilesSafe, (String)"<this>");
        return FileExtKt.safeCall($this$listFilesSafe, null, listFilesSafe.1.INSTANCE);
    }

    @Nullable
    public static final File[] listFilesSafe(@NotNull File $this$listFilesSafe, @NotNull FilenameFilter filter) {
        Intrinsics.checkNotNullParameter((Object)$this$listFilesSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        return FileExtKt.safeCall($this$listFilesSafe, null, (Function1)new Function1<File, File[]>(filter){
            final /* synthetic */ FilenameFilter $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            @Nullable
            public final File[] invoke(@NotNull File $this$safeCall) {
                Intrinsics.checkNotNullParameter((Object)$this$safeCall, (String)"$this$safeCall");
                return $this$safeCall.listFiles(this.$filter);
            }
        });
    }

    @Nullable
    public static final File[] listFilesSafe(@NotNull File $this$listFilesSafe, @NotNull FileFilter filter) {
        Intrinsics.checkNotNullParameter((Object)$this$listFilesSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        return FileExtKt.safeCall($this$listFilesSafe, null, (Function1)new Function1<File, File[]>(filter){
            final /* synthetic */ FileFilter $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            @Nullable
            public final File[] invoke(@NotNull File $this$safeCall) {
                Intrinsics.checkNotNullParameter((Object)$this$safeCall, (String)"$this$safeCall");
                return $this$safeCall.listFiles(this.$filter);
            }
        });
    }

    public static final long lengthSafe(@NotNull File $this$lengthSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$lengthSafe, (String)"<this>");
        return ((Number)FileExtKt.safeCall($this$lengthSafe, 0L, lengthSafe.1.INSTANCE)).longValue();
    }

    public static final boolean mkdirSafe(@NotNull File $this$mkdirSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$mkdirSafe, (String)"<this>");
        return FileExtKt.safeCall($this$mkdirSafe, false, mkdirSafe.1.INSTANCE);
    }

    public static final boolean mkdirsSafe(@NotNull File $this$mkdirsSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$mkdirsSafe, (String)"<this>");
        return FileExtKt.safeCall($this$mkdirsSafe, false, mkdirsSafe.1.INSTANCE);
    }

    public static final boolean renameToSafe(@NotNull File $this$renameToSafe, @NotNull File dest) {
        Intrinsics.checkNotNullParameter((Object)$this$renameToSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        return FileExtKt.safeCall($this$renameToSafe, false, (Function1)new Function1<File, Boolean>(dest){
            final /* synthetic */ File $dest;
            {
                this.$dest = $dest;
                super(1);
            }

            public final boolean invoke(@NotNull File $this$safeCall) {
                Intrinsics.checkNotNullParameter((Object)$this$safeCall, (String)"$this$safeCall");
                return $this$safeCall.renameTo(this.$dest);
            }
        });
    }
}

