/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.net;

import com.datadog.android.log.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/core/internal/net/UploadStatus;", "", "shouldRetry", "", "(Ljava/lang/String;IZ)V", "getShouldRetry", "()Z", "logStatus", "", "context", "", "byteSize", "", "logger", "Lcom/datadog/android/log/Logger;", "ignoreInfo", "requestId", "SUCCESS", "NETWORK_ERROR", "INVALID_TOKEN_ERROR", "HTTP_REDIRECTION", "HTTP_CLIENT_ERROR", "HTTP_SERVER_ERROR", "HTTP_CLIENT_RATE_LIMITING", "UNKNOWN_ERROR", "dd-sdk-android_release"})
public final class UploadStatus
extends Enum<UploadStatus> {
    private final boolean shouldRetry;
    public static final /* enum */ UploadStatus SUCCESS = new UploadStatus(false);
    public static final /* enum */ UploadStatus NETWORK_ERROR = new UploadStatus(true);
    public static final /* enum */ UploadStatus INVALID_TOKEN_ERROR = new UploadStatus(false);
    public static final /* enum */ UploadStatus HTTP_REDIRECTION = new UploadStatus(false);
    public static final /* enum */ UploadStatus HTTP_CLIENT_ERROR = new UploadStatus(false);
    public static final /* enum */ UploadStatus HTTP_SERVER_ERROR = new UploadStatus(true);
    public static final /* enum */ UploadStatus HTTP_CLIENT_RATE_LIMITING = new UploadStatus(true);
    public static final /* enum */ UploadStatus UNKNOWN_ERROR = new UploadStatus(false);
    private static final /* synthetic */ UploadStatus[] $VALUES;

    private UploadStatus(boolean shouldRetry) {
        this.shouldRetry = shouldRetry;
    }

    public final boolean getShouldRetry() {
        return this.shouldRetry;
    }

    public final void logStatus(@NotNull String context, int byteSize, @NotNull Logger logger, boolean ignoreInfo, @Nullable String requestId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        String batchInfo = requestId == null ? "Batch [" + byteSize + " bytes] (" + context + ')' : "Batch " + requestId + " [" + byteSize + " bytes] (" + context + ')';
        UploadStatus uploadStatus = this;
        int n = WhenMappings.$EnumSwitchMapping$0[uploadStatus.ordinal()];
        switch (n) {
            case 1: {
                Logger.e$default(logger, Intrinsics.stringPlus((String)batchInfo, (Object)" failed because of a network error; we will retry later."), null, null, 6, null);
                break;
            }
            case 2: {
                if (ignoreInfo) break;
                Logger.e$default(logger, Intrinsics.stringPlus((String)batchInfo, (Object)" failed because your token is invalid. Make sure that the provided token still exists."), null, null, 6, null);
                break;
            }
            case 3: {
                Logger.w$default(logger, Intrinsics.stringPlus((String)batchInfo, (Object)" failed because of a network redirection; the batch was dropped."), null, null, 6, null);
                break;
            }
            case 4: {
                Logger.e$default(logger, Intrinsics.stringPlus((String)batchInfo, (Object)" failed because of a processing error or invalid data; the batch was dropped."), null, null, 6, null);
                break;
            }
            case 5: {
                Logger.e$default(logger, Intrinsics.stringPlus((String)batchInfo, (Object)" failed because of a request error; we will retry later."), null, null, 6, null);
                break;
            }
            case 6: {
                Logger.e$default(logger, Intrinsics.stringPlus((String)batchInfo, (Object)" failed because of a server processing error; we will retry later."), null, null, 6, null);
                break;
            }
            case 7: {
                Logger.e$default(logger, Intrinsics.stringPlus((String)batchInfo, (Object)" failed because of an unknown error; the batch was dropped."), null, null, 6, null);
                break;
            }
            case 8: {
                if (ignoreInfo) break;
                Logger.v$default(logger, Intrinsics.stringPlus((String)batchInfo, (Object)" sent successfully."), null, null, 6, null);
            }
        }
    }

    public static /* synthetic */ void logStatus$default(UploadStatus uploadStatus, String string, int n, Logger logger, boolean bl, String string2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: logStatus");
        }
        if ((n2 & 0x10) != 0) {
            string2 = null;
        }
        uploadStatus.logStatus(string, n, logger, bl, string2);
    }

    public static UploadStatus[] values() {
        return (UploadStatus[])$VALUES.clone();
    }

    public static UploadStatus valueOf(String value) {
        return Enum.valueOf(UploadStatus.class, value);
    }

    static {
        $VALUES = uploadStatusArray = new UploadStatus[]{UploadStatus.SUCCESS, UploadStatus.NETWORK_ERROR, UploadStatus.INVALID_TOKEN_ERROR, UploadStatus.HTTP_REDIRECTION, UploadStatus.HTTP_CLIENT_ERROR, UploadStatus.HTTP_SERVER_ERROR, UploadStatus.HTTP_CLIENT_RATE_LIMITING, UploadStatus.UNKNOWN_ERROR};
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UploadStatus.values().length];
            nArray[UploadStatus.NETWORK_ERROR.ordinal()] = 1;
            nArray[UploadStatus.INVALID_TOKEN_ERROR.ordinal()] = 2;
            nArray[UploadStatus.HTTP_REDIRECTION.ordinal()] = 3;
            nArray[UploadStatus.HTTP_CLIENT_ERROR.ordinal()] = 4;
            nArray[UploadStatus.HTTP_CLIENT_RATE_LIMITING.ordinal()] = 5;
            nArray[UploadStatus.HTTP_SERVER_ERROR.ordinal()] = 6;
            nArray[UploadStatus.UNKNOWN_ERROR.ordinal()] = 7;
            nArray[UploadStatus.SUCCESS.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

