/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.net;

import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.net.DataOkHttpUploader;
import com.datadog.android.core.internal.net.DataUploader;
import com.datadog.android.core.internal.net.UploadStatus;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b \u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00150\u0014H&J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010!\u001a\u00020\u0003H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0006\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000b\"\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006#"}, d2={"Lcom/datadog/android/core/internal/net/DataOkHttpUploader;", "Lcom/datadog/android/core/internal/net/DataUploader;", "url", "", "callFactory", "Lokhttp3/Call$Factory;", "contentType", "(Ljava/lang/String;Lokhttp3/Call$Factory;Ljava/lang/String;)V", "getCallFactory$dd_sdk_android_release", "()Lokhttp3/Call$Factory;", "getContentType$dd_sdk_android_release", "()Ljava/lang/String;", "getUrl$dd_sdk_android_release", "setUrl$dd_sdk_android_release", "(Ljava/lang/String;)V", "userAgent", "getUserAgent", "userAgent$delegate", "Lkotlin/Lazy;", "buildQueryParams", "", "", "buildRequest", "Lokhttp3/Request;", "data", "", "headers", "", "responseCodeToUploadStatus", "Lcom/datadog/android/core/internal/net/UploadStatus;", "code", "", "upload", "urlWithQueryParams", "Companion", "dd-sdk-android_release"})
public abstract class DataOkHttpUploader
implements DataUploader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String url;
    @NotNull
    private final Call.Factory callFactory;
    @NotNull
    private final String contentType;
    @NotNull
    private final Lazy userAgent$delegate;
    @NotNull
    private static final String ACTIVE_THREADS_LOG_ATTRIBUTE_KEY = "active_threads";
    @NotNull
    public static final String CONTENT_TYPE_JSON = "application/json";
    @NotNull
    public static final String CONTENT_TYPE_TEXT_UTF8 = "text/plain;charset=UTF-8";
    @NotNull
    public static final String QP_BATCH_TIME = "batch_time";
    @NotNull
    public static final String QP_SOURCE = "ddsource";
    @NotNull
    private static final String HEADER_CT = "Content-Type";
    @NotNull
    private static final String HEADER_UA = "User-Agent";
    @NotNull
    public static final String SYSTEM_UA = "http.agent";

    public DataOkHttpUploader(@NotNull String url, @NotNull Call.Factory callFactory, @NotNull String contentType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)callFactory, (String)"callFactory");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.url = url;
        this.callFactory = callFactory;
        this.contentType = contentType;
        this.userAgent$delegate = LazyKt.lazy((Function0)userAgent.2.INSTANCE);
    }

    public /* synthetic */ DataOkHttpUploader(String string, Call.Factory factory, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = CONTENT_TYPE_JSON;
        }
        this(string, factory, string2);
    }

    @NotNull
    public final String getUrl$dd_sdk_android_release() {
        return this.url;
    }

    public final void setUrl$dd_sdk_android_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.url = string;
    }

    @NotNull
    public final Call.Factory getCallFactory$dd_sdk_android_release() {
        return this.callFactory;
    }

    @NotNull
    public final String getContentType$dd_sdk_android_release() {
        return this.contentType;
    }

    @Override
    @NotNull
    public UploadStatus upload(@NotNull byte[] data) {
        UploadStatus uploadStatus;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            Request request = this.buildRequest(data);
            Call call = this.callFactory.newCall(request);
            Response response = call.execute();
            response.close();
            uploadStatus = this.responseCodeToUploadStatus(response.code());
        }
        catch (Throwable e) {
            RuntimeUtilsKt.getSdkLogger().e("Unable to upload batch data.", e, MapsKt.mapOf((Pair)TuplesKt.to((Object)ACTIVE_THREADS_LOG_ATTRIBUTE_KEY, (Object)CoreFeature.INSTANCE.getUploadExecutorService$dd_sdk_android_release().getActiveCount())));
            uploadStatus = UploadStatus.NETWORK_ERROR;
        }
        return uploadStatus;
    }

    @NotNull
    public abstract Map<String, Object> buildQueryParams();

    private final Map<String, String> headers() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)HEADER_UA, (Object)this.getUserAgent()), TuplesKt.to((Object)HEADER_CT, (Object)this.contentType)};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    private final String getUserAgent() {
        Lazy lazy = this.userAgent$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final Request buildRequest(byte[] data) {
        String urlWithQueryParams = this.urlWithQueryParams();
        Request.Builder builder = new Request.Builder().url(urlWithQueryParams).post(RequestBody.create(null, (byte[])data));
        Map<String, String> $this$forEach$iv = this.headers();
        boolean $i$f$forEach = false;
        Map<String, String> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl2 = false;
            builder.addHeader(it.getKey(), it.getValue());
        }
        Request request = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"builder.build()");
        return request;
    }

    /*
     * WARNING - void declaration
     */
    private final String urlWithQueryParams() {
        String string;
        Map<String, Object> queryParams = this.buildQueryParams();
        if (queryParams.isEmpty()) {
            string = this.url;
        } else {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map<String, Object> map = queryParams;
            String string2 = this.url;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var7_8 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var7_8.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl2 = false;
                String string3 = (String)it.getKey() + '=' + it.getValue();
                collection.add(string3);
            }
            collection = (List)destination$iv$iv;
            string = Intrinsics.stringPlus((String)string2, (Object)CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"&", (CharSequence)"?", null, (int)0, null, null, (int)60, null));
        }
        return string;
    }

    private final UploadStatus responseCodeToUploadStatus(int code) {
        UploadStatus uploadStatus;
        block1: {
            int n;
            block3: {
                block2: {
                    block0: {
                        n = code;
                        if (n != 403) break block0;
                        uploadStatus = UploadStatus.INVALID_TOKEN_ERROR;
                        break block1;
                    }
                    boolean bl = 200 <= n ? n <= 299 : false;
                    if (!bl) break block2;
                    uploadStatus = UploadStatus.SUCCESS;
                    break block1;
                }
                boolean bl = 300 <= n ? n <= 399 : false;
                if (!bl) break block3;
                uploadStatus = UploadStatus.HTTP_REDIRECTION;
                break block1;
            }
            uploadStatus = (400 <= n ? n <= 499 : false) ? UploadStatus.HTTP_CLIENT_ERROR : ((500 <= n ? n <= 599 : false) ? UploadStatus.HTTP_SERVER_ERROR : UploadStatus.UNKNOWN_ERROR);
        }
        return uploadStatus;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/core/internal/net/DataOkHttpUploader$Companion;", "", "()V", "ACTIVE_THREADS_LOG_ATTRIBUTE_KEY", "", "CONTENT_TYPE_JSON", "CONTENT_TYPE_TEXT_UTF8", "HEADER_CT", "HEADER_UA", "QP_BATCH_TIME", "QP_SOURCE", "SYSTEM_UA", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

