/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.lifecycle;

import android.content.Context;
import com.datadog.android.core.internal.lifecycle.ProcessLifecycleMonitor;
import com.datadog.android.core.internal.net.info.NetworkInfoProvider;
import com.datadog.android.core.internal.utils.WorkManagerUtilsKt;
import com.datadog.android.core.model.NetworkInfo;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/datadog/android/core/internal/lifecycle/ProcessLifecycleCallback;", "Lcom/datadog/android/core/internal/lifecycle/ProcessLifecycleMonitor$Callback;", "networkInfoProvider", "Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "appContext", "Landroid/content/Context;", "(Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;Landroid/content/Context;)V", "contextWeakRef", "Ljava/lang/ref/WeakReference;", "getNetworkInfoProvider", "()Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "onPaused", "", "onResumed", "onStarted", "onStopped", "dd-sdk-android_release"})
public final class ProcessLifecycleCallback
implements ProcessLifecycleMonitor.Callback {
    @NotNull
    private final NetworkInfoProvider networkInfoProvider;
    @NotNull
    private final WeakReference<Context> contextWeakRef;

    public ProcessLifecycleCallback(@NotNull NetworkInfoProvider networkInfoProvider, @NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.networkInfoProvider = networkInfoProvider;
        this.contextWeakRef = new WeakReference<Context>(appContext);
    }

    @NotNull
    public final NetworkInfoProvider getNetworkInfoProvider() {
        return this.networkInfoProvider;
    }

    @Override
    public void onStarted() {
        Context context = (Context)this.contextWeakRef.get();
        if (context != null) {
            Context context2 = context;
            boolean bl = false;
            boolean bl2 = false;
            Context it = context2;
            boolean bl3 = false;
            WorkManagerUtilsKt.cancelUploadWorker(it);
        }
    }

    @Override
    public void onResumed() {
    }

    @Override
    public void onStopped() {
        Context context;
        boolean isOffline;
        boolean bl = isOffline = this.networkInfoProvider.getLatestNetworkInfo().getConnectivity() == NetworkInfo.Connectivity.NETWORK_NOT_CONNECTED;
        if (isOffline && (context = (Context)this.contextWeakRef.get()) != null) {
            Context context2 = context;
            boolean bl2 = false;
            boolean bl3 = false;
            Context it = context2;
            boolean bl4 = false;
            WorkManagerUtilsKt.triggerUploadWorker(it);
        }
    }

    @Override
    public void onPaused() {
    }
}

