/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.data.upload;

import android.content.Context;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.datadog.android.Datadog;
import com.datadog.android.core.internal.net.DataUploader;
import com.datadog.android.core.internal.net.UploadStatus;
import com.datadog.android.core.internal.persistence.Batch;
import com.datadog.android.core.internal.persistence.DataReader;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.error.internal.CrashReportsFeature;
import com.datadog.android.log.Logger;
import com.datadog.android.log.internal.LogsFeature;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.tracing.internal.TracesFeature;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadWorker;", "Landroidx/work/Worker;", "appContext", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "consumeBatch", "", "batch", "Lcom/datadog/android/core/internal/persistence/Batch;", "uploader", "Lcom/datadog/android/core/internal/net/DataUploader;", "doWork", "Landroidx/work/ListenableWorker$Result;", "uploadAllBatches", "", "reader", "Lcom/datadog/android/core/internal/persistence/DataReader;", "Companion", "dd-sdk-android_release"})
public final class UploadWorker
extends Worker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "UploadWorker";

    public UploadWorker(@NotNull Context appContext, @NotNull WorkerParameters workerParams) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)workerParams, (String)"workerParams");
        super(appContext, workerParams);
    }

    @NotNull
    public ListenableWorker.Result doWork() {
        if (!Datadog.isInitialized()) {
            Logger.e$default(RuntimeUtilsKt.getDevLogger(), "Datadog has not been initialized.\nPlease add the following code in your application's onCreate() method:\nval credentials = Credentials(\"<CLIENT_TOKEN>\", \"<ENVIRONMENT>\", \"<VARIANT>\", \"<APPLICATION_ID>\")\nDatadog.initialize(context, credentials, configuration, trackingConsent);", null, null, 6, null);
            ListenableWorker.Result result = ListenableWorker.Result.success();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
            return result;
        }
        this.uploadAllBatches(CrashReportsFeature.INSTANCE.getPersistenceStrategy$dd_sdk_android_release().getReader(), CrashReportsFeature.INSTANCE.getUploader$dd_sdk_android_release());
        this.uploadAllBatches(LogsFeature.INSTANCE.getPersistenceStrategy$dd_sdk_android_release().getReader(), LogsFeature.INSTANCE.getUploader$dd_sdk_android_release());
        this.uploadAllBatches(TracesFeature.INSTANCE.getPersistenceStrategy$dd_sdk_android_release().getReader(), TracesFeature.INSTANCE.getUploader$dd_sdk_android_release());
        this.uploadAllBatches(RumFeature.INSTANCE.getPersistenceStrategy$dd_sdk_android_release().getReader(), RumFeature.INSTANCE.getUploader$dd_sdk_android_release());
        ListenableWorker.Result result = ListenableWorker.Result.success();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
        return result;
    }

    private final void uploadAllBatches(DataReader reader, DataUploader uploader) {
        boolean bl = false;
        List failedBatches = new ArrayList();
        Batch batch = null;
        do {
            if ((batch = reader.lockAndReadNext()) == null) continue;
            if (this.consumeBatch(batch, uploader)) {
                reader.drop(batch);
                continue;
            }
            failedBatches.add(batch);
        } while (batch != null);
        Iterable $this$forEach$iv = failedBatches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Batch it = (Batch)element$iv;
            boolean bl2 = false;
            reader.release(it);
        }
    }

    private final boolean consumeBatch(Batch batch, DataUploader uploader) {
        UploadStatus status = uploader.upload(batch.getData());
        String string = uploader.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uploader.javaClass.simpleName");
        UploadStatus.logStatus$default(status, string, batch.getData().length, RuntimeUtilsKt.getDevLogger(), false, null, 16, null);
        string = uploader.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uploader.javaClass.simpleName");
        UploadStatus.logStatus$default(status, string, batch.getData().length, RuntimeUtilsKt.getSdkLogger(), true, null, 16, null);
        return status == UploadStatus.SUCCESS;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadWorker$Companion;", "", "()V", "TAG", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

