/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal;

import android.content.Context;
import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.data.upload.DataUploadScheduler;
import com.datadog.android.core.internal.data.upload.NoOpUploadScheduler;
import com.datadog.android.core.internal.data.upload.UploadScheduler;
import com.datadog.android.core.internal.net.DataUploader;
import com.datadog.android.core.internal.net.NoOpDataUploader;
import com.datadog.android.core.internal.persistence.NoOpPersistenceStrategy;
import com.datadog.android.core.internal.persistence.PersistenceStrategy;
import com.datadog.android.core.internal.privacy.ConsentProvider;
import com.datadog.android.plugin.DatadogPlugin;
import com.datadog.android.plugin.DatadogPluginConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010!\u001a\u00020\"J#\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00020\u001c2\u0006\u0010&\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010)J\u0006\u0010*\u001a\u00020\"J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0,J\u001b\u0010-\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00028\u0001\u00a2\u0006\u0002\u0010.J\u0006\u0010/\u001a\u000200J\u001d\u00101\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010.J\u0010\u00102\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0016J\b\u00103\u001a\u00020\"H\u0016J\b\u00104\u001a\u00020\"H\u0016J&\u00105\u001a\u00020\"2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\b0,2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002J\u0015\u0010;\u001a\u00020\"2\u0006\u0010&\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010<J\u0006\u0010=\u001a\u00020\"J\b\u0010>\u001a\u00020\"H\u0002R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006?"}, d2={"Lcom/datadog/android/core/internal/SdkFeature;", "T", "", "C", "Lcom/datadog/android/core/configuration/Configuration$Feature;", "()V", "featurePlugins", "", "Lcom/datadog/android/plugin/DatadogPlugin;", "getFeaturePlugins$dd_sdk_android_release", "()Ljava/util/List;", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "persistenceStrategy", "Lcom/datadog/android/core/internal/persistence/PersistenceStrategy;", "getPersistenceStrategy$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/PersistenceStrategy;", "setPersistenceStrategy$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/persistence/PersistenceStrategy;)V", "uploadScheduler", "Lcom/datadog/android/core/internal/data/upload/UploadScheduler;", "getUploadScheduler$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/data/upload/UploadScheduler;", "setUploadScheduler$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/data/upload/UploadScheduler;)V", "uploader", "Lcom/datadog/android/core/internal/net/DataUploader;", "getUploader$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/net/DataUploader;", "setUploader$dd_sdk_android_release", "(Lcom/datadog/android/core/internal/net/DataUploader;)V", "clearAllData", "", "createPersistenceStrategy", "context", "Landroid/content/Context;", "configuration", "(Landroid/content/Context;Lcom/datadog/android/core/configuration/Configuration$Feature;)Lcom/datadog/android/core/internal/persistence/PersistenceStrategy;", "createUploader", "(Lcom/datadog/android/core/configuration/Configuration$Feature;)Lcom/datadog/android/core/internal/net/DataUploader;", "flushStoredData", "getPlugins", "", "initialize", "(Landroid/content/Context;Lcom/datadog/android/core/configuration/Configuration$Feature;)V", "isInitialized", "", "onInitialize", "onPostInitialized", "onPostStopped", "onStop", "registerPlugins", "plugins", "config", "Lcom/datadog/android/plugin/DatadogPluginConfig;", "trackingConsentProvider", "Lcom/datadog/android/core/internal/privacy/ConsentProvider;", "setupUploader", "(Lcom/datadog/android/core/configuration/Configuration$Feature;)V", "stop", "unregisterPlugins", "dd-sdk-android_release"})
public abstract class SdkFeature<T, C extends Configuration.Feature> {
    @NotNull
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    @NotNull
    private PersistenceStrategy<T> persistenceStrategy = new NoOpPersistenceStrategy();
    @NotNull
    private DataUploader uploader = new NoOpDataUploader();
    @NotNull
    private UploadScheduler uploadScheduler = new NoOpUploadScheduler();
    @NotNull
    private final List<DatadogPlugin> featurePlugins;

    public SdkFeature() {
        boolean bl = false;
        this.featurePlugins = new ArrayList();
    }

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_release() {
        return this.initialized;
    }

    @NotNull
    public final PersistenceStrategy<T> getPersistenceStrategy$dd_sdk_android_release() {
        return this.persistenceStrategy;
    }

    public final void setPersistenceStrategy$dd_sdk_android_release(@NotNull PersistenceStrategy<T> persistenceStrategy) {
        Intrinsics.checkNotNullParameter(persistenceStrategy, (String)"<set-?>");
        this.persistenceStrategy = persistenceStrategy;
    }

    @NotNull
    public final DataUploader getUploader$dd_sdk_android_release() {
        return this.uploader;
    }

    public final void setUploader$dd_sdk_android_release(@NotNull DataUploader dataUploader) {
        Intrinsics.checkNotNullParameter((Object)dataUploader, (String)"<set-?>");
        this.uploader = dataUploader;
    }

    @NotNull
    public final UploadScheduler getUploadScheduler$dd_sdk_android_release() {
        return this.uploadScheduler;
    }

    public final void setUploadScheduler$dd_sdk_android_release(@NotNull UploadScheduler uploadScheduler) {
        Intrinsics.checkNotNullParameter((Object)uploadScheduler, (String)"<set-?>");
        this.uploadScheduler = uploadScheduler;
    }

    @NotNull
    public final List<DatadogPlugin> getFeaturePlugins$dd_sdk_android_release() {
        return this.featurePlugins;
    }

    public final void initialize(@NotNull Context context, @NotNull C configuration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        if (this.initialized.get()) {
            return;
        }
        this.persistenceStrategy = this.createPersistenceStrategy(context, configuration);
        this.setupUploader(configuration);
        this.registerPlugins(((Configuration.Feature)configuration).getPlugins(), new DatadogPluginConfig(context, CoreFeature.INSTANCE.getEnvName$dd_sdk_android_release(), CoreFeature.INSTANCE.getServiceName$dd_sdk_android_release(), CoreFeature.INSTANCE.getTrackingConsentProvider$dd_sdk_android_release().getConsent()), CoreFeature.INSTANCE.getTrackingConsentProvider$dd_sdk_android_release());
        this.onInitialize(context, configuration);
        this.initialized.set(true);
        this.onPostInitialized(context);
    }

    public final boolean isInitialized() {
        return this.initialized.get();
    }

    public final void clearAllData() {
        this.persistenceStrategy.getReader().dropAll();
    }

    public final void stop() {
        if (this.initialized.get()) {
            this.unregisterPlugins();
            this.uploadScheduler.stopScheduling();
            this.persistenceStrategy = new NoOpPersistenceStrategy();
            this.uploadScheduler = new NoOpUploadScheduler();
            this.onStop();
            this.initialized.set(false);
            this.onPostStopped();
        }
    }

    @NotNull
    public final List<DatadogPlugin> getPlugins() {
        return this.featurePlugins;
    }

    public final void flushStoredData() {
        this.persistenceStrategy.getFlusher().flush(this.uploader);
    }

    public void onInitialize(@NotNull Context context, @NotNull C configuration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
    }

    public void onPostInitialized(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    public void onStop() {
    }

    public void onPostStopped() {
    }

    @NotNull
    public abstract PersistenceStrategy<T> createPersistenceStrategy(@NotNull Context var1, @NotNull C var2);

    @NotNull
    public abstract DataUploader createUploader(@NotNull C var1);

    private final void registerPlugins(List<? extends DatadogPlugin> plugins, DatadogPluginConfig config, ConsentProvider trackingConsentProvider) {
        Iterable $this$forEach$iv = plugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatadogPlugin it = (DatadogPlugin)element$iv;
            boolean bl = false;
            this.getFeaturePlugins$dd_sdk_android_release().add(it);
            it.register(config);
            trackingConsentProvider.registerCallback(it);
        }
    }

    private final void unregisterPlugins() {
        Iterable $this$forEach$iv = this.featurePlugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatadogPlugin it = (DatadogPlugin)element$iv;
            boolean bl = false;
            it.unregister();
        }
        this.featurePlugins.clear();
    }

    private final void setupUploader(C configuration) {
        UploadScheduler uploadScheduler;
        if (CoreFeature.INSTANCE.isMainProcess$dd_sdk_android_release()) {
            this.uploader = this.createUploader(configuration);
            uploadScheduler = new DataUploadScheduler(this.persistenceStrategy.getReader(), this.uploader, CoreFeature.INSTANCE.getNetworkInfoProvider$dd_sdk_android_release(), CoreFeature.INSTANCE.getSystemInfoProvider$dd_sdk_android_release(), CoreFeature.INSTANCE.getUploadFrequency$dd_sdk_android_release(), CoreFeature.INSTANCE.getUploadExecutorService$dd_sdk_android_release());
        } else {
            uploadScheduler = new NoOpUploadScheduler();
        }
        this.uploadScheduler = uploadScheduler;
        this.uploadScheduler.startScheduling();
    }
}

