/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android;

import android.app.Application;
import android.content.Context;
import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.configuration.Credentials;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.lifecycle.ProcessLifecycleCallback;
import com.datadog.android.core.internal.lifecycle.ProcessLifecycleMonitor;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.model.UserInfo;
import com.datadog.android.error.internal.CrashReportsFeature;
import com.datadog.android.log.Logger;
import com.datadog.android.log.internal.LogsFeature;
import com.datadog.android.monitoring.internal.InternalLogsFeature;
import com.datadog.android.privacy.TrackingConsent;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.rum.internal.monitor.DatadogRumMonitor;
import com.datadog.android.tracing.internal.TracesFeature;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010#H\u0002J\b\u0010$\u001a\u00020!H\u0007J\b\u0010%\u001a\u00020!H\u0002J(\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0007J\u001a\u0010/\u001a\u00020!2\b\u0010+\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020(H\u0002J\u001a\u00102\u001a\u00020!2\b\u0010+\u001a\u0004\u0018\u0001032\u0006\u00101\u001a\u00020(H\u0002J\u001a\u00104\u001a\u00020!2\b\u0010+\u001a\u0004\u0018\u0001052\u0006\u00101\u001a\u00020(H\u0002J\u001a\u00106\u001a\u00020!2\b\u0010+\u001a\u0004\u0018\u0001072\u0006\u00101\u001a\u00020(H\u0002J\u001a\u00108\u001a\u00020!2\b\u0010+\u001a\u0004\u0018\u0001092\u0006\u00101\u001a\u00020(H\u0002J\b\u0010:\u001a\u00020\u0012H\u0007J\u0010\u0010;\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010<\u001a\u00020!2\u0006\u0010=\u001a\u00020.H\u0007JD\u0010>\u001a\u00020!2\n\b\u0002\u0010?\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010@\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u00042\u0016\b\u0002\u0010B\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010#H\u0007J\u0010\u0010C\u001a\u00020!2\u0006\u0010D\u001a\u00020\u0018H\u0007J\u0010\u0010E\u001a\u00020!2\u0006\u00101\u001a\u00020(H\u0002J\b\u0010F\u001a\u00020!H\u0002J\u0010\u0010G\u001a\u00020\u00122\u0006\u0010H\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006I"}, d2={"Lcom/datadog/android/Datadog;", "", "()V", "DD_SDK_VERSION_TAG", "", "DD_SOURCE_TAG", "ENV_NAME_VALIDATION_REG_EX", "MESSAGE_ALREADY_INITIALIZED", "MESSAGE_DEPRECATED", "MESSAGE_ENV_NAME_NOT_VALID", "MESSAGE_NOT_INITIALIZED", "SHUTDOWN_THREAD", "WARNING_MESSAGE_APPLICATION_ID_IS_NULL", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "isDebug", "", "isDebug$dd_sdk_android_release", "()Z", "setDebug$dd_sdk_android_release", "(Z)V", "<set-?>", "", "libraryVerbosity", "getLibraryVerbosity$dd_sdk_android_release", "()I", "startupTimeNs", "", "getStartupTimeNs$dd_sdk_android_release", "()J", "applyAdditionalConfiguration", "", "additionalConfiguration", "", "clearAllData", "flushAndShutdownExecutors", "initialize", "context", "Landroid/content/Context;", "credentials", "Lcom/datadog/android/core/configuration/Credentials;", "configuration", "Lcom/datadog/android/core/configuration/Configuration;", "trackingConsent", "Lcom/datadog/android/privacy/TrackingConsent;", "initializeCrashReportFeature", "Lcom/datadog/android/core/configuration/Configuration$Feature$CrashReport;", "appContext", "initializeInternalLogsFeature", "Lcom/datadog/android/core/configuration/Configuration$Feature$InternalLogs;", "initializeLogsFeature", "Lcom/datadog/android/core/configuration/Configuration$Feature$Logs;", "initializeRumFeature", "Lcom/datadog/android/core/configuration/Configuration$Feature$RUM;", "initializeTracingFeature", "Lcom/datadog/android/core/configuration/Configuration$Feature$Tracing;", "isInitialized", "resolveIsDebug", "setTrackingConsent", "consent", "setUserInfo", "id", "name", "email", "extraInfo", "setVerbosity", "level", "setupLifecycleMonitorCallback", "stop", "validateEnvironmentName", "envName", "dd-sdk-android_release"})
public final class Datadog {
    @NotNull
    public static final Datadog INSTANCE = new Datadog();
    @NotNull
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final long startupTimeNs = System.nanoTime();
    private static int libraryVerbosity = Integer.MAX_VALUE;
    private static boolean isDebug;
    @NotNull
    public static final String MESSAGE_ALREADY_INITIALIZED = "The Datadog library has already been initialized.";
    @NotNull
    public static final String WARNING_MESSAGE_APPLICATION_ID_IS_NULL = "You're trying to enable RUM but no Application Id was provided. Please pass this value into the Datadog Credentials:\nval credentials = Credentials(\"<CLIENT_TOKEN>\", \"<ENVIRONMENT>\", \"<VARIANT>\", \"<APPLICATION_ID>\")\nDatadog.initialize(context, credentials, configuration, trackingConsent);";
    @NotNull
    public static final String MESSAGE_NOT_INITIALIZED = "Datadog has not been initialized.\nPlease add the following code in your application's onCreate() method:\nval credentials = Credentials(\"<CLIENT_TOKEN>\", \"<ENVIRONMENT>\", \"<VARIANT>\", \"<APPLICATION_ID>\")\nDatadog.initialize(context, credentials, configuration, trackingConsent);";
    @NotNull
    public static final String MESSAGE_DEPRECATED = "%s has been deprecated. If you need it, submit an issue at https://github.com/DataDog/dd-sdk-android/issues/";
    @NotNull
    public static final String SHUTDOWN_THREAD = "datadog_shutdown";
    @NotNull
    public static final String ENV_NAME_VALIDATION_REG_EX = "[a-zA-Z0-9_:./-]{0,195}[a-zA-Z0-9_./-]";
    @NotNull
    public static final String MESSAGE_ENV_NAME_NOT_VALID = "The environment name should contain maximum 196 of the following allowed characters [a-zA-Z0-9_:./-] and should never finish with a semicolon.In this case the Datadog SDK will not be initialised.";
    @NotNull
    public static final String DD_SOURCE_TAG = "_dd.source";
    @NotNull
    public static final String DD_SDK_VERSION_TAG = "_dd.sdk_version";

    private Datadog() {
    }

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_release() {
        return initialized;
    }

    public final long getStartupTimeNs$dd_sdk_android_release() {
        return startupTimeNs;
    }

    public final int getLibraryVerbosity$dd_sdk_android_release() {
        return libraryVerbosity;
    }

    public final boolean isDebug$dd_sdk_android_release() {
        return isDebug;
    }

    public final void setDebug$dd_sdk_android_release(boolean bl) {
        isDebug = bl;
    }

    @JvmStatic
    public static final void initialize(@NotNull Context context, @NotNull Credentials credentials, @NotNull Configuration configuration, @NotNull TrackingConsent trackingConsent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)trackingConsent), (String)"trackingConsent");
        if (initialized.get()) {
            Logger.w$default(RuntimeUtilsKt.getDevLogger(), MESSAGE_ALREADY_INITIALIZED, null, null, 6, null);
            return;
        }
        Context appContext = context.getApplicationContext();
        isDebug = INSTANCE.resolveIsDebug(context);
        if (!INSTANCE.validateEnvironmentName(credentials.getEnvName())) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)appContext, (String)"appContext");
        CoreFeature.INSTANCE.initialize(appContext, credentials, configuration.getCoreConfig$dd_sdk_android_release(), trackingConsent);
        INSTANCE.applyAdditionalConfiguration(configuration.getAdditionalConfig$dd_sdk_android_release());
        INSTANCE.initializeLogsFeature(configuration.getLogsConfig$dd_sdk_android_release(), appContext);
        INSTANCE.initializeTracingFeature(configuration.getTracesConfig$dd_sdk_android_release(), appContext);
        INSTANCE.initializeRumFeature(configuration.getRumConfig$dd_sdk_android_release(), appContext);
        INSTANCE.initializeCrashReportFeature(configuration.getCrashReportConfig$dd_sdk_android_release(), appContext);
        INSTANCE.initializeInternalLogsFeature(configuration.getInternalLogsConfig$dd_sdk_android_release(), appContext);
        CoreFeature.INSTANCE.getNdkCrashHandler$dd_sdk_android_release().handleNdkCrash(LogsFeature.INSTANCE.getPersistenceStrategy$dd_sdk_android_release().getWriter(), RumFeature.INSTANCE.getPersistenceStrategy$dd_sdk_android_release().getWriter());
        INSTANCE.setupLifecycleMonitorCallback(appContext);
        initialized.set(true);
        Runtime.getRuntime().addShutdownHook(new Thread(Datadog::initialize$lambda-0, SHUTDOWN_THREAD));
    }

    @JvmStatic
    public static final boolean isInitialized() {
        return initialized.get();
    }

    @JvmStatic
    public static final void clearAllData() {
        LogsFeature.INSTANCE.clearAllData();
        CrashReportsFeature.INSTANCE.clearAllData();
        RumFeature.INSTANCE.clearAllData();
        TracesFeature.INSTANCE.clearAllData();
        InternalLogsFeature.INSTANCE.clearAllData();
    }

    private final void stop() {
        if (initialized.get()) {
            LogsFeature.INSTANCE.stop();
            TracesFeature.INSTANCE.stop();
            RumFeature.INSTANCE.stop();
            CrashReportsFeature.INSTANCE.stop();
            CoreFeature.INSTANCE.stop();
            InternalLogsFeature.INSTANCE.stop();
            isDebug = false;
            initialized.set(false);
        }
    }

    private final void flushAndShutdownExecutors() {
        if (initialized.get()) {
            DatadogRumMonitor datadogRumMonitor;
            RumMonitor rumMonitor = GlobalRum.get();
            DatadogRumMonitor datadogRumMonitor2 = datadogRumMonitor = rumMonitor instanceof DatadogRumMonitor ? (DatadogRumMonitor)rumMonitor : null;
            if (datadogRumMonitor != null) {
                rumMonitor = datadogRumMonitor;
                boolean bl = false;
                boolean bl2 = false;
                RumMonitor it = rumMonitor;
                boolean bl3 = false;
                ((DatadogRumMonitor)it).stopKeepAliveCallback$dd_sdk_android_release();
                ((DatadogRumMonitor)it).drainExecutorService$dd_sdk_android_release();
            }
            CoreFeature.INSTANCE.drainAndShutdownExecutors();
            LogsFeature.INSTANCE.flushStoredData();
            TracesFeature.INSTANCE.flushStoredData();
            RumFeature.INSTANCE.flushStoredData();
            CrashReportsFeature.INSTANCE.flushStoredData();
        }
    }

    @JvmStatic
    public static final void setVerbosity(int level) {
        libraryVerbosity = level;
    }

    @JvmStatic
    public static final void setTrackingConsent(@NotNull TrackingConsent consent) {
        Intrinsics.checkNotNullParameter((Object)((Object)consent), (String)"consent");
        CoreFeature.INSTANCE.getTrackingConsentProvider$dd_sdk_android_release().setConsent(consent);
    }

    @JvmStatic
    @JvmOverloads
    public static final void setUserInfo(@Nullable String id, @Nullable String name, @Nullable String email, @NotNull Map<String, ? extends Object> extraInfo) {
        Intrinsics.checkNotNullParameter(extraInfo, (String)"extraInfo");
        CoreFeature.INSTANCE.getUserInfoProvider$dd_sdk_android_release().setUserInfo(new UserInfo(id, name, email, extraInfo));
    }

    public static /* synthetic */ void setUserInfo$default(String string, String string2, String string3, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        Datadog.setUserInfo(string, string2, string3, map);
    }

    private final void initializeLogsFeature(Configuration.Feature.Logs configuration, Context appContext) {
        if (configuration != null) {
            LogsFeature.INSTANCE.initialize(appContext, (Configuration.Feature)configuration);
        }
    }

    private final void initializeCrashReportFeature(Configuration.Feature.CrashReport configuration, Context appContext) {
        if (configuration != null) {
            CrashReportsFeature.INSTANCE.initialize(appContext, (Configuration.Feature)configuration);
        }
    }

    private final void initializeTracingFeature(Configuration.Feature.Tracing configuration, Context appContext) {
        if (configuration != null) {
            TracesFeature.INSTANCE.initialize(appContext, (Configuration.Feature)configuration);
        }
    }

    private final void initializeRumFeature(Configuration.Feature.RUM configuration, Context appContext) {
        if (configuration != null) {
            CharSequence charSequence = CoreFeature.INSTANCE.getRumApplicationId$dd_sdk_android_release();
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                Logger.w$default(RuntimeUtilsKt.getDevLogger(), WARNING_MESSAGE_APPLICATION_ID_IS_NULL, null, null, 6, null);
            }
            RumFeature.INSTANCE.initialize(appContext, (Configuration.Feature)configuration);
        }
    }

    private final void initializeInternalLogsFeature(Configuration.Feature.InternalLogs configuration, Context appContext) {
        if (configuration != null) {
            InternalLogsFeature.INSTANCE.initialize(appContext, (Configuration.Feature)configuration);
        }
    }

    private final void applyAdditionalConfiguration(Map<String, ? extends Object> additionalConfiguration) {
        boolean bl;
        CharSequence charSequence;
        Object it;
        boolean bl2;
        boolean bl3;
        Object object;
        Object object2 = additionalConfiguration.get(DD_SOURCE_TAG);
        if (object2 != null) {
            object = object2;
            bl3 = false;
            bl2 = false;
            it = object;
            boolean bl4 = false;
            if (it instanceof String) {
                charSequence = (CharSequence)it;
                bl = false;
                if (!StringsKt.isBlank((CharSequence)charSequence)) {
                    CoreFeature.INSTANCE.setSourceName$dd_sdk_android_release((String)it);
                }
            }
        }
        object2 = additionalConfiguration.get(DD_SDK_VERSION_TAG);
        if (object2 != null) {
            object = object2;
            bl3 = false;
            bl2 = false;
            it = object;
            boolean bl5 = false;
            if (it instanceof String) {
                charSequence = (CharSequence)it;
                bl = false;
                if (!StringsKt.isBlank((CharSequence)charSequence)) {
                    CoreFeature.INSTANCE.setSdkVersion$dd_sdk_android_release((String)it);
                }
            }
        }
    }

    private final boolean validateEnvironmentName(String envName) {
        CharSequence charSequence = envName;
        Regex regex = new Regex(ENV_NAME_VALIDATION_REG_EX);
        boolean bl = false;
        if (!regex.matches(charSequence)) {
            if (isDebug) {
                throw new IllegalArgumentException(MESSAGE_ENV_NAME_NOT_VALID);
            }
            Logger.e$default(RuntimeUtilsKt.getDevLogger(), MESSAGE_ENV_NAME_NOT_VALID, null, null, 6, null);
            return false;
        }
        return true;
    }

    private final void setupLifecycleMonitorCallback(Context appContext) {
        if (appContext instanceof Application) {
            ProcessLifecycleCallback callback = new ProcessLifecycleCallback(CoreFeature.INSTANCE.getNetworkInfoProvider$dd_sdk_android_release(), appContext);
            ((Application)appContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ProcessLifecycleMonitor(callback));
        }
    }

    private final boolean resolveIsDebug(Context context) {
        return (context.getApplicationInfo().flags & 2) != 0;
    }

    @JvmStatic
    @JvmOverloads
    public static final void setUserInfo(@Nullable String id, @Nullable String name, @Nullable String email) {
        Datadog.setUserInfo$default(id, name, email, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void setUserInfo(@Nullable String id, @Nullable String name) {
        Datadog.setUserInfo$default(id, name, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void setUserInfo(@Nullable String id) {
        Datadog.setUserInfo$default(id, null, null, null, 14, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void setUserInfo() {
        Datadog.setUserInfo$default(null, null, null, null, 15, null);
    }

    private static final void initialize$lambda-0() {
        INSTANCE.stop();
    }
}

