/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview.internal.rum.domain;

import com.datadog.android.webview.internal.rum.domain.NativeRumViewsCache;
import com.datadog.android.webview.internal.rum.domain.RumContext;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/webview/internal/rum/domain/WebViewNativeRumViewsCache;", "Lcom/datadog/android/webview/internal/rum/domain/NativeRumViewsCache;", "entriesTtlLimitInMs", "", "(J)V", "parentViewsHistoryQueue", "Ljava/util/LinkedList;", "Lcom/datadog/android/webview/internal/rum/domain/WebViewNativeRumViewsCache$ViewEntry;", "getParentViewsHistoryQueue$dd_sdk_android_webview_release", "()Ljava/util/LinkedList;", "addToCache", "", "entry", "event", "", "", "", "purgeHistory", "resolveLastParentIdForBrowserEvent", "browserEventTimestampInMs", "Companion", "ViewEntry", "dd-sdk-android-webview_release"})
public final class WebViewNativeRumViewsCache
implements NativeRumViewsCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long entriesTtlLimitInMs;
    @NotNull
    private final LinkedList<ViewEntry> parentViewsHistoryQueue;
    @NotNull
    public static final String VIEW_ID_KEY = "view_id";
    @NotNull
    public static final String VIEW_TIMESTAMP_KEY = "view_timestamp";
    @NotNull
    public static final String VIEW_HAS_REPLAY_KEY = "view_has_replay";
    private static final long DATA_PURGE_TTL_LIMIT_IN_MS = TimeUnit.HOURS.toMillis(2L);
    public static final int DATA_CACHE_ENTRIES_LIMIT = 30;

    public WebViewNativeRumViewsCache(long entriesTtlLimitInMs) {
        this.entriesTtlLimitInMs = entriesTtlLimitInMs;
        this.parentViewsHistoryQueue = new LinkedList();
    }

    public /* synthetic */ WebViewNativeRumViewsCache(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = DATA_PURGE_TTL_LIMIT_IN_MS;
        }
        this(l);
    }

    @NotNull
    public final LinkedList<ViewEntry> getParentViewsHistoryQueue$dd_sdk_android_webview_release() {
        return this.parentViewsHistoryQueue;
    }

    @Override
    @Nullable
    public synchronized String resolveLastParentIdForBrowserEvent(long browserEventTimestampInMs) {
        Iterator iterator = this.parentViewsHistoryQueue.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"parentViewsHistoryQueue.iterator()");
        Iterator iterator2 = iterator;
        String backupCandidate = null;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"iterator.next()");
            ViewEntry entry = (ViewEntry)e;
            if (entry.getTimestamp() > browserEventTimestampInMs) continue;
            if (backupCandidate == null) {
                backupCandidate = entry.getViewId();
            }
            if (!entry.getHasReplay()) continue;
            return entry.getViewId();
        }
        return backupCandidate;
    }

    @Override
    public synchronized void addToCache(@NotNull Map<String, ? extends Object> event) {
        boolean hasReplay;
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Object object = event.get(VIEW_ID_KEY);
        String activeViewId = object instanceof String ? (String)object : null;
        Object object2 = event.get(VIEW_TIMESTAMP_KEY);
        Long eventTimestamp = object2 instanceof Long ? (Long)object2 : null;
        Object object3 = event.get(VIEW_HAS_REPLAY_KEY);
        Boolean bl = object3 instanceof Boolean ? (Boolean)object3 : null;
        boolean bl2 = hasReplay = bl != null ? bl : false;
        if (activeViewId != null && !Intrinsics.areEqual((Object)activeViewId, (Object)RumContext.Companion.getNULL_UUID()) && eventTimestamp != null) {
            ViewEntry newEntry = new ViewEntry(activeViewId, eventTimestamp, hasReplay);
            this.addToCache(newEntry);
        }
        this.purgeHistory();
    }

    private final void addToCache(ViewEntry entry) {
        if (this.parentViewsHistoryQueue.isEmpty() || !Intrinsics.areEqual((Object)this.parentViewsHistoryQueue.getFirst().getViewId(), (Object)entry.getViewId()) && this.parentViewsHistoryQueue.getFirst().getTimestamp() <= entry.getTimestamp()) {
            this.parentViewsHistoryQueue.addFirst(entry);
        } else if (Intrinsics.areEqual((Object)this.parentViewsHistoryQueue.getFirst().getViewId(), (Object)entry.getViewId())) {
            this.parentViewsHistoryQueue.removeFirst();
            this.parentViewsHistoryQueue.addFirst(entry);
        }
    }

    private final void purgeHistory() {
        long timeSinceLastSnapshot;
        ViewEntry cursor = this.parentViewsHistoryQueue.peekLast();
        while (cursor != null && (timeSinceLastSnapshot = System.currentTimeMillis() - cursor.getTimestamp()) > this.entriesTtlLimitInMs) {
            this.parentViewsHistoryQueue.remove(cursor);
            cursor = this.parentViewsHistoryQueue.peekLast();
        }
        while (this.parentViewsHistoryQueue.size() > 30) {
            this.parentViewsHistoryQueue.removeLast();
        }
    }

    public WebViewNativeRumViewsCache() {
        this(0L, 1, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/datadog/android/webview/internal/rum/domain/WebViewNativeRumViewsCache$Companion;", "", "()V", "DATA_CACHE_ENTRIES_LIMIT", "", "DATA_PURGE_TTL_LIMIT_IN_MS", "", "getDATA_PURGE_TTL_LIMIT_IN_MS$dd_sdk_android_webview_release", "()J", "VIEW_HAS_REPLAY_KEY", "", "VIEW_ID_KEY", "VIEW_TIMESTAMP_KEY", "dd-sdk-android-webview_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getDATA_PURGE_TTL_LIMIT_IN_MS$dd_sdk_android_webview_release() {
            return DATA_PURGE_TTL_LIMIT_IN_MS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/datadog/android/webview/internal/rum/domain/WebViewNativeRumViewsCache$ViewEntry;", "", "viewId", "", "timestamp", "", "hasReplay", "", "(Ljava/lang/String;JZ)V", "getHasReplay", "()Z", "getTimestamp", "()J", "getViewId", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "dd-sdk-android-webview_release"})
    public static final class ViewEntry {
        @NotNull
        private final String viewId;
        private final long timestamp;
        private final boolean hasReplay;

        public ViewEntry(@NotNull String viewId, long timestamp, boolean hasReplay) {
            Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
            this.viewId = viewId;
            this.timestamp = timestamp;
            this.hasReplay = hasReplay;
        }

        @NotNull
        public final String getViewId() {
            return this.viewId;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final boolean getHasReplay() {
            return this.hasReplay;
        }

        @NotNull
        public final String component1() {
            return this.viewId;
        }

        public final long component2() {
            return this.timestamp;
        }

        public final boolean component3() {
            return this.hasReplay;
        }

        @NotNull
        public final ViewEntry copy(@NotNull String viewId, long timestamp, boolean hasReplay) {
            Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
            return new ViewEntry(viewId, timestamp, hasReplay);
        }

        public static /* synthetic */ ViewEntry copy$default(ViewEntry viewEntry, String string, long l, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = viewEntry.viewId;
            }
            if ((n & 2) != 0) {
                l = viewEntry.timestamp;
            }
            if ((n & 4) != 0) {
                bl = viewEntry.hasReplay;
            }
            return viewEntry.copy(string, l, bl);
        }

        @NotNull
        public String toString() {
            return "ViewEntry(viewId=" + this.viewId + ", timestamp=" + this.timestamp + ", hasReplay=" + this.hasReplay + ")";
        }

        public int hashCode() {
            int result = this.viewId.hashCode();
            result = result * 31 + Long.hashCode(this.timestamp);
            int n = this.hasReplay ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ViewEntry)) {
                return false;
            }
            ViewEntry viewEntry = (ViewEntry)other;
            if (!Intrinsics.areEqual((Object)this.viewId, (Object)viewEntry.viewId)) {
                return false;
            }
            if (this.timestamp != viewEntry.timestamp) {
                return false;
            }
            return this.hasReplay == viewEntry.hasReplay;
        }
    }
}

