/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview.internal.rum;

import android.content.Context;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.feature.FeatureContextUpdateReceiver;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.api.feature.StorageBackedFeature;
import com.datadog.android.api.net.RequestFactory;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.api.storage.FeatureStorageConfiguration;
import com.datadog.android.api.storage.NoOpDataWriter;
import com.datadog.android.core.persistence.Serializer;
import com.datadog.android.webview.internal.rum.domain.NativeRumViewsCache;
import com.datadog.android.webview.internal.rum.domain.WebViewNativeRumViewsCache;
import com.datadog.android.webview.internal.storage.WebViewDataWriter;
import com.datadog.android.webview.internal.storage.WebViewEventSerializer;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\"\u001a\u00020#H\u0002J&\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00162\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010)0(H\u0016J\u0010\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020%H\u0016R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006/"}, d2={"Lcom/datadog/android/webview/internal/rum/WebViewRumFeature;", "Lcom/datadog/android/api/feature/StorageBackedFeature;", "Lcom/datadog/android/api/feature/FeatureContextUpdateReceiver;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "requestFactory", "Lcom/datadog/android/api/net/RequestFactory;", "nativeRumViewsCache", "Lcom/datadog/android/webview/internal/rum/domain/NativeRumViewsCache;", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lcom/datadog/android/api/net/RequestFactory;Lcom/datadog/android/webview/internal/rum/domain/NativeRumViewsCache;)V", "dataWriter", "Lcom/datadog/android/api/storage/DataWriter;", "Lcom/google/gson/JsonObject;", "getDataWriter$dd_sdk_android_webview_release", "()Lcom/datadog/android/api/storage/DataWriter;", "setDataWriter$dd_sdk_android_webview_release", "(Lcom/datadog/android/api/storage/DataWriter;)V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_webview_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "name", "", "getName", "()Ljava/lang/String;", "getNativeRumViewsCache$dd_sdk_android_webview_release", "()Lcom/datadog/android/webview/internal/rum/domain/NativeRumViewsCache;", "getRequestFactory", "()Lcom/datadog/android/api/net/RequestFactory;", "storageConfiguration", "Lcom/datadog/android/api/storage/FeatureStorageConfiguration;", "getStorageConfiguration", "()Lcom/datadog/android/api/storage/FeatureStorageConfiguration;", "createDataWriter", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "onContextUpdate", "", "featureName", "event", "", "", "onInitialize", "appContext", "Landroid/content/Context;", "onStop", "Companion", "dd-sdk-android-webview_release"})
public final class WebViewRumFeature
implements StorageBackedFeature,
FeatureContextUpdateReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final RequestFactory requestFactory;
    @NotNull
    private final NativeRumViewsCache nativeRumViewsCache;
    @NotNull
    private DataWriter<JsonObject> dataWriter;
    @NotNull
    private final AtomicBoolean initialized;
    @NotNull
    private final String name;
    @NotNull
    private final FeatureStorageConfiguration storageConfiguration;
    @NotNull
    public static final String WEB_RUM_FEATURE_NAME = "web-rum";

    public WebViewRumFeature(@NotNull FeatureSdkCore sdkCore, @NotNull RequestFactory requestFactory, @NotNull NativeRumViewsCache nativeRumViewsCache) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)requestFactory, (String)"requestFactory");
        Intrinsics.checkNotNullParameter((Object)nativeRumViewsCache, (String)"nativeRumViewsCache");
        this.sdkCore = sdkCore;
        this.requestFactory = requestFactory;
        this.nativeRumViewsCache = nativeRumViewsCache;
        this.dataWriter = (DataWriter)new NoOpDataWriter();
        this.initialized = new AtomicBoolean(false);
        this.name = WEB_RUM_FEATURE_NAME;
        this.storageConfiguration = FeatureStorageConfiguration.Companion.getDEFAULT();
    }

    public /* synthetic */ WebViewRumFeature(FeatureSdkCore featureSdkCore, RequestFactory requestFactory, NativeRumViewsCache nativeRumViewsCache, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            nativeRumViewsCache = new WebViewNativeRumViewsCache(0L, 1, null);
        }
        this(featureSdkCore, requestFactory, nativeRumViewsCache);
    }

    @NotNull
    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @NotNull
    public final NativeRumViewsCache getNativeRumViewsCache$dd_sdk_android_webview_release() {
        return this.nativeRumViewsCache;
    }

    @NotNull
    public final DataWriter<JsonObject> getDataWriter$dd_sdk_android_webview_release() {
        return this.dataWriter;
    }

    public final void setDataWriter$dd_sdk_android_webview_release(@NotNull DataWriter<JsonObject> dataWriter) {
        Intrinsics.checkNotNullParameter(dataWriter, (String)"<set-?>");
        this.dataWriter = dataWriter;
    }

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_webview_release() {
        return this.initialized;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void onInitialize(@NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.sdkCore.setContextUpdateReceiver(WEB_RUM_FEATURE_NAME, (FeatureContextUpdateReceiver)this);
        this.dataWriter = this.createDataWriter(this.sdkCore.getInternalLogger());
        this.initialized.set(true);
        Map currentRumContext = this.sdkCore.getFeatureContext("rum");
        this.nativeRumViewsCache.addToCache(currentRumContext);
    }

    public void onContextUpdate(@NotNull String featureName, @NotNull Map<String, ? extends Object> event) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (Intrinsics.areEqual((Object)featureName, (Object)"rum")) {
            this.nativeRumViewsCache.addToCache(event);
        }
    }

    @NotNull
    public FeatureStorageConfiguration getStorageConfiguration() {
        return this.storageConfiguration;
    }

    public void onStop() {
        this.sdkCore.removeContextUpdateReceiver(WEB_RUM_FEATURE_NAME, (FeatureContextUpdateReceiver)this);
        this.dataWriter = (DataWriter)new NoOpDataWriter();
        this.initialized.set(false);
    }

    private final DataWriter<JsonObject> createDataWriter(InternalLogger internalLogger) {
        return new WebViewDataWriter((Serializer<JsonObject>)((Serializer)new WebViewEventSerializer()), internalLogger);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/webview/internal/rum/WebViewRumFeature$Companion;", "", "()V", "WEB_RUM_FEATURE_NAME", "", "dd-sdk-android-webview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

