/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview.internal.rum;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.webview.internal.rum.TimestampOffsetProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/webview/internal/rum/TimestampOffsetProvider;", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/InternalLogger;)V", "offsets", "Ljava/util/LinkedHashMap;", "", "", "Lkotlin/collections/LinkedHashMap;", "getOffsets$dd_sdk_android_webview_release", "()Ljava/util/LinkedHashMap;", "getOffset", "viewId", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "getOffset$dd_sdk_android_webview_release", "purgeOffsets", "", "Companion", "dd-sdk-android-webview_release"})
public final class TimestampOffsetProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final LinkedHashMap<String, Long> offsets;
    public static final int MAX_VIEW_TIME_OFFSETS_RETAIN = 3;

    public TimestampOffsetProvider(@NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
        this.offsets = new LinkedHashMap();
    }

    @NotNull
    public final LinkedHashMap<String, Long> getOffsets$dd_sdk_android_webview_release() {
        return this.offsets;
    }

    public final synchronized long getOffset$dd_sdk_android_webview_release(@NotNull String viewId, @NotNull DatadogContext datadogContext) {
        Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Long offset = this.offsets.get(viewId);
        if (offset == null) {
            offset = datadogContext.getTime().getServerTimeOffsetMs();
            ((Map)this.offsets).put(viewId, offset);
        }
        this.purgeOffsets();
        return offset;
    }

    private final void purgeOffsets() {
        while (this.offsets.entrySet().size() > 3) {
            try {
                Set<Map.Entry<String, Long>> set = this.offsets.entrySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"offsets.entries");
                Object object = CollectionsKt.first((Iterable)set);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"offsets.entries.first()");
                Map.Entry viewId = (Map.Entry)object;
                this.offsets.remove(viewId.getKey());
            }
            catch (NoSuchElementException e) {
                Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)purgeOffsets.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
                break;
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/webview/internal/rum/TimestampOffsetProvider$Companion;", "", "()V", "MAX_VIEW_TIME_OFFSETS_RETAIN", "", "dd-sdk-android-webview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

