/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview.internal.replay;

import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.webview.internal.rum.TimestampOffsetProvider;
import com.datadog.android.webview.internal.rum.domain.RumContext;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/webview/internal/replay/WebViewReplayEventMapper;", "", "webViewId", "", "offsetProvider", "Lcom/datadog/android/webview/internal/rum/TimestampOffsetProvider;", "(Ljava/lang/String;Lcom/datadog/android/webview/internal/rum/TimestampOffsetProvider;)V", "getOffsetProvider$dd_sdk_android_webview_release", "()Lcom/datadog/android/webview/internal/rum/TimestampOffsetProvider;", "bundleIntoEnrichedRecord", "Lcom/google/gson/JsonObject;", "record", "browserViewId", "rumContext", "Lcom/datadog/android/webview/internal/rum/domain/RumContext;", "mapEvent", "event", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "Companion", "dd-sdk-android-webview_release"})
@SourceDebugExtension(value={"SMAP\nWebViewReplayEventMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewReplayEventMapper.kt\ncom/datadog/android/webview/internal/replay/WebViewReplayEventMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class WebViewReplayEventMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String webViewId;
    @NotNull
    private final TimestampOffsetProvider offsetProvider;
    @NotNull
    public static final String EVENT_KEY = "event";
    @NotNull
    public static final String VIEW_OBJECT_KEY = "view";
    @NotNull
    public static final String VIEW_ID_KEY = "id";
    @NotNull
    public static final String TIMESTAMP_KEY = "timestamp";
    @NotNull
    public static final String ENRICHED_RECORD_APPLICATION_ID_KEY = "application_id";
    @NotNull
    public static final String ENRICHED_RECORD_SESSION_ID_KEY = "session_id";
    @NotNull
    public static final String ENRICHED_RECORD_VIEW_ID_KEY = "view_id";
    @NotNull
    public static final String RECORDS_KEY = "records";
    @NotNull
    public static final String SLOT_ID_KEY = "slotId";
    @NotNull
    public static final String BROWSER_EVENT_MISSING_VIEW_DATA_ERROR_MESSAGE = "The bundled web Replay event does not contain the mandatory view data";
    @NotNull
    public static final String BROWSER_EVENT_MISSING_RECORD_ERROR_MESSAGE = "The bundled web Replay event does not contain the record data";

    public WebViewReplayEventMapper(@NotNull String webViewId, @NotNull TimestampOffsetProvider offsetProvider) {
        Intrinsics.checkNotNullParameter((Object)webViewId, (String)"webViewId");
        Intrinsics.checkNotNullParameter((Object)offsetProvider, (String)"offsetProvider");
        this.webViewId = webViewId;
        this.offsetProvider = offsetProvider;
    }

    @NotNull
    public final TimestampOffsetProvider getOffsetProvider$dd_sdk_android_webview_release() {
        return this.offsetProvider;
    }

    @NotNull
    public final JsonObject mapEvent(@NotNull JsonObject event, @NotNull RumContext rumContext, @NotNull DatadogContext datadogContext) throws ClassCastException, IllegalStateException, NumberFormatException {
        String string;
        Intrinsics.checkNotNullParameter((Object)event, (String)EVENT_KEY);
        Intrinsics.checkNotNullParameter((Object)rumContext, (String)"rumContext");
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        JsonElement jsonElement = event.get(VIEW_OBJECT_KEY);
        Object viewDataObject = jsonElement != null ? jsonElement.getAsJsonObject() : null;
        JsonObject jsonObject = viewDataObject;
        String string2 = jsonObject != null && (jsonObject = jsonObject.get(VIEW_ID_KEY)) != null ? jsonObject.getAsString() : (string = null);
        if (string == null) {
            throw new IllegalStateException(BROWSER_EVENT_MISSING_VIEW_DATA_ERROR_MESSAGE);
        }
        String viewId = string;
        JsonElement jsonElement2 = event.get(EVENT_KEY);
        if (jsonElement2 != null && (jsonElement2 = jsonElement2.getAsJsonObject()) != null) {
            JsonElement jsonElement3;
            JsonElement record = jsonElement2;
            boolean bl = false;
            long timeOffset = this.offsetProvider.getOffset$dd_sdk_android_webview_release(viewId, datadogContext);
            JsonElement jsonElement4 = jsonElement3 = record.get(TIMESTAMP_KEY);
            if (jsonElement4 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement4, (String)"get(TIMESTAMP_KEY)");
                JsonElement timestamp = jsonElement3;
                boolean bl2 = false;
                long asLong = timestamp.getAsLong();
                long correctedTimestamp = asLong + timeOffset;
                record.addProperty(TIMESTAMP_KEY, (Number)correctedTimestamp);
            }
            record.addProperty(SLOT_ID_KEY, this.webViewId);
            return this.bundleIntoEnrichedRecord((JsonObject)record, viewId, rumContext);
        }
        throw new IllegalStateException(BROWSER_EVENT_MISSING_RECORD_ERROR_MESSAGE);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject bundleIntoEnrichedRecord(JsonObject record, String browserViewId, RumContext rumContext) {
        void $this$bundleIntoEnrichedRecord_u24lambda_u243_u24lambda_u242;
        JsonArray jsonArray;
        JsonObject jsonObject;
        JsonObject $this$bundleIntoEnrichedRecord_u24lambda_u243 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$bundleIntoEnrichedRecord_u24lambda_u243.addProperty(ENRICHED_RECORD_APPLICATION_ID_KEY, rumContext.getApplicationId());
        $this$bundleIntoEnrichedRecord_u24lambda_u243.addProperty(ENRICHED_RECORD_SESSION_ID_KEY, rumContext.getSessionId());
        $this$bundleIntoEnrichedRecord_u24lambda_u243.addProperty(ENRICHED_RECORD_VIEW_ID_KEY, browserViewId);
        JsonArray jsonArray2 = jsonArray = new JsonArray();
        String string = RECORDS_KEY;
        JsonObject jsonObject2 = $this$bundleIntoEnrichedRecord_u24lambda_u243;
        boolean bl2 = false;
        $this$bundleIntoEnrichedRecord_u24lambda_u243_u24lambda_u242.add((JsonElement)record);
        Unit unit = Unit.INSTANCE;
        jsonObject2.add(string, (JsonElement)jsonArray);
        return jsonObject;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/webview/internal/replay/WebViewReplayEventMapper$Companion;", "", "()V", "BROWSER_EVENT_MISSING_RECORD_ERROR_MESSAGE", "", "BROWSER_EVENT_MISSING_VIEW_DATA_ERROR_MESSAGE", "ENRICHED_RECORD_APPLICATION_ID_KEY", "ENRICHED_RECORD_SESSION_ID_KEY", "ENRICHED_RECORD_VIEW_ID_KEY", "EVENT_KEY", "RECORDS_KEY", "SLOT_ID_KEY", "TIMESTAMP_KEY", "VIEW_ID_KEY", "VIEW_OBJECT_KEY", "dd-sdk-android-webview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

