/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview.internal.replay;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.api.storage.EventBatchWriter;
import com.datadog.android.api.storage.EventType;
import com.datadog.android.webview.internal.WebViewEventConsumer;
import com.datadog.android.webview.internal.replay.WebViewReplayEventConsumer;
import com.datadog.android.webview.internal.replay.WebViewReplayEventMapper;
import com.datadog.android.webview.internal.rum.WebViewRumEventContextProvider;
import com.datadog.android.webview.internal.rum.domain.RumContext;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/webview/internal/replay/WebViewReplayEventConsumer;", "Lcom/datadog/android/webview/internal/WebViewEventConsumer;", "Lcom/google/gson/JsonObject;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "dataWriter", "Lcom/datadog/android/api/storage/DataWriter;", "contextProvider", "Lcom/datadog/android/webview/internal/rum/WebViewRumEventContextProvider;", "webViewReplayEventMapper", "Lcom/datadog/android/webview/internal/replay/WebViewReplayEventMapper;", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lcom/datadog/android/api/storage/DataWriter;Lcom/datadog/android/webview/internal/rum/WebViewRumEventContextProvider;Lcom/datadog/android/webview/internal/replay/WebViewReplayEventMapper;)V", "getDataWriter$dd_sdk_android_webview_release", "()Lcom/datadog/android/api/storage/DataWriter;", "getWebViewReplayEventMapper$dd_sdk_android_webview_release", "()Lcom/datadog/android/webview/internal/replay/WebViewReplayEventMapper;", "consume", "", "event", "map", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "rumContext", "Lcom/datadog/android/webview/internal/rum/domain/RumContext;", "Companion", "dd-sdk-android-webview_release"})
public final class WebViewReplayEventConsumer
implements WebViewEventConsumer<JsonObject> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final DataWriter<JsonObject> dataWriter;
    @NotNull
    private final WebViewRumEventContextProvider contextProvider;
    @NotNull
    private final WebViewReplayEventMapper webViewReplayEventMapper;
    @NotNull
    private static final String RECORD_KEY = "record";
    @NotNull
    public static final String SESSION_TRACKED_STATE = "TRACKED";
    @NotNull
    private static final Set<String> REPLAY_EVENT_TYPES = SetsKt.setOf((Object)"record");
    @NotNull
    public static final String JSON_PARSING_ERROR_MESSAGE = "The bundled web Replay event could not be deserialized";
    @NotNull
    public static final String SESSION_REPLAY_ENABLED_KEY = "session_replay_is_enabled";

    public WebViewReplayEventConsumer(@NotNull FeatureSdkCore sdkCore, @NotNull DataWriter<JsonObject> dataWriter, @NotNull WebViewRumEventContextProvider contextProvider, @NotNull WebViewReplayEventMapper webViewReplayEventMapper) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(dataWriter, (String)"dataWriter");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        Intrinsics.checkNotNullParameter((Object)webViewReplayEventMapper, (String)"webViewReplayEventMapper");
        this.sdkCore = sdkCore;
        this.dataWriter = dataWriter;
        this.contextProvider = contextProvider;
        this.webViewReplayEventMapper = webViewReplayEventMapper;
    }

    @NotNull
    public final DataWriter<JsonObject> getDataWriter$dd_sdk_android_webview_release() {
        return this.dataWriter;
    }

    @NotNull
    public final WebViewReplayEventMapper getWebViewReplayEventMapper$dd_sdk_android_webview_release() {
        return this.webViewReplayEventMapper;
    }

    @Override
    public void consume(@NotNull JsonObject event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FeatureScope featureScope = this.sdkCore.getFeature("web-replay");
        if (featureScope != null) {
            FeatureScope.DefaultImpls.withWriteContext$default((FeatureScope)featureScope, (boolean)false, (Function2)((Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, event){
                final /* synthetic */ WebViewReplayEventConsumer this$0;
                final /* synthetic */ JsonObject $event;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    block1: {
                        boolean sessionReplayEnabled;
                        Map sessionReplayFeatureContext;
                        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                        Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                        RumContext rumContext = WebViewReplayEventConsumer.access$getContextProvider$p(this.this$0).getRumContext(datadogContext);
                        Map map2 = sessionReplayFeatureContext = (Map)datadogContext.getFeaturesContext().get("session-replay");
                        Object object = map2 != null ? map2.get("session_replay_is_enabled") : null;
                        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
                        boolean bl2 = sessionReplayEnabled = bl != null ? bl : false;
                        if (rumContext == null || !Intrinsics.areEqual((Object)rumContext.getSessionState(), (Object)"TRACKED") || !sessionReplayEnabled) break block1;
                        JsonObject jsonObject = WebViewReplayEventConsumer.access$map(this.this$0, this.$event, datadogContext, rumContext);
                        if (jsonObject != null) {
                            object = jsonObject;
                            WebViewReplayEventConsumer webViewReplayEventConsumer = this.this$0;
                            Object mappedEvent = object;
                            boolean bl3 = false;
                            webViewReplayEventConsumer.getDataWriter$dd_sdk_android_webview_release().write(eventBatchWriter, mappedEvent, EventType.DEFAULT);
                        }
                    }
                }
            }), (int)1, null);
        }
    }

    private final JsonObject map(JsonObject event, DatadogContext datadogContext, RumContext rumContext) {
        try {
            return this.webViewReplayEventMapper.mapEvent(event, rumContext, datadogContext);
        }
        catch (ClassCastException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)map.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        catch (NumberFormatException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)map.2.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        catch (IllegalStateException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)map.3.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        catch (UnsupportedOperationException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)map.4.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        return null;
    }

    public static final /* synthetic */ WebViewRumEventContextProvider access$getContextProvider$p(WebViewReplayEventConsumer $this) {
        return $this.contextProvider;
    }

    public static final /* synthetic */ JsonObject access$map(WebViewReplayEventConsumer $this, JsonObject event, DatadogContext datadogContext, RumContext rumContext) {
        return $this.map(event, datadogContext, rumContext);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/webview/internal/replay/WebViewReplayEventConsumer$Companion;", "", "()V", "JSON_PARSING_ERROR_MESSAGE", "", "RECORD_KEY", "REPLAY_EVENT_TYPES", "", "getREPLAY_EVENT_TYPES", "()Ljava/util/Set;", "SESSION_REPLAY_ENABLED_KEY", "SESSION_TRACKED_STATE", "dd-sdk-android-webview_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getREPLAY_EVENT_TYPES() {
            return REPLAY_EVENT_TYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

