/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview.internal.log;

import android.content.Context;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.api.feature.StorageBackedFeature;
import com.datadog.android.api.net.RequestFactory;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.api.storage.FeatureStorageConfiguration;
import com.datadog.android.api.storage.NoOpDataWriter;
import com.datadog.android.core.persistence.Serializer;
import com.datadog.android.webview.internal.storage.WebViewDataWriter;
import com.datadog.android.webview.internal.storage.WebViewEventSerializer;
import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020 H\u0016R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006%"}, d2={"Lcom/datadog/android/webview/internal/log/WebViewLogsFeature;", "Lcom/datadog/android/api/feature/StorageBackedFeature;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "requestFactory", "Lcom/datadog/android/api/net/RequestFactory;", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lcom/datadog/android/api/net/RequestFactory;)V", "dataWriter", "Lcom/datadog/android/api/storage/DataWriter;", "Lcom/google/gson/JsonObject;", "getDataWriter$dd_sdk_android_webview_release", "()Lcom/datadog/android/api/storage/DataWriter;", "setDataWriter$dd_sdk_android_webview_release", "(Lcom/datadog/android/api/storage/DataWriter;)V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_webview_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "name", "", "getName", "()Ljava/lang/String;", "getRequestFactory", "()Lcom/datadog/android/api/net/RequestFactory;", "storageConfiguration", "Lcom/datadog/android/api/storage/FeatureStorageConfiguration;", "getStorageConfiguration", "()Lcom/datadog/android/api/storage/FeatureStorageConfiguration;", "createDataWriter", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "onInitialize", "", "appContext", "Landroid/content/Context;", "onStop", "Companion", "dd-sdk-android-webview_release"})
public final class WebViewLogsFeature
implements StorageBackedFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final RequestFactory requestFactory;
    @NotNull
    private DataWriter<JsonObject> dataWriter;
    @NotNull
    private final AtomicBoolean initialized;
    @NotNull
    private final String name;
    @NotNull
    private final FeatureStorageConfiguration storageConfiguration;
    @NotNull
    public static final String WEB_LOGS_FEATURE_NAME = "web-logs";

    public WebViewLogsFeature(@NotNull FeatureSdkCore sdkCore, @NotNull RequestFactory requestFactory) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)requestFactory, (String)"requestFactory");
        this.sdkCore = sdkCore;
        this.requestFactory = requestFactory;
        this.dataWriter = (DataWriter)new NoOpDataWriter();
        this.initialized = new AtomicBoolean(false);
        this.name = WEB_LOGS_FEATURE_NAME;
        this.storageConfiguration = FeatureStorageConfiguration.Companion.getDEFAULT();
    }

    @NotNull
    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @NotNull
    public final DataWriter<JsonObject> getDataWriter$dd_sdk_android_webview_release() {
        return this.dataWriter;
    }

    public final void setDataWriter$dd_sdk_android_webview_release(@NotNull DataWriter<JsonObject> dataWriter) {
        Intrinsics.checkNotNullParameter(dataWriter, (String)"<set-?>");
        this.dataWriter = dataWriter;
    }

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_webview_release() {
        return this.initialized;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void onInitialize(@NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.dataWriter = this.createDataWriter(this.sdkCore.getInternalLogger());
        this.initialized.set(true);
    }

    @NotNull
    public FeatureStorageConfiguration getStorageConfiguration() {
        return this.storageConfiguration;
    }

    public void onStop() {
        this.dataWriter = (DataWriter)new NoOpDataWriter();
        this.initialized.set(false);
    }

    private final DataWriter<JsonObject> createDataWriter(InternalLogger internalLogger) {
        return new WebViewDataWriter((Serializer<JsonObject>)((Serializer)new WebViewEventSerializer()), internalLogger);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/webview/internal/log/WebViewLogsFeature$Companion;", "", "()V", "WEB_LOGS_FEATURE_NAME", "", "dd-sdk-android-webview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

