/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.util;

import java.util.Locale;

public final class TagsHelper {
    private static final int MAX_LENGTH = 200;

    public static String sanitize(String tag) {
        if (tag == null) {
            return null;
        }
        String lower = tag.toLowerCase(Locale.ROOT).trim();
        int length = Math.min(lower.length(), 200);
        StringBuilder sanitized = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = lower.charAt(i);
            if (TagsHelper.isValid(c)) {
                sanitized.append(c);
                continue;
            }
            sanitized.append('_');
        }
        return sanitized.toString();
    }

    static boolean isValid(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '/' || c == ':';
    }

    public static String concatTags(String ... tags) {
        if (tags == null || tags.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String tag : tags) {
            sb.append(tag);
            sb.append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }
}

