/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.relocate.api;

import com.datadog.trace.api.time.SystemTimeSource;
import com.datadog.trace.api.time.TimeSource;
import com.datadog.trace.logger.Logger;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class RatelimitedLogger {
    private final Logger log;
    private final long delayNanos;
    private final String noLogMessage;
    private final TimeSource timeSource;
    private final AtomicLong nextLogNanos;

    public RatelimitedLogger(Logger log, int delay, TimeUnit timeUnit) {
        this(log, delay, timeUnit, SystemTimeSource.INSTANCE);
    }

    RatelimitedLogger(Logger log, int delay, TimeUnit timeUnit, TimeSource timeSource) {
        this.log = log;
        this.delayNanos = timeUnit.toNanos(delay);
        this.noLogMessage = RatelimitedLogger.createNoLogMessage(" (Will not log warnings for ", ")", delay, timeUnit);
        this.timeSource = timeSource;
        this.nextLogNanos = new AtomicLong(timeSource.getNanoTicks());
    }

    public boolean warn(String format, Object ... arguments) {
        if (this.log.isDebugEnabled()) {
            this.log.warn(format, arguments);
            return true;
        }
        if (this.log.isWarnEnabled()) {
            long next = this.nextLogNanos.get();
            long now = this.timeSource.getNanoTicks();
            if (now - next >= 0L && this.nextLogNanos.compareAndSet(next, now + this.delayNanos)) {
                this.log.warn(format + this.noLogMessage, arguments);
                return true;
            }
        }
        return false;
    }

    private static String createNoLogMessage(String prefix, String postfix, int delay, TimeUnit timeUnit) {
        StringBuilder noLogStringBuilder = new StringBuilder(prefix);
        noLogStringBuilder.append(delay);
        noLogStringBuilder.append(' ');
        String unit = timeUnit.name().toLowerCase(Locale.ROOT);
        unit = delay == 1 ? unit.substring(0, unit.length() - 1) : unit;
        noLogStringBuilder.append(unit);
        noLogStringBuilder.append(postfix);
        return noLogStringBuilder.toString();
    }
}

