/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core.util;

import com.datadog.trace.core.CoreSpan;
import com.datadog.trace.core.util.GlobPattern;
import com.datadog.trace.core.util.Matcher;
import com.datadog.trace.core.util.Matchers;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class TagsMatcher {
    private final Map<String, Matcher> matchers;

    public static TagsMatcher create(Map<String, String> tags) {
        Set<Map.Entry<String, String>> entries = tags.entrySet();
        HashMap<String, Matcher> matchers = new HashMap<String, Matcher>();
        for (Map.Entry<String, String> entry : entries) {
            String tagKey = entry.getKey();
            String tagValue = entry.getValue();
            if (Matchers.isExact(tagValue)) {
                matchers.put(tagKey, new Matchers.ExactMatcher(tagValue));
                continue;
            }
            Pattern pattern = GlobPattern.globToRegexPattern(tagValue);
            matchers.put(tagKey, new Matchers.PatternMatcher(pattern));
        }
        return new TagsMatcher(matchers);
    }

    public TagsMatcher(Map<String, Matcher> matchers) {
        this.matchers = matchers;
    }

    public <T extends CoreSpan<T>> boolean matches(T span) {
        HashSet<Map.Entry<String, Matcher>> copyEntrySet = new HashSet<Map.Entry<String, Matcher>>(this.matchers.entrySet());
        for (Map.Entry entry : copyEntrySet) {
            String tagValue = (String)span.getTag((CharSequence)entry.getKey());
            if (tagValue != null && ((Matcher)entry.getValue()).matches(tagValue)) continue;
            return false;
        }
        return true;
    }
}

