/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core.util;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class JsonObjectUtils {
    @Nullable
    public static String getAsString(JsonObject jsonObject, String key) {
        JsonElement jsonValue = jsonObject.get(key);
        if (jsonValue != null && jsonValue.isJsonPrimitive()) {
            return jsonValue.getAsJsonPrimitive().getAsString();
        }
        return null;
    }

    @Nullable
    public static Map<String, String> safeGetAsMap(JsonObject jsonObject, String key) {
        JsonElement jsonValue = jsonObject.get(key);
        if (jsonValue != null && jsonValue.isJsonObject()) {
            return JsonObjectUtils.safeGetAsMap(jsonValue.getAsJsonObject());
        }
        return null;
    }

    @NonNull
    private static Map<String, String> safeGetAsMap(JsonObject jsonObject) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            JsonElement value = (JsonElement)entry.getValue();
            if (!value.isJsonPrimitive()) continue;
            map2.put((String)entry.getKey(), value.getAsJsonPrimitive().getAsString());
        }
        return map2;
    }
}

