/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core.tagprocessor;

import androidx.annotation.NonNull;
import com.datadog.trace.api.Config;
import com.datadog.trace.api.naming.NamingSchema;
import com.datadog.trace.api.naming.SpanNaming;
import com.datadog.trace.core.tagprocessor.TagsPostProcessor;
import java.util.Map;

public class PeerServiceCalculator
implements TagsPostProcessor {
    private final NamingSchema.ForPeerService peerServiceNaming;
    private final Map<String, String> peerServiceMapping;
    private final boolean canRemap;

    public PeerServiceCalculator() {
        this(SpanNaming.instance().namingSchema().peerService(), Config.get().getPeerServiceMapping());
    }

    PeerServiceCalculator(@NonNull NamingSchema.ForPeerService peerServiceNaming, @NonNull Map<String, String> peerServiceMapping) {
        this.peerServiceNaming = peerServiceNaming;
        this.peerServiceMapping = peerServiceMapping;
        this.canRemap = !peerServiceMapping.isEmpty();
    }

    @Override
    public Map<String, Object> processTags(Map<String, Object> unsafeTags) {
        Object peerService = unsafeTags.get("peer.service");
        if (peerService != null) {
            if (this.canRemap) {
                return this.remapPeerService(unsafeTags, peerService);
            }
        } else if (this.peerServiceNaming.supports()) {
            this.peerServiceNaming.tags(unsafeTags);
            return this.remapPeerService(unsafeTags, this.canRemap ? unsafeTags.get("peer.service") : null);
        }
        return unsafeTags;
    }

    private Map<String, Object> remapPeerService(Map<String, Object> unsafeTags, Object value) {
        String mapped;
        if (value != null && (mapped = this.peerServiceMapping.get(value)) != null) {
            unsafeTags.put("peer.service", mapped);
            unsafeTags.put("_dd.peer.service.remapped_from", value);
        }
        return unsafeTags;
    }
}

