/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core.scopemanager;

import androidx.annotation.NonNull;
import com.datadog.trace.api.Stateful;
import com.datadog.trace.api.scopemanager.ExtendedScopeListener;
import com.datadog.trace.api.scopemanager.ScopeListener;
import com.datadog.trace.bootstrap.instrumentation.api.AgentScope;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import com.datadog.trace.bootstrap.instrumentation.api.AttachableWrapper;
import com.datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import com.datadog.trace.core.scopemanager.AbstractContinuation;
import com.datadog.trace.core.scopemanager.ConcurrentContinuation;
import com.datadog.trace.core.scopemanager.ContinuableScopeManager;
import com.datadog.trace.core.scopemanager.ScopeStack;
import com.datadog.trace.core.scopemanager.SingleContinuation;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.relocate.api.RatelimitedLogger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

class ContinuableScope
implements AgentScope,
AttachableWrapper {
    private final ContinuableScopeManager scopeManager;
    final AgentSpan span;
    private boolean isAsyncPropagating;
    private final byte flags;
    private short referenceCount = 1;
    private volatile Object wrapper;
    private static final AtomicReferenceFieldUpdater<ContinuableScope, Object> WRAPPER_FIELD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ContinuableScope.class, Object.class, "wrapper");
    private final Stateful scopeState;
    private final Logger log;
    private final RatelimitedLogger ratelimitedLogger;

    ContinuableScope(ContinuableScopeManager scopeManager, AgentSpan span, byte source, boolean isAsyncPropagating, Stateful scopeState, Logger logger, RatelimitedLogger ratelimitedLogger) {
        this.scopeManager = scopeManager;
        this.span = span;
        this.flags = source;
        this.isAsyncPropagating = isAsyncPropagating;
        this.scopeState = scopeState;
        this.log = logger;
        this.ratelimitedLogger = ratelimitedLogger;
    }

    @Override
    public final void close() {
        ScopeStack scopeStack = this.scopeManager.scopeStack();
        if (!scopeStack.checkTop(this) && !scopeStack.checkOverdueScopes(this)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Tried to close {} scope when not on top.  Current top: {}", (Object)this, (Object)scopeStack.top);
            }
            byte source = this.source();
            this.scopeManager.healthMetrics.onScopeCloseError(source);
            if (source == ScopeSource.MANUAL.id() && this.scopeManager.strictMode) {
                throw new RuntimeException("Tried to close scope when not on top");
            }
        }
        boolean alive = this.decrementReferences();
        this.scopeManager.healthMetrics.onCloseScope();
        if (!alive) {
            this.cleanup(scopeStack);
        }
        this.scopeState.close();
    }

    void cleanup(ScopeStack scopeStack) {
        scopeStack.cleanup();
    }

    final void onProperClose() {
        for (ScopeListener scopeListener : this.scopeManager.scopeListeners) {
            try {
                scopeListener.afterScopeClosed();
            }
            catch (Exception e) {
                this.log.debug("ScopeListener threw exception in close()", e);
            }
        }
        for (ExtendedScopeListener extendedScopeListener : this.scopeManager.extendedScopeListeners) {
            try {
                extendedScopeListener.afterScopeClosed();
            }
            catch (Exception e) {
                this.log.debug("ScopeListener threw exception in close()", e);
            }
        }
    }

    final void incrementReferences() {
        this.referenceCount = (short)(this.referenceCount + 1);
    }

    final boolean decrementReferences() {
        this.referenceCount = (short)(this.referenceCount - 1);
        return this.referenceCount > 0;
    }

    final void clearReferences() {
        this.referenceCount = 0;
    }

    final boolean alive() {
        return this.referenceCount > 0;
    }

    @Override
    public final boolean isAsyncPropagating() {
        return this.isAsyncPropagating;
    }

    @Override
    public final AgentSpan span() {
        return this.span;
    }

    @Override
    public final void setAsyncPropagation(boolean value) {
        this.isAsyncPropagating = value;
    }

    @Override
    public final AbstractContinuation capture() {
        return this.isAsyncPropagating ? new SingleContinuation(this.scopeManager, this.span, this.source(), this.log).register() : null;
    }

    @Override
    public final AbstractContinuation captureConcurrent() {
        return this.isAsyncPropagating ? new ConcurrentContinuation(this.scopeManager, this.span, this.source(), this.log).register() : null;
    }

    public final String toString() {
        return super.toString() + "->" + this.span;
    }

    public final void beforeActivated() {
        try {
            this.scopeState.activate(this.span.context());
        }
        catch (Throwable e) {
            this.ratelimitedLogger.warn("ScopeState {} threw exception in beforeActivated()", this.scopeState.getClass(), e);
        }
    }

    public final void afterActivated() {
        for (ScopeListener scopeListener : this.scopeManager.scopeListeners) {
            try {
                scopeListener.afterScopeActivated();
            }
            catch (Throwable e) {
                this.log.debug("ScopeListener threw exception in afterActivated()", e);
            }
        }
        for (ExtendedScopeListener extendedScopeListener : this.scopeManager.extendedScopeListeners) {
            try {
                extendedScopeListener.afterScopeActivated(this.span.getTraceId(), this.span.getLocalRootSpan().getSpanId(), this.span.context().getSpanId(), this.span.traceConfig());
            }
            catch (Throwable e) {
                this.log.debug("ExtendedScopeListener threw exception in afterActivated()", e);
            }
        }
    }

    @Override
    public byte source() {
        return (byte)(this.flags & 0x7F);
    }

    @Override
    public void attachWrapper(@NonNull Object wrapper) {
        WRAPPER_FIELD_UPDATER.set(this, wrapper);
    }

    @Override
    public Object getWrapper() {
        return WRAPPER_FIELD_UPDATER.get(this);
    }
}

