/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core.propagation.ptags;

import androidx.annotation.NonNull;
import com.datadog.trace.api.internal.util.LongStringUtils;
import com.datadog.trace.core.propagation.PropagationTags;
import com.datadog.trace.core.propagation.ptags.DatadogPTagsCodec;
import com.datadog.trace.core.propagation.ptags.PTagsCodec;
import com.datadog.trace.core.propagation.ptags.TagElement;
import com.datadog.trace.core.propagation.ptags.TagValue;
import com.datadog.trace.core.propagation.ptags.W3CPTagsCodec;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PTagsFactory
implements PropagationTags.Factory {
    static final String PROPAGATION_ERROR_TAG_KEY = "_dd.propagation_error";
    private final EnumMap<PropagationTags.HeaderType, PTagsCodec> DEC_ENC_MAP = new EnumMap(PropagationTags.HeaderType.class);
    private final int xDatadogTagsLimit;

    public PTagsFactory(int xDatadogTagsLimit) {
        this.xDatadogTagsLimit = xDatadogTagsLimit;
        this.DEC_ENC_MAP.put(PropagationTags.HeaderType.DATADOG, new DatadogPTagsCodec(xDatadogTagsLimit));
        this.DEC_ENC_MAP.put(PropagationTags.HeaderType.W3C, new W3CPTagsCodec());
    }

    boolean isPropagationTagsDisabled() {
        return this.xDatadogTagsLimit <= 0;
    }

    int getxDatadogTagsLimit() {
        return this.xDatadogTagsLimit;
    }

    PTagsCodec getDecoderEncoder(@NonNull PropagationTags.HeaderType headerType) {
        return this.DEC_ENC_MAP.get((Object)headerType);
    }

    @Override
    public final PropagationTags empty() {
        return this.createValid(null, null, null);
    }

    @Override
    public final PropagationTags fromHeaderValue(@NonNull PropagationTags.HeaderType headerType, String value) {
        return this.DEC_ENC_MAP.get((Object)headerType).fromHeaderValue(this, value);
    }

    PropagationTags createValid(List<TagElement> tagPairs, TagValue decisionMakerTagValue, TagValue traceIdTagValue) {
        return new PTags(this, tagPairs, decisionMakerTagValue, traceIdTagValue);
    }

    PropagationTags createInvalid(String error) {
        return PTags.withError(this, error);
    }

    static class PTags
    extends PropagationTags {
        private static final String EMPTY = "";
        protected final PTagsFactory factory;
        private final List<TagElement> tagPairs;
        private final boolean canChangeDecisionMaker;
        private volatile TagValue decisionMakerTagValue;
        private volatile int xDatadogTagsSize = -1;
        private volatile int samplingPriority;
        private volatile CharSequence origin;
        private volatile String[] headerCache = null;
        private volatile long traceIdHighOrderBits;
        private volatile TagValue traceIdHighOrderBitsHexTagValue;
        protected volatile String tracestate;
        protected volatile String error;

        public PTags(PTagsFactory factory, List<TagElement> tagPairs, TagValue decisionMakerTagValue, TagValue traceIdTagValue) {
            this(factory, tagPairs, decisionMakerTagValue, traceIdTagValue, -128, null);
        }

        PTags(PTagsFactory factory, List<TagElement> tagPairs, TagValue decisionMakerTagValue, TagValue traceIdTagValue, int samplingPriority, CharSequence origin) {
            assert (tagPairs == null || tagPairs.size() % 2 == 0);
            this.factory = factory;
            this.tagPairs = tagPairs;
            this.canChangeDecisionMaker = decisionMakerTagValue == null;
            this.decisionMakerTagValue = decisionMakerTagValue;
            this.samplingPriority = samplingPriority;
            this.origin = origin;
            if (traceIdTagValue != null) {
                CharSequence traceIdHighOrderBitsHex = traceIdTagValue.forType(TagElement.Encoding.DATADOG);
                this.traceIdHighOrderBits = LongStringUtils.parseUnsignedLongHex(traceIdHighOrderBitsHex, 0, traceIdHighOrderBitsHex.length(), true);
            }
            this.traceIdHighOrderBitsHexTagValue = traceIdTagValue;
            this.error = null;
        }

        static PTags withError(PTagsFactory factory, String error) {
            PTags pTags = new PTags(factory, null, null, null, -128, null);
            pTags.error = error;
            return pTags;
        }

        @Override
        public void updateTraceSamplingPriority(int samplingPriority, int samplingMechanism) {
            if (samplingPriority != -128 && this.canChangeDecisionMaker || samplingMechanism == -128) {
                if (this.samplingPriority != samplingPriority) {
                    this.clearCachedHeader(PropagationTags.HeaderType.W3C);
                }
                this.samplingPriority = samplingPriority;
                if (samplingPriority > 0) {
                    if (samplingMechanism == -128) {
                        samplingMechanism = 0;
                    }
                    if (samplingMechanism >= 0) {
                        TagValue newDM = TagValue.from("-" + samplingMechanism);
                        if (!newDM.equals(this.decisionMakerTagValue)) {
                            this.clearCachedHeader(PropagationTags.HeaderType.DATADOG);
                            this.clearCachedHeader(PropagationTags.HeaderType.W3C);
                        }
                        this.decisionMakerTagValue = newDM;
                    }
                } else {
                    if (this.decisionMakerTagValue != null) {
                        this.clearCachedHeader(PropagationTags.HeaderType.DATADOG);
                        this.clearCachedHeader(PropagationTags.HeaderType.W3C);
                    }
                    this.decisionMakerTagValue = null;
                }
            }
        }

        @Override
        public int getSamplingPriority() {
            return this.samplingPriority;
        }

        @Override
        public void updateTraceOrigin(CharSequence origin) {
            CharSequence existing = this.origin;
            if (Objects.equals(existing, origin)) {
                return;
            }
            this.clearCachedHeader(PropagationTags.HeaderType.W3C);
            this.origin = TagValue.from(origin);
        }

        @Override
        public CharSequence getOrigin() {
            return this.origin;
        }

        @Override
        public long getTraceIdHighOrderBits() {
            return this.traceIdHighOrderBits;
        }

        @Override
        public void updateTraceIdHighOrderBits(long highOrderBits) {
            if (this.traceIdHighOrderBits != highOrderBits) {
                this.traceIdHighOrderBits = highOrderBits;
                this.traceIdHighOrderBitsHexTagValue = highOrderBits == 0L ? null : TagValue.from(LongStringUtils.toHexStringPadded(highOrderBits, 16));
                this.clearCachedHeader(PropagationTags.HeaderType.DATADOG);
            }
        }

        @Override
        public String headerValue(PropagationTags.HeaderType headerType) {
            String header = this.getCachedHeader(headerType);
            if (header == null) {
                header = PTagsCodec.headerValue(this.factory.getDecoderEncoder(headerType), this);
                if (header != null) {
                    this.setCachedHeader(headerType, header);
                } else {
                    this.setCachedHeader(headerType, EMPTY);
                }
            }
            if (header == EMPTY) {
                return null;
            }
            return header;
        }

        @Override
        public void fillTagMap(Map<String, String> tagMap) {
            PTagsCodec.fillTagMap(this, tagMap);
        }

        private String getCachedHeader(PropagationTags.HeaderType headerType) {
            String[] cache = this.headerCache;
            if (cache == null) {
                return null;
            }
            return cache[headerType.ordinal()];
        }

        private void setCachedHeader(PropagationTags.HeaderType headerType, String header) {
            String[] cache = this.headerCache;
            if (cache == null) {
                cache = this.headerCache = new String[PropagationTags.HeaderType.getNumValues()];
            }
            cache[headerType.ordinal()] = header;
        }

        private void clearCachedHeader(PropagationTags.HeaderType headerType) {
            String[] cache;
            if (headerType == PropagationTags.HeaderType.DATADOG) {
                this.invalidateXDatadogTagsSize();
            }
            if ((cache = this.headerCache) == null) {
                return;
            }
            cache[headerType.ordinal()] = null;
        }

        int getxDatadogTagsLimit() {
            return this.factory.getxDatadogTagsLimit();
        }

        boolean isPropagationTagsDisabled() {
            return this.factory.isPropagationTagsDisabled();
        }

        List<TagElement> getTagPairs() {
            return this.tagPairs == null ? Collections.emptyList() : this.tagPairs;
        }

        private void invalidateXDatadogTagsSize() {
            this.xDatadogTagsSize = -1;
        }

        int getXDatadogTagsSize() {
            int size = this.xDatadogTagsSize;
            if (size == -1) {
                size = PTagsCodec.calcXDatadogTagsSize(this.getTagPairs());
                size = PTagsCodec.calcXDatadogTagsSize(size, PTagsCodec.DECISION_MAKER_TAG, this.decisionMakerTagValue);
                this.xDatadogTagsSize = size = PTagsCodec.calcXDatadogTagsSize(size, PTagsCodec.TRACE_ID_TAG, this.traceIdHighOrderBitsHexTagValue);
            }
            return size;
        }

        TagValue getTraceIdHighOrderBitsHexTagValue() {
            return this.traceIdHighOrderBitsHexTagValue;
        }

        TagValue getDecisionMakerTagValue() {
            return this.decisionMakerTagValue;
        }

        @Override
        public String getW3CTracestate() {
            return this.tracestate;
        }

        @Override
        public void updateW3CTracestate(String tracestate) {
            this.tracestate = tracestate;
        }

        String getError() {
            return this.error;
        }
    }
}

