/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.core.propagation;

import com.datadog.trace.api.TracePropagationStyle;
import com.datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import com.datadog.trace.core.DDSpanContext;
import com.datadog.trace.core.propagation.HttpCodec;
import java.util.Map;

public class CorePropagation
implements AgentPropagation {
    private final HttpCodec.Injector injector;
    private final Map<TracePropagationStyle, HttpCodec.Injector> injectors;
    private final HttpCodec.Extractor extractor;

    public CorePropagation(HttpCodec.Extractor extractor, HttpCodec.Injector defaultInjector, Map<TracePropagationStyle, HttpCodec.Injector> injectors) {
        this.extractor = extractor;
        this.injector = defaultInjector;
        this.injectors = injectors;
    }

    @Override
    public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter) {
        this.inject(span.context(), carrier, setter, null);
    }

    @Override
    public <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter) {
        this.inject(context, carrier, setter, null);
    }

    @Override
    public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, TracePropagationStyle style) {
        this.inject(span.context(), carrier, setter, style);
    }

    private <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter, TracePropagationStyle style) {
        if (!(context instanceof DDSpanContext)) {
            return;
        }
        DDSpanContext ddSpanContext = (DDSpanContext)context;
        ddSpanContext.getTrace().setSamplingPriorityIfNecessary();
        if (null == style) {
            this.injector.inject(ddSpanContext, carrier, setter);
        } else {
            this.injectors.get((Object)style).inject(ddSpanContext, carrier, setter);
        }
    }

    @Override
    public <C> AgentSpan.Context.Extracted extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
        return this.extractor.extract(carrier, getter);
    }
}

