/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.common.writer.ddagent;

import com.datadog.trace.common.writer.ddagent.FlushEvent;
import com.datadog.trace.common.writer.ddagent.PrioritizationStrategy;
import com.datadog.trace.core.CoreSpan;
import com.datadog.trace.ddagent.DroppingPolicy;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public enum Prioritization {
    ENSURE_TRACE{

        @Override
        public PrioritizationStrategy create(Queue<Object> primary, Queue<Object> secondary, Queue<Object> spanSampling, DroppingPolicy neverUsed) {
            return new EnsureTraceStrategy(primary, secondary, spanSampling);
        }
    }
    ,
    FAST_LANE{

        @Override
        public PrioritizationStrategy create(Queue<Object> primary, Queue<Object> secondary, Queue<Object> spanSampling, DroppingPolicy droppingPolicy) {
            return new FastLaneStrategy(primary, secondary, spanSampling, droppingPolicy);
        }
    };


    public abstract PrioritizationStrategy create(Queue<Object> var1, Queue<Object> var2, Queue<Object> var3, DroppingPolicy var4);

    private static final class FastLaneStrategy
    extends PrioritizationStrategyWithFlush {
        private final Queue<Object> secondary;
        private final Queue<Object> spanSampling;
        private final DroppingPolicy droppingPolicy;

        private FastLaneStrategy(Queue<Object> primary, Queue<Object> secondary, Queue<Object> spanSampling, DroppingPolicy droppingPolicy) {
            super(primary);
            this.secondary = secondary;
            this.spanSampling = spanSampling;
            this.droppingPolicy = droppingPolicy;
        }

        @Override
        public <T extends CoreSpan<T>> PrioritizationStrategy.PublishResult publish(T root, int priority, List<T> trace) {
            if (root.isForceKeep()) {
                return this.primary.offer(trace) ? PrioritizationStrategy.PublishResult.ENQUEUED_FOR_SERIALIZATION : PrioritizationStrategy.PublishResult.DROPPED_BUFFER_OVERFLOW;
            }
            switch (priority) {
                case -1: 
                case 0: {
                    if (this.spanSampling != null) {
                        return this.spanSampling.offer(trace) ? PrioritizationStrategy.PublishResult.ENQUEUED_FOR_SINGLE_SPAN_SAMPLING : PrioritizationStrategy.PublishResult.DROPPED_BUFFER_OVERFLOW;
                    }
                    if (this.droppingPolicy.active()) {
                        return PrioritizationStrategy.PublishResult.DROPPED_BY_POLICY;
                    }
                    return this.secondary.offer(trace) ? PrioritizationStrategy.PublishResult.ENQUEUED_FOR_SERIALIZATION : PrioritizationStrategy.PublishResult.DROPPED_BUFFER_OVERFLOW;
                }
            }
            return this.primary.offer(trace) ? PrioritizationStrategy.PublishResult.ENQUEUED_FOR_SERIALIZATION : PrioritizationStrategy.PublishResult.DROPPED_BUFFER_OVERFLOW;
        }
    }

    private static final class EnsureTraceStrategy
    extends PrioritizationStrategyWithFlush {
        private final Queue<Object> secondary;
        private final Queue<Object> spanSampling;

        private EnsureTraceStrategy(Queue<Object> primary, Queue<Object> secondary, Queue<Object> spanSampling) {
            super(primary);
            this.secondary = secondary;
            this.spanSampling = spanSampling;
        }

        @Override
        public <T extends CoreSpan<T>> PrioritizationStrategy.PublishResult publish(T root, int priority, List<T> trace) {
            switch (priority) {
                case -1: 
                case 0: {
                    if (this.spanSampling != null) {
                        return this.spanSampling.offer(trace) ? PrioritizationStrategy.PublishResult.ENQUEUED_FOR_SINGLE_SPAN_SAMPLING : PrioritizationStrategy.PublishResult.DROPPED_BUFFER_OVERFLOW;
                    }
                    return this.secondary.offer(trace) ? PrioritizationStrategy.PublishResult.ENQUEUED_FOR_SERIALIZATION : PrioritizationStrategy.PublishResult.DROPPED_BUFFER_OVERFLOW;
                }
            }
            this.blockingOffer(this.primary, trace);
            return PrioritizationStrategy.PublishResult.ENQUEUED_FOR_SERIALIZATION;
        }
    }

    private static abstract class PrioritizationStrategyWithFlush
    implements PrioritizationStrategy {
        protected final Queue<Object> primary;

        protected PrioritizationStrategyWithFlush(Queue<Object> primary) {
            this.primary = primary;
        }

        @Override
        public boolean flush(long timeout, TimeUnit timeUnit) {
            CountDownLatch latch = new CountDownLatch(1);
            FlushEvent event = new FlushEvent(latch);
            this.blockingOffer(this.primary, event);
            try {
                return latch.await(timeout, timeUnit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        protected void blockingOffer(Queue<Object> queue, Object event) {
            boolean offered;
            while (!(offered = queue.offer(event))) {
            }
        }
    }
}

