/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.common.sampling;

import com.datadog.trace.common.sampling.RateSampler;
import com.datadog.trace.core.CoreSpan;
import com.datadog.trace.core.util.Matcher;
import com.datadog.trace.core.util.Matchers;
import com.datadog.trace.core.util.SimpleRateLimiter;
import com.datadog.trace.core.util.TagsMatcher;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class SamplingRule {
    private final RateSampler sampler;

    public SamplingRule(RateSampler sampler) {
        this.sampler = sampler;
    }

    public abstract <T extends CoreSpan<T>> boolean matches(T var1);

    public <T extends CoreSpan<T>> boolean sample(T span) {
        return this.sampler.sample(span);
    }

    public RateSampler getSampler() {
        return this.sampler;
    }

    public static final class SpanSamplingRule
    extends SamplingRule {
        private final Matcher serviceMatcher;
        private final Matcher operationMatcher;
        private final SimpleRateLimiter rateLimiter;

        public SpanSamplingRule(String serviceName2, String operationName, RateSampler sampler, SimpleRateLimiter rateLimiter) {
            super(sampler);
            this.serviceMatcher = Matchers.compileGlob(serviceName2);
            this.operationMatcher = Matchers.compileGlob(operationName);
            this.rateLimiter = rateLimiter;
        }

        @Override
        public <T extends CoreSpan<T>> boolean matches(T span) {
            return Matchers.matches(this.serviceMatcher, span.getServiceName()) && Matchers.matches(this.operationMatcher, span.getOperationName());
        }

        @Override
        public <T extends CoreSpan<T>> boolean sample(T span) {
            return super.sample(span) && (this.rateLimiter == null || this.rateLimiter.tryAcquire());
        }

        public SimpleRateLimiter getRateLimiter() {
            return this.rateLimiter;
        }
    }

    public static final class TraceSamplingRule
    extends SamplingRule {
        private final Matcher serviceMatcher;
        private final Matcher operationMatcher;
        private final Matcher resourceMatcher;
        private final TagsMatcher tagsMatcher;

        public TraceSamplingRule(String serviceGlob, String operationGlob, String resourceGlob, Map<String, String> tags, RateSampler sampler) {
            super(sampler);
            this.serviceMatcher = Matchers.compileGlob(serviceGlob);
            this.operationMatcher = Matchers.compileGlob(operationGlob);
            this.resourceMatcher = Matchers.compileGlob(resourceGlob);
            this.tagsMatcher = TagsMatcher.create(tags);
        }

        @Override
        public <T extends CoreSpan<T>> boolean matches(T span) {
            return Matchers.matches(this.serviceMatcher, span.getServiceName()) && Matchers.matches(this.operationMatcher, span.getOperationName()) && Matchers.matches(this.resourceMatcher, span.getResourceName()) && this.tagsMatcher.matches(span);
        }
    }

    public static class OperationSamplingRule
    extends PatternMatchSamplingRule {
        public OperationSamplingRule(String regex, RateSampler sampler) {
            super(regex, sampler);
        }

        @Override
        protected <T extends CoreSpan<T>> CharSequence getRelevantString(T span) {
            return span.getOperationName();
        }
    }

    public static class ServiceSamplingRule
    extends PatternMatchSamplingRule {
        public ServiceSamplingRule(String regex, RateSampler sampler) {
            super(regex, sampler);
        }

        @Override
        protected <T extends CoreSpan<T>> String getRelevantString(T span) {
            return span.getServiceName();
        }
    }

    public static abstract class PatternMatchSamplingRule
    extends SamplingRule {
        private final Pattern pattern;

        public PatternMatchSamplingRule(String regex, RateSampler sampler) {
            super(sampler);
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public <T extends CoreSpan<T>> boolean matches(T span) {
            CharSequence relevantString = this.getRelevantString(span);
            return relevantString != null && this.pattern.matcher(relevantString).matches();
        }

        protected abstract <T extends CoreSpan<T>> CharSequence getRelevantString(T var1);
    }

    public static class AlwaysMatchesSamplingRule
    extends SamplingRule {
        public AlwaysMatchesSamplingRule(RateSampler sampler) {
            super(sampler);
        }

        @Override
        public <T extends CoreSpan<T>> boolean matches(T span) {
            return true;
        }
    }
}

