/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.common.sampling;

import com.datadog.trace.common.sampling.DeterministicSampler;
import com.datadog.trace.common.sampling.PrioritySampler;
import com.datadog.trace.common.sampling.RateByServiceTraceSampler;
import com.datadog.trace.common.sampling.Sampler;
import com.datadog.trace.common.sampling.SamplingRule;
import com.datadog.trace.common.sampling.TraceSamplingRules;
import com.datadog.trace.core.CoreSpan;
import com.datadog.trace.core.util.SimpleRateLimiter;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RuleBasedTraceSampler<T extends CoreSpan<T>>
implements Sampler,
PrioritySampler {
    private static final Logger log = LoggerFactory.getLogger(RuleBasedTraceSampler.class);
    private final List<SamplingRule> samplingRules;
    private final PrioritySampler fallbackSampler;
    private final SimpleRateLimiter rateLimiter;
    private final long rateLimit;
    public static final String SAMPLING_RULE_RATE = "_dd.rule_psr";
    public static final String SAMPLING_LIMIT_RATE = "_dd.limit_psr";

    public RuleBasedTraceSampler(List<SamplingRule> samplingRules, int rateLimit, PrioritySampler fallbackSampler) {
        this.samplingRules = samplingRules;
        this.fallbackSampler = fallbackSampler;
        this.rateLimiter = new SimpleRateLimiter(rateLimit);
        this.rateLimit = rateLimit;
    }

    public static RuleBasedTraceSampler build(TraceSamplingRules traceSamplingRules, Double defaultRate, int rateLimit) {
        return RuleBasedTraceSampler.build(null, null, traceSamplingRules, defaultRate, rateLimit);
    }

    public static RuleBasedTraceSampler build(@Deprecated Map<String, String> serviceRules, @Deprecated Map<String, String> operationRules, TraceSamplingRules traceSamplingRules, Double defaultRate, int rateLimit) {
        ArrayList<SamplingRule> samplingRules = new ArrayList<SamplingRule>();
        if (traceSamplingRules != null && !traceSamplingRules.isEmpty()) {
            if (!serviceRules.isEmpty() || !operationRules.isEmpty()) {
                log.warn("Both {} and/or {} as well as {} are defined. Only {} will be used for rule-based sampling", "trace.sampling.service.rules", "trace.sampling.operation.rules", "trace.sampling.rules", "trace.sampling.rules");
            }
            for (TraceSamplingRules.Rule rule : traceSamplingRules.getRules()) {
                SamplingRule.TraceSamplingRule samplingRule = new SamplingRule.TraceSamplingRule(rule.getService(), rule.getName(), rule.getResource(), rule.getTags(), new DeterministicSampler.TraceSampler(rule.getSampleRate()));
                samplingRules.add(samplingRule);
            }
        } else {
            SamplingRule.PatternMatchSamplingRule samplingRule;
            if (serviceRules != null) {
                for (Map.Entry<String, String> entry : serviceRules.entrySet()) {
                    try {
                        double rateForEntry = Double.parseDouble(entry.getValue());
                        samplingRule = new SamplingRule.ServiceSamplingRule(entry.getKey(), new DeterministicSampler.TraceSampler(rateForEntry));
                        samplingRules.add(samplingRule);
                    }
                    catch (NumberFormatException e) {
                        log.error("Unable to parse rate for service: {}", (Object)entry, (Object)e);
                    }
                }
            }
            if (operationRules != null) {
                for (Map.Entry<String, String> entry : operationRules.entrySet()) {
                    try {
                        double rateForEntry = Double.parseDouble(entry.getValue());
                        samplingRule = new SamplingRule.OperationSamplingRule(entry.getKey(), new DeterministicSampler.TraceSampler(rateForEntry));
                        samplingRules.add(samplingRule);
                    }
                    catch (NumberFormatException e) {
                        log.error("Unable to parse rate for operation: {}", (Object)entry, (Object)e);
                    }
                }
            }
        }
        if (defaultRate != null) {
            SamplingRule.AlwaysMatchesSamplingRule samplingRule = new SamplingRule.AlwaysMatchesSamplingRule(new DeterministicSampler.TraceSampler(defaultRate));
            samplingRules.add(samplingRule);
        }
        return new RuleBasedTraceSampler(samplingRules, rateLimit, new RateByServiceTraceSampler());
    }

    @Override
    public <T extends CoreSpan<T>> boolean sample(T span) {
        return true;
    }

    @Override
    public <T extends CoreSpan<T>> void setSamplingPriority(T span) {
        SamplingRule matchedRule = null;
        for (SamplingRule samplingRule : this.samplingRules) {
            if (!samplingRule.matches(span)) continue;
            matchedRule = samplingRule;
            break;
        }
        if (matchedRule == null) {
            this.fallbackSampler.setSamplingPriority(span);
        } else if (matchedRule.sample(span)) {
            if (this.rateLimiter.tryAcquire()) {
                span.setSamplingPriority(2, SAMPLING_RULE_RATE, matchedRule.getSampler().getSampleRate(), 3);
            } else {
                span.setSamplingPriority(-1, SAMPLING_RULE_RATE, matchedRule.getSampler().getSampleRate(), 3);
            }
            span.setMetric((CharSequence)SAMPLING_LIMIT_RATE, this.rateLimit);
        } else {
            span.setSamplingPriority(-1, SAMPLING_RULE_RATE, matchedRule.getSampler().getSampleRate(), 3);
        }
    }
}

