/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.common.sampling;

import com.datadog.android.trace.internal.compat.function.Function;
import com.datadog.trace.api.cache.DDCache;
import com.datadog.trace.api.cache.DDCaches;
import com.datadog.trace.common.sampling.DeterministicSampler;
import com.datadog.trace.common.sampling.PrioritySampler;
import com.datadog.trace.common.sampling.RateSampler;
import com.datadog.trace.common.sampling.Sampler;
import com.datadog.trace.common.writer.RemoteResponseListener;
import com.datadog.trace.core.CoreSpan;
import com.datadog.trace.core.util.MapUtils;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.LoggerFactory;
import java.util.HashMap;
import java.util.Map;

public class RateByServiceTraceSampler
implements Sampler,
PrioritySampler,
RemoteResponseListener {
    private static final Logger log = LoggerFactory.getLogger(RateByServiceTraceSampler.class);
    public static final String SAMPLING_AGENT_RATE = "_dd.agent_psr";
    private static final double DEFAULT_RATE = 1.0;
    private volatile RateSamplersByEnvAndService serviceRates = new RateSamplersByEnvAndService();

    @Override
    public <T extends CoreSpan<T>> boolean sample(T span) {
        return true;
    }

    @Override
    public <T extends CoreSpan<T>> void setSamplingPriority(T span) {
        String serviceName2 = span.getServiceName();
        RateSamplersByEnvAndService rates = this.serviceRates;
        String env = this.getSpanEnv(span);
        RateSampler sampler = rates.getSampler(env, serviceName2);
        if (sampler.sample(span)) {
            span.setSamplingPriority(1, SAMPLING_AGENT_RATE, sampler.getSampleRate(), 1);
        } else {
            span.setSamplingPriority(0, SAMPLING_AGENT_RATE, sampler.getSampleRate(), 1);
        }
    }

    private <T extends CoreSpan<T>> String getSpanEnv(T span) {
        return span.getTag("env", (String)"");
    }

    @Override
    public void onResponse(String endpoint, Map<String, Map<String, Number>> responseJson) {
        Map<String, Number> newServiceRates = responseJson.get("rate_by_service");
        if (null != newServiceRates) {
            log.debug("Update service sampler rates: {} -> {}", (Object)endpoint, (Object)responseJson);
            HashMap<String, Map<String, RateSampler>> updatedEnvServiceRates = new HashMap<String, Map<String, RateSampler>>(newServiceRates.size() * 2);
            for (Map.Entry<String, Number> entry : newServiceRates.entrySet()) {
                if (entry.getValue() == null) continue;
                EnvAndService envAndService = EnvAndService.fromString(entry.getKey());
                Map serviceRates = MapUtils.computeIfAbsent(envAndService.env, updatedEnvServiceRates, env -> new HashMap(newServiceRates.size() * 2));
                MapUtils.computeIfAbsent(envAndService.service, serviceRates, service -> RateByServiceTraceSampler.createRateSampler(((Number)entry.getValue()).doubleValue()));
            }
            this.serviceRates = new RateSamplersByEnvAndService(updatedEnvServiceRates);
        }
    }

    private static RateSampler createRateSampler(double sampleRate) {
        double sanitizedRate;
        if (sampleRate < 0.0) {
            log.error("SampleRate is negative or null, disabling the sampler");
            sanitizedRate = 1.0;
        } else {
            sanitizedRate = sampleRate > 1.0 ? 1.0 : sampleRate;
        }
        return new DeterministicSampler.TraceSampler(sanitizedRate);
    }

    private static final class RateSamplersByEnvAndService {
        private static final RateSampler DEFAULT = RateByServiceTraceSampler.createRateSampler(1.0);
        private final Map<String, Map<String, RateSampler>> envServiceRates;

        RateSamplersByEnvAndService() {
            this(new HashMap<String, Map<String, RateSampler>>(0));
        }

        RateSamplersByEnvAndService(Map<String, Map<String, RateSampler>> envServiceRates) {
            this.envServiceRates = envServiceRates;
        }

        RateSampler getSampler(EnvAndService envAndService) {
            return this.getSampler(envAndService.env, envAndService.service);
        }

        public RateSampler getSampler(String env, String service) {
            Map<String, RateSampler> serviceRates = this.envServiceRates.get(env);
            if (serviceRates == null) {
                return DEFAULT;
            }
            RateSampler sampler = serviceRates.get(service);
            return null == sampler ? DEFAULT : sampler;
        }
    }

    private static final class EnvAndService {
        private static final DDCache<String, EnvAndService> CACHE = DDCaches.newFixedSizeCache(32);
        private static final Function<String, EnvAndService> PARSE = new Function<String, EnvAndService>(){

            @Override
            public EnvAndService apply(String key) {
                int serviceStart = key.indexOf(58) + 1;
                int serviceEnd = key.indexOf(44, serviceStart);
                int envStart = key.indexOf(58, serviceEnd) + 1;
                if (serviceStart == serviceEnd && envStart == key.length() || (serviceStart | serviceEnd | envStart) < 0) {
                    return DEFAULT;
                }
                String service = key.substring(serviceStart, serviceEnd);
                String env = key.substring(envStart);
                return new EnvAndService(env, service);
            }
        };
        static final EnvAndService DEFAULT = new EnvAndService("", "");
        private final String env;
        private final String service;

        public static EnvAndService fromString(String key) {
            return CACHE.computeIfAbsent(key, PARSE);
        }

        private EnvAndService(String env, String service) {
            this.env = env;
            this.service = service;
        }
    }
}

