/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.bootstrap.instrumentation.api;

import com.datadog.android.trace.internal.compat.function.Supplier;
import com.datadog.trace.logger.Logger;
import com.datadog.trace.logger.LoggerFactory;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class URIUtils {
    private static final byte[] REPLACEMENT = new byte[]{-17, -65, -67};
    private static final Logger LOGGER = LoggerFactory.getLogger(URIUtils.class);

    private URIUtils() {
    }

    public static String decode(String encoded) {
        return URIUtils.decode(encoded, false);
    }

    public static String decode(String encoded, boolean plusToSpace) {
        if (encoded == null) {
            return null;
        }
        int len = encoded.length();
        if (len == 0) {
            return encoded;
        }
        if (!(encoded.indexOf(37) >= 0 || plusToSpace && encoded.indexOf(43) >= 0)) {
            return encoded;
        }
        ByteBuffer bb = ByteBuffer.allocate(len + 2);
        for (int i = 0; i < len; ++i) {
            int c = encoded.charAt(i);
            if (c == 37) {
                if (i + 2 < len) {
                    int l;
                    int h = Character.digit(encoded.charAt(i + 1), 16);
                    if ((h | (l = Character.digit(encoded.charAt(i + 2), 16))) < 0) {
                        bb.put(REPLACEMENT[0]);
                        bb.put(REPLACEMENT[1]);
                        bb.put(REPLACEMENT[2]);
                    } else {
                        bb.put((byte)((h << 4) + l));
                    }
                    i += 2;
                    continue;
                }
                bb.put(REPLACEMENT[0]);
                bb.put(REPLACEMENT[1]);
                bb.put(REPLACEMENT[2]);
                i = len;
                continue;
            }
            if (plusToSpace && c == 43) {
                c = 32;
            }
            bb.put((byte)c);
        }
        bb.flip();
        return new String(bb.array(), 0, bb.limit(), StandardCharsets.UTF_8);
    }

    public static URI safeParse(String unparsed) {
        if (unparsed == null) {
            return null;
        }
        try {
            return URI.create(unparsed);
        }
        catch (IllegalArgumentException exception) {
            LOGGER.debug("Unable to parse request uri {}", (Object)unparsed, (Object)exception);
            return null;
        }
    }

    public static abstract class LazyUrl
    implements CharSequence,
    Supplier<String> {
        protected String lazy;

        protected LazyUrl(String lazy) {
            this.lazy = lazy;
        }

        public abstract String path();

        @Override
        public String toString() {
            String str = this.lazy;
            if (str == null) {
                str = this.lazy = (String)this.get();
            }
            return str;
        }

        @Override
        public int length() {
            return this.toString().length();
        }

        @Override
        public char charAt(int index) {
            return this.toString().charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().subSequence(start, end);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

