/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.bootstrap.instrumentation.api;

import androidx.annotation.Nullable;
import com.datadog.android.trace.internal.compat.function.Consumer;
import com.datadog.trace.api.DDTraceId;
import com.datadog.trace.api.EndpointCheckpointer;
import com.datadog.trace.api.TraceConfig;
import com.datadog.trace.api.TracePropagationStyle;
import com.datadog.trace.api.Tracer;
import com.datadog.trace.api.gateway.Flow;
import com.datadog.trace.api.gateway.RequestContext;
import com.datadog.trace.api.gateway.RequestContextSlot;
import com.datadog.trace.api.internal.InternalTracer;
import com.datadog.trace.api.profiling.Timer;
import com.datadog.trace.api.sampling.SamplingRule;
import com.datadog.trace.api.scopemanager.ScopeListener;
import com.datadog.trace.bootstrap.instrumentation.api.AgentHistogram;
import com.datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import com.datadog.trace.bootstrap.instrumentation.api.AgentScope;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpanLink;
import com.datadog.trace.bootstrap.instrumentation.api.AgentTrace;
import com.datadog.trace.bootstrap.instrumentation.api.PathwayContext;
import com.datadog.trace.bootstrap.instrumentation.api.ProfilingContextIntegration;
import com.datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import com.datadog.trace.bootstrap.instrumentation.api.ScopeStateAware;
import com.datadog.trace.bootstrap.instrumentation.api.StatsPoint;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AgentTracer {
    private static final String DEFAULT_INSTRUMENTATION_NAME = "datadog";

    private AgentTracer() {
    }

    public static final class NoopTraceConfig
    implements TraceConfig {
        public static final NoopTraceConfig INSTANCE = new NoopTraceConfig();

        @Override
        public boolean isRuntimeMetricsEnabled() {
            return false;
        }

        @Override
        public boolean isLogsInjectionEnabled() {
            return false;
        }

        @Override
        public boolean isDataStreamsEnabled() {
            return false;
        }

        @Override
        public Map<String, String> getServiceMapping() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, String> getRequestHeaderTags() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, String> getResponseHeaderTags() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, String> getBaggageMapping() {
            return Collections.emptyMap();
        }

        @Override
        public Double getTraceSampleRate() {
            return null;
        }

        @Override
        public List<? extends SamplingRule.SpanSamplingRule> getSpanSamplingRules() {
            return Collections.emptyList();
        }

        @Override
        public List<? extends SamplingRule.TraceSamplingRule> getTraceSamplingRules() {
            return Collections.emptyList();
        }
    }

    public static class NoopAgentHistogram
    implements AgentHistogram {
        public static final NoopAgentHistogram INSTANCE = new NoopAgentHistogram();

        @Override
        public double getCount() {
            return 0.0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void accept(double value) {
        }

        @Override
        public void accept(double value, double count) {
        }

        @Override
        public double getValueAtQuantile(double quantile) {
            return 0.0;
        }

        @Override
        public double getMinValue() {
            return 0.0;
        }

        @Override
        public double getMaxValue() {
            return 0.0;
        }

        @Override
        public void clear() {
        }

        @Override
        public ByteBuffer serialize() {
            return null;
        }
    }

    public static class NoopPathwayContext
    implements PathwayContext {
        public static final NoopPathwayContext INSTANCE = new NoopPathwayContext();

        @Override
        public boolean isStarted() {
            return false;
        }

        @Override
        public long getHash() {
            return 0L;
        }

        @Override
        public void setCheckpoint(LinkedHashMap<String, String> sortedTags, Consumer<StatsPoint> pointConsumer, long defaultTimestamp, long payloadSizeBytes) {
        }

        @Override
        public void setCheckpoint(LinkedHashMap<String, String> sortedTags, Consumer<StatsPoint> pointConsumer, long defaultTimestamp) {
        }

        @Override
        public void setCheckpoint(LinkedHashMap<String, String> sortedTags, Consumer<StatsPoint> pointConsumer) {
        }

        @Override
        public void saveStats(StatsPoint point) {
        }

        @Override
        public StatsPoint getSavedStats() {
            return null;
        }

        @Override
        public byte[] encode() {
            return null;
        }

        @Override
        public String strEncode() {
            return null;
        }
    }

    public static class NoopAgentTrace
    implements AgentTrace {
        public static final NoopAgentTrace INSTANCE = new NoopAgentTrace();

        @Override
        public void registerContinuation(AgentScope.Continuation continuation) {
        }

        @Override
        public void cancelContinuation(AgentScope.Continuation continuation) {
        }
    }

    public static final class NoopContext
    implements AgentSpan.Context.Extracted {
        public static final NoopContext INSTANCE = new NoopContext();

        private NoopContext() {
        }

        @Override
        public DDTraceId getTraceId() {
            return DDTraceId.ZERO;
        }

        @Override
        public long getSpanId() {
            return 0L;
        }

        @Override
        public AgentTrace getTrace() {
            return NoopAgentTrace.INSTANCE;
        }

        @Override
        public int getSamplingPriority() {
            return -128;
        }

        @Override
        public Iterable<Map.Entry<String, String>> baggageItems() {
            return Collections.emptyList();
        }

        @Override
        public PathwayContext getPathwayContext() {
            return NoopPathwayContext.INSTANCE;
        }

        @Override
        public List<AgentSpanLink> getTerminatedContextLinks() {
            return Collections.emptyList();
        }

        @Override
        public String getForwarded() {
            return null;
        }

        @Override
        public String getFastlyClientIp() {
            return null;
        }

        @Override
        public String getCfConnectingIp() {
            return null;
        }

        @Override
        public String getCfConnectingIpv6() {
            return null;
        }

        @Override
        public String getXForwardedProto() {
            return null;
        }

        @Override
        public String getXForwardedHost() {
            return null;
        }

        @Override
        public String getXForwardedPort() {
            return null;
        }

        @Override
        public String getForwardedFor() {
            return null;
        }

        @Override
        public String getXForwarded() {
            return null;
        }

        @Override
        public String getXForwardedFor() {
            return null;
        }

        @Override
        public String getXClusterClientIp() {
            return null;
        }

        @Override
        public String getXRealIp() {
            return null;
        }

        @Override
        public String getXClientIp() {
            return null;
        }

        @Override
        public String getUserAgent() {
            return null;
        }

        @Override
        public String getTrueClientIp() {
            return null;
        }

        @Override
        public String getCustomIpHeader() {
            return null;
        }
    }

    static class NoopContinuation
    implements AgentScope.Continuation {
        static final NoopContinuation INSTANCE = new NoopContinuation();

        NoopContinuation() {
        }

        @Override
        public AgentScope activate() {
            return NoopAgentScope.INSTANCE;
        }

        @Override
        public void cancel() {
        }

        @Override
        public AgentSpan getSpan() {
            return NoopAgentSpan.INSTANCE;
        }
    }

    static class NoopAgentPropagation
    implements AgentPropagation {
        static final NoopAgentPropagation INSTANCE = new NoopAgentPropagation();

        NoopAgentPropagation() {
        }

        @Override
        public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, TracePropagationStyle style) {
        }

        @Override
        public <C> AgentSpan.Context.Extracted extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
            return NoopContext.INSTANCE;
        }
    }

    public static final class NoopAgentScope
    implements AgentScope {
        public static final NoopAgentScope INSTANCE = new NoopAgentScope();

        private NoopAgentScope() {
        }

        @Override
        public AgentSpan span() {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public byte source() {
            return 0;
        }

        @Override
        public void setAsyncPropagation(boolean value) {
        }

        @Override
        public AgentScope.Continuation capture() {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public AgentScope.Continuation captureConcurrent() {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isAsyncPropagating() {
            return false;
        }
    }

    public static final class NoopAgentSpan
    implements AgentSpan {
        public static final NoopAgentSpan INSTANCE = new NoopAgentSpan();

        private NoopAgentSpan() {
        }

        @Override
        public DDTraceId getTraceId() {
            return DDTraceId.ZERO;
        }

        @Override
        public long getSpanId() {
            return 0L;
        }

        @Override
        public AgentSpan setTag(String key, boolean value) {
            return this;
        }

        @Override
        public void setRequestBlockingAction(Flow.Action.RequestBlockingAction rba) {
        }

        @Override
        public Flow.Action.RequestBlockingAction getRequestBlockingAction() {
            return null;
        }

        @Override
        public AgentSpan setTag(String tag, Number value) {
            return this;
        }

        @Override
        public boolean isError() {
            return false;
        }

        @Override
        public AgentSpan setTag(String key, int value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, long value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, double value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, Object value) {
            return this;
        }

        @Override
        public AgentSpan setMetric(CharSequence key, int value) {
            return this;
        }

        @Override
        public AgentSpan setMetric(CharSequence key, long value) {
            return this;
        }

        @Override
        public AgentSpan setMetric(CharSequence key, double value) {
            return this;
        }

        @Override
        public Object getTag(String key) {
            return null;
        }

        @Override
        public long getStartTime() {
            return 0L;
        }

        @Override
        public long getDurationNano() {
            return 0L;
        }

        @Override
        public String getOperationName() {
            return null;
        }

        @Override
        public AgentSpan setOperationName(CharSequence serviceName2) {
            return this;
        }

        @Override
        public String getServiceName() {
            return null;
        }

        @Override
        public AgentSpan setServiceName(String serviceName2) {
            return this;
        }

        @Override
        public CharSequence getResourceName() {
            return null;
        }

        @Override
        public AgentSpan setResourceName(CharSequence resourceName) {
            return this;
        }

        @Override
        public AgentSpan setResourceName(CharSequence resourceName, byte priority) {
            return this;
        }

        @Override
        public boolean eligibleForDropping() {
            return true;
        }

        @Override
        public RequestContext getRequestContext() {
            return RequestContext.Noop.INSTANCE;
        }

        @Override
        public Integer forceSamplingDecision() {
            return null;
        }

        @Override
        public AgentSpan setSamplingPriority(int newPriority, int samplingMechanism) {
            return this;
        }

        @Override
        public Integer getSamplingPriority() {
            return -128;
        }

        @Override
        public AgentSpan setSamplingPriority(int newPriority) {
            return this;
        }

        @Override
        public String getSpanType() {
            return null;
        }

        @Override
        public AgentSpan setSpanType(CharSequence type) {
            return this;
        }

        @Override
        public Map<String, Object> getTags() {
            return Collections.emptyMap();
        }

        @Override
        public AgentSpan setTag(String key, String value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, CharSequence value) {
            return this;
        }

        @Override
        public AgentSpan setError(boolean error) {
            return this;
        }

        @Override
        public AgentSpan setError(boolean error, byte priority) {
            return this;
        }

        @Override
        public AgentSpan setMeasured(boolean measured) {
            return this;
        }

        @Override
        public AgentSpan getRootSpan() {
            return this;
        }

        @Override
        public AgentSpan setErrorMessage(String errorMessage) {
            return this;
        }

        @Override
        public AgentSpan addThrowable(Throwable throwable) {
            return this;
        }

        @Override
        public AgentSpan addThrowable(Throwable throwable, byte errorPriority) {
            return this;
        }

        @Override
        public AgentSpan setHttpStatusCode(int statusCode) {
            return this;
        }

        @Override
        public short getHttpStatusCode() {
            return 0;
        }

        @Override
        public AgentSpan getLocalRootSpan() {
            return this;
        }

        @Override
        public boolean isSameTrace(AgentSpan otherSpan) {
            return otherSpan == INSTANCE;
        }

        @Override
        public AgentSpan.Context context() {
            return NoopContext.INSTANCE;
        }

        @Override
        public String getBaggageItem(String key) {
            return null;
        }

        @Override
        public AgentSpan setBaggageItem(String key, String value) {
            return this;
        }

        @Override
        public void finish() {
        }

        @Override
        public void finish(long finishMicros) {
        }

        @Override
        public void finishWithDuration(long durationNanos) {
        }

        @Override
        public void beginEndToEnd() {
        }

        @Override
        public void finishWithEndToEnd() {
        }

        @Override
        public boolean phasedFinish() {
            return false;
        }

        @Override
        public void publish() {
        }

        @Override
        public String getSpanName() {
            return "";
        }

        @Override
        public void setSpanName(CharSequence spanName) {
        }

        @Override
        public boolean hasResourceName() {
            return false;
        }

        @Override
        public byte getResourceNamePriority() {
            return 127;
        }

        @Override
        public TraceConfig traceConfig() {
            return NoopTraceConfig.INSTANCE;
        }

        @Override
        public void addLink(AgentSpanLink link) {
        }
    }

    public static interface SpanBuilder {
        public AgentSpan start();

        public SpanBuilder asChildOf(AgentSpan.Context var1);

        public SpanBuilder ignoreActiveSpan();

        public SpanBuilder withTag(String var1, String var2);

        public SpanBuilder withTag(String var1, boolean var2);

        public SpanBuilder withTag(String var1, Number var2);

        public SpanBuilder withTag(String var1, Object var2);

        public SpanBuilder withStartTimestamp(long var1);

        public SpanBuilder withServiceName(String var1);

        public SpanBuilder withResourceName(String var1);

        public SpanBuilder withErrorFlag();

        public SpanBuilder withSpanType(CharSequence var1);

        public <T> SpanBuilder withRequestContextData(RequestContextSlot var1, T var2);

        public SpanBuilder withLink(AgentSpanLink var1);
    }

    public static interface TracerAPI
    extends Tracer,
    InternalTracer,
    EndpointCheckpointer,
    ScopeStateAware {
        public AgentSpan startSpan(String var1, CharSequence var2);

        public AgentSpan startSpan(String var1, CharSequence var2, long var3);

        public AgentSpan startSpan(String var1, CharSequence var2, AgentSpan.Context var3);

        public AgentSpan startSpan(String var1, CharSequence var2, AgentSpan.Context var3, long var4);

        public AgentScope activateSpan(AgentSpan var1, ScopeSource var2);

        public AgentScope activateSpan(AgentSpan var1, ScopeSource var2, boolean var3);

        public AgentScope.Continuation captureSpan(AgentSpan var1);

        public void closePrevious(boolean var1);

        public AgentScope activateNext(AgentSpan var1);

        @Nullable
        public AgentSpan activeSpan();

        public AgentScope activeScope();

        public AgentPropagation propagate();

        public AgentSpan noopSpan();

        @Deprecated
        default public SpanBuilder buildSpan(CharSequence spanName) {
            return this.buildSpan(AgentTracer.DEFAULT_INSTRUMENTATION_NAME, spanName);
        }

        public SpanBuilder buildSpan(String var1, CharSequence var2);

        public void close();

        public void addScopeListener(ScopeListener var1);

        public void registerCheckpointer(EndpointCheckpointer var1);

        public void registerTimer(Timer var1);

        public Timer getTimer();

        public String getTraceId(AgentSpan var1);

        public String getSpanId(AgentSpan var1);

        public TraceConfig captureTraceConfig();

        public ProfilingContextIntegration getProfilingContext();
    }
}

