/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.api.naming.v0;

import androidx.annotation.NonNull;
import com.datadog.trace.api.Config;
import com.datadog.trace.api.naming.NamingSchema;

public class MessagingNamingV0
implements NamingSchema.ForMessaging {
    private final boolean allowInferredServices;

    public MessagingNamingV0(boolean allowInferredServices) {
        this.allowInferredServices = allowInferredServices;
    }

    @Override
    @NonNull
    public String outboundOperation(@NonNull String messagingSystem) {
        if ("amqp".equals(messagingSystem)) {
            return "amqp.command";
        }
        return messagingSystem + ".produce";
    }

    @Override
    public String outboundService(@NonNull String messagingSystem, boolean useLegacyTracing) {
        return this.inboundService(messagingSystem, useLegacyTracing);
    }

    @Override
    @NonNull
    public String inboundOperation(@NonNull String messagingSystem) {
        switch (messagingSystem) {
            case "amqp": {
                return "amqp.command";
            }
            case "sqs": {
                return "aws.http";
            }
        }
        return messagingSystem + ".consume";
    }

    @Override
    public String inboundService(@NonNull String messagingSystem, boolean useLegacyTracing) {
        if (this.allowInferredServices) {
            return useLegacyTracing ? messagingSystem : Config.get().getServiceName();
        }
        return null;
    }

    @Override
    @NonNull
    public String timeInQueueService(@NonNull String messagingSystem) {
        return messagingSystem;
    }

    @Override
    @NonNull
    public String timeInQueueOperation(@NonNull String messagingSystem) {
        if ("sqs".equals(messagingSystem)) {
            return "aws.http";
        }
        return messagingSystem + ".deliver";
    }
}

