/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.api.naming;

import androidx.annotation.NonNull;
import com.datadog.trace.api.Config;
import com.datadog.trace.api.naming.NamingSchema;
import com.datadog.trace.api.naming.v0.NamingSchemaV0;
import com.datadog.trace.api.naming.v1.NamingSchemaV1;

public class SpanNaming {
    public static final int SCHEMA_MIN_VERSION = 0;
    public static final int SCHEMA_MAX_VERSION = 1;
    private final NamingSchema namingSchema;
    private final int version;

    public static SpanNaming instance() {
        return Singleton.INSTANCE;
    }

    private SpanNaming() {
        this(Config.get().getSpanAttributeSchemaVersion());
    }

    private SpanNaming(int version) {
        this.version = version;
        switch (version) {
            case 1: {
                this.namingSchema = new NamingSchemaV1();
                break;
            }
            default: {
                this.namingSchema = new NamingSchemaV0();
            }
        }
    }

    @NonNull
    public NamingSchema namingSchema() {
        return this.namingSchema;
    }

    public int version() {
        return this.version;
    }

    public static class Singleton {
        private static SpanNaming INSTANCE = new SpanNaming();
    }
}

