/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.api.metrics;

import com.datadog.trace.api.metrics.CoreCounter;
import com.datadog.trace.api.metrics.SpanMetricRegistry;
import com.datadog.trace.api.metrics.SpanMetrics;
import com.datadog.trace.api.metrics.SpanMetricsImpl;
import com.datadog.trace.core.util.MapUtils;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SpanMetricRegistryImpl
implements SpanMetricRegistry {
    private static final SpanMetricRegistryImpl INSTANCE = new SpanMetricRegistryImpl();
    private final Map<String, SpanMetricsImpl> spanMetrics = new ConcurrentHashMap<String, SpanMetricsImpl>();

    public static SpanMetricRegistryImpl getInstance() {
        return INSTANCE;
    }

    private SpanMetricRegistryImpl() {
    }

    @Override
    public SpanMetrics get(String instrumentationName) {
        return MapUtils.computeIfAbsent(instrumentationName, this.spanMetrics, SpanMetricsImpl::new);
    }

    @Override
    public String summary() {
        StringBuilder summary = new StringBuilder();
        for (SpanMetricsImpl metric : this.spanMetrics.values()) {
            summary.append(metric.getInstrumentationName());
            String separator = ": ";
            for (CoreCounter counter : metric.getCounters()) {
                summary.append(separator).append(counter.getName()).append('=').append(counter.getValue());
                separator = ", ";
            }
            summary.append('\n');
        }
        return summary.toString();
    }

    public Collection<SpanMetricsImpl> getSpanMetrics() {
        return this.spanMetrics.values();
    }
}

