/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.api;

import androidx.annotation.Nullable;
import java.util.Objects;

public final class Pair<T, U> {
    private final T left;
    private final U right;

    public static <T, U> Pair<T, U> of(T left, U right) {
        return new Pair<T, U>(left, right);
    }

    Pair(@Nullable T left, @Nullable U right) {
        this.left = left;
        this.right = right;
    }

    @Nullable
    public T getLeft() {
        return this.left;
    }

    @Nullable
    public U getRight() {
        return this.right;
    }

    public boolean hasLeft() {
        return null != this.left;
    }

    public boolean hasRight() {
        return null != this.right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Pair) {
            Pair pair = (Pair)o;
            return Objects.equals(this.left, pair.left) && Objects.equals(this.right, pair.right);
        }
        return false;
    }

    public int hashCode() {
        return 31 * (null == this.left ? 0 : this.left.hashCode()) + (null == this.right ? 0 : this.right.hashCode());
    }
}

