/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentracing.scopemanager;

import com.datadog.legacy.trace.context.ScopeListener;
import com.datadog.opentracing.DDSpan;
import com.datadog.opentracing.jfr.DDScopeEventFactory;
import com.datadog.opentracing.scopemanager.ContinuableScope;
import com.datadog.opentracing.scopemanager.DDScope;
import com.datadog.opentracing.scopemanager.ScopeContext;
import com.datadog.opentracing.scopemanager.SimpleScope;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.noop.NoopScopeManager;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ContextualScopeManager
implements ScopeManager {
    static final ThreadLocal<DDScope> tlsScope = new ThreadLocal();
    final Deque<ScopeContext> scopeContexts = new LinkedList<ScopeContext>();
    final List<ScopeListener> scopeListeners = new CopyOnWriteArrayList<ScopeListener>();
    private final int depthLimit;
    private final DDScopeEventFactory scopeEventFactory;

    public ContextualScopeManager(int depthLimit, DDScopeEventFactory scopeEventFactory) {
        this.depthLimit = depthLimit;
        this.scopeEventFactory = scopeEventFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scope activate(Span span, boolean finishOnClose) {
        int currentDepth;
        Scope active = this.active();
        if (active instanceof DDScope && this.depthLimit <= (currentDepth = ((DDScope)active).depth())) {
            return NoopScopeManager.NoopScope.INSTANCE;
        }
        Deque<ScopeContext> deque = this.scopeContexts;
        synchronized (deque) {
            for (ScopeContext context : this.scopeContexts) {
                if (!context.inContext()) continue;
                return context.activate(span, finishOnClose);
            }
        }
        if (span instanceof DDSpan) {
            return new ContinuableScope(this, (DDSpan)span, finishOnClose, this.scopeEventFactory);
        }
        return new SimpleScope(this, span, finishOnClose);
    }

    public Scope activate(Span span) {
        return this.activate(span, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scope active() {
        Deque<ScopeContext> deque = this.scopeContexts;
        synchronized (deque) {
            for (ScopeContext csm : this.scopeContexts) {
                if (!csm.inContext()) continue;
                return csm.active();
            }
        }
        return tlsScope.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span activeSpan() {
        Deque<ScopeContext> deque = this.scopeContexts;
        synchronized (deque) {
            for (ScopeContext csm : this.scopeContexts) {
                if (!csm.inContext()) continue;
                return csm.activeSpan();
            }
        }
        DDScope active = tlsScope.get();
        return active == null ? null : active.span();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addScopeContext(ScopeContext context) {
        Deque<ScopeContext> deque = this.scopeContexts;
        synchronized (deque) {
            this.scopeContexts.addFirst(context);
        }
    }

    public void addScopeListener(ScopeListener listener) {
        this.scopeListeners.add(listener);
    }
}

