/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentracing.propagation;

import com.datadog.opentracing.DDSpanContext;
import com.datadog.opentracing.propagation.ExtractedContext;
import com.datadog.opentracing.propagation.HttpCodec;
import com.datadog.opentracing.propagation.TagContext;
import io.opentracing.SpanContext;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class HaystackHttpCodec {
    private static final String OT_BAGGAGE_PREFIX = "Baggage-";
    private static final String TRACE_ID_KEY = "Trace-ID";
    private static final String SPAN_ID_KEY = "Span-ID";
    private static final String PARENT_ID_KEY = "Parent_ID";

    private HaystackHttpCodec() {
    }

    public static class Extractor
    implements HttpCodec.Extractor {
        private final Map<String, String> taggedHeaders = new HashMap<String, String>();

        public Extractor(Map<String, String> taggedHeaders) {
            for (Map.Entry<String, String> mapping : taggedHeaders.entrySet()) {
                this.taggedHeaders.put(mapping.getKey().trim().toLowerCase(Locale.US), mapping.getValue());
            }
        }

        @Override
        public SpanContext extract(TextMapExtract carrier) {
            try {
                Map<String, String> baggage = Collections.emptyMap();
                Map<String, String> tags = Collections.emptyMap();
                BigInteger traceId = BigInteger.ZERO;
                BigInteger spanId = BigInteger.ZERO;
                boolean samplingPriority = true;
                String origin = null;
                for (Map.Entry entry : carrier) {
                    String key = ((String)entry.getKey()).toLowerCase(Locale.US);
                    String value = (String)entry.getValue();
                    if (value == null) continue;
                    if (HaystackHttpCodec.TRACE_ID_KEY.equalsIgnoreCase(key)) {
                        traceId = HttpCodec.validateUInt64BitsID(value, 10);
                    } else if (HaystackHttpCodec.SPAN_ID_KEY.equalsIgnoreCase(key)) {
                        spanId = HttpCodec.validateUInt64BitsID(value, 10);
                    } else if (key.startsWith(HaystackHttpCodec.OT_BAGGAGE_PREFIX.toLowerCase(Locale.US))) {
                        if (baggage.isEmpty()) {
                            baggage = new HashMap<String, String>();
                        }
                        baggage.put(key.replace(HaystackHttpCodec.OT_BAGGAGE_PREFIX.toLowerCase(Locale.US), ""), HttpCodec.decode(value));
                    }
                    if (!this.taggedHeaders.containsKey(key)) continue;
                    if (tags.isEmpty()) {
                        tags = new HashMap<String, String>();
                    }
                    tags.put(this.taggedHeaders.get(key), HttpCodec.decode(value));
                }
                if (!BigInteger.ZERO.equals(traceId)) {
                    ExtractedContext context = new ExtractedContext(traceId, spanId, 1, origin, baggage, tags);
                    context.lockSamplingPriority();
                    return context;
                }
                if (origin != null || !tags.isEmpty()) {
                    return new TagContext(origin, tags);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return null;
        }
    }

    public static class Injector
    implements HttpCodec.Injector {
        @Override
        public void inject(DDSpanContext context, TextMapInject carrier) {
            carrier.put(HaystackHttpCodec.TRACE_ID_KEY, context.getTraceId().toString());
            carrier.put(HaystackHttpCodec.SPAN_ID_KEY, context.getSpanId().toString());
            carrier.put(HaystackHttpCodec.PARENT_ID_KEY, context.getParentId().toString());
            for (Map.Entry<String, String> entry : context.baggageItems()) {
                carrier.put(HaystackHttpCodec.OT_BAGGAGE_PREFIX + entry.getKey(), HttpCodec.encode(entry.getValue()));
            }
        }
    }
}

