/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.trace.internal.domain.event;

import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.context.NetworkInfo;
import com.datadog.android.api.context.UserInfo;
import com.datadog.android.trace.internal.domain.event.ContextAwareMapper;
import com.datadog.android.trace.model.SpanEvent;
import com.datadog.trace.api.DDSpanId;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpanLink;
import com.datadog.trace.core.DDSpan;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\b\u0000\u0018\u0000 &2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001&B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u001c\u0010#\u001a\u00020\u001e2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140$H\u0002J\f\u0010%\u001a\u00020\u0014*\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006'"}, d2={"Lcom/datadog/android/trace/internal/domain/event/CoreTracerSpanToSpanEventMapper;", "Lcom/datadog/android/trace/internal/domain/event/ContextAwareMapper;", "Lcom/datadog/trace/core/DDSpan;", "Lcom/datadog/android/trace/model/SpanEvent;", "networkInfoEnabled", "", "(Z)V", "getNetworkInfoEnabled$dd_sdk_android_trace_release", "()Z", "map", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "model", "resolveMeta", "Lcom/datadog/android/trace/model/SpanEvent$Meta;", "event", "resolveMetrics", "Lcom/datadog/android/trace/model/SpanEvent$Metrics;", "resolveMetricsFromSpanContext", "", "", "", "span", "resolveParentId", "resolveSimCarrier", "Lcom/datadog/android/trace/model/SpanEvent$SimCarrier;", "networkInfo", "Lcom/datadog/android/api/context/NetworkInfo;", "resolveSpanId", "resolveSpanLink", "Lcom/google/gson/JsonObject;", "link", "Lcom/datadog/trace/bootstrap/instrumentation/api/AgentSpanLink;", "resolveSpanLinks", "resolveTraceId", "toJson", "", "takeLeastSignificant64Bits", "Companion", "dd-sdk-android-trace_release"})
@SourceDebugExtension(value={"SMAP\nCoreTracerSpanToSpanEventMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreTracerSpanToSpanEventMapper.kt\ncom/datadog/android/trace/internal/domain/event/CoreTracerSpanToSpanEventMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,197:1\n1#2:198\n442#3:199\n392#3:200\n483#3,7:212\n442#3:219\n392#3:220\n1238#4,4:201\n1549#4:205\n1620#4,3:206\n1789#4,3:209\n1238#4,4:221\n215#5,2:225\n*S KotlinDebug\n*F\n+ 1 CoreTracerSpanToSpanEventMapper.kt\ncom/datadog/android/trace/internal/domain/event/CoreTracerSpanToSpanEventMapper\n*L\n106#1:199\n106#1:200\n166#1:212,7\n167#1:219\n167#1:220\n106#1:201,4\n126#1:205\n126#1:206,3\n126#1:209,3\n167#1:221,4\n179#1:225,2\n*E\n"})
public final class CoreTracerSpanToSpanEventMapper
implements ContextAwareMapper<DDSpan, SpanEvent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean networkInfoEnabled;
    private static final int LEAST_SIGNIFICANT_64_BITS_AS_HEX_LENGTH = 16;
    @NotNull
    private static final String ATTRIBUTES_KEY = "attributes";
    @NotNull
    private static final String SPAN_ID_KEY = "span_id";
    @NotNull
    private static final String TRACE_ID_KEY = "trace_id";
    @NotNull
    private static final String TRACE_STATE_KEY = "tracestate";
    @NotNull
    private static final String FLAGS_KEY = "flags";
    @NotNull
    public static final String SPAN_LINKS_KEY = "_dd.span_links";

    public CoreTracerSpanToSpanEventMapper(boolean networkInfoEnabled) {
        this.networkInfoEnabled = networkInfoEnabled;
    }

    public final boolean getNetworkInfoEnabled$dd_sdk_android_trace_release() {
        return this.networkInfoEnabled;
    }

    @Override
    @NotNull
    public SpanEvent map(@NotNull DatadogContext datadogContext, @NotNull DDSpan model) {
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        long serverOffset = datadogContext.getTime().getServerTimeOffsetNs();
        SpanEvent.Metrics metrics = this.resolveMetrics(model);
        SpanEvent.Meta metadata = this.resolveMeta(datadogContext, model);
        String string = this.resolveTraceId(model);
        String string2 = this.resolveSpanId(model);
        String string3 = this.resolveParentId(model);
        String string4 = ((Object)model.getResourceName()).toString();
        String string5 = ((Object)model.getOperationName()).toString();
        String string6 = model.getServiceName();
        long l = model.getDurationNano();
        long l2 = model.getStartTime() + serverOffset;
        long l3 = model.getError();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"serviceName");
        return new SpanEvent(string, string2, string3, string4, string5, string6, l, l2, l3, metrics, metadata);
    }

    private final String resolveTraceId(DDSpan model) {
        String string = model.getTraceId().toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"model.traceId.toHexString()");
        return this.takeLeastSignificant64Bits(string);
    }

    private final String resolveSpanId(DDSpan model) {
        String string = DDSpanId.toHexStringPadded(model.getSpanId());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexStringPadded(model.spanId)");
        return string;
    }

    private final String resolveParentId(DDSpan model) {
        String string = DDSpanId.toHexStringPadded(model.getParentId());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexStringPadded(model.parentId)");
        return string;
    }

    private final SpanEvent.Metrics resolveMetrics(DDSpan event) {
        Map<String, Number> map2;
        Map<String, Number> $this$resolveMetrics_u24lambda_u240 = map2 = this.resolveMetricsFromSpanContext(event);
        boolean bl = false;
        $this$resolveMetrics_u24lambda_u240.put("_sampling_priority_v1", event.samplingPriority());
        Map<String, Number> metrics = map2;
        return new SpanEvent.Metrics(event.getParentId() == 0L ? Long.valueOf(1L) : null, metrics);
    }

    /*
     * WARNING - void declaration
     */
    private final SpanEvent.Meta resolveMeta(DatadogContext datadogContext, DDSpan event) {
        Map meta;
        SpanEvent.Dd dd;
        SpanEvent.Usr usrMeta;
        SpanEvent.Network networkInfoMeta;
        block9: {
            void $this$mapValuesTo$iv$iv;
            SpanEvent.View view;
            SpanEvent.Session session;
            SpanEvent.Session session2;
            SpanEvent.Application application;
            SpanEvent.Application application2;
            Object it;
            String string;
            SpanEvent.Network network;
            if (this.networkInfoEnabled) {
                NetworkInfo networkInfo = datadogContext.getNetworkInfo();
                SpanEvent.SimCarrier simCarrier = this.resolveSimCarrier(networkInfo);
                Long l = networkInfo.getStrength();
                Long l2 = networkInfo.getDownKbps();
                Long l3 = networkInfo.getUpKbps();
                SpanEvent.Client networkInfoClient = new SpanEvent.Client(simCarrier, l != null ? l.toString() : null, l2 != null ? l2.toString() : null, l3 != null ? l3.toString() : null, networkInfo.getConnectivity().toString());
                network = new SpanEvent.Network(networkInfoClient);
            } else {
                network = null;
            }
            networkInfoMeta = network;
            UserInfo userInfo = datadogContext.getUserInfo();
            usrMeta = new SpanEvent.Usr(userInfo.getId(), userInfo.getName(), userInfo.getEmail(), MapsKt.toMutableMap((Map)userInfo.getAdditionalProperties()));
            String string2 = datadogContext.getSource();
            Object object = event.getTags().get("application_id");
            if (object != null) {
                Object object2 = object;
                string = string2;
                boolean bl = false;
                application2 = new SpanEvent.Application(it instanceof String ? (String)it : null);
                string2 = string;
            } else {
                application2 = null;
            }
            Object object3 = event.getTags().get("session_id");
            if (object3 != null) {
                it = object3;
                application = application2;
                string = string2;
                boolean bl = false;
                session2 = new SpanEvent.Session(it instanceof String ? (String)it : null);
                string2 = string;
                application2 = application;
                session = session2;
            } else {
                session = null;
            }
            Object object4 = event.getTags().get("view.id");
            if (object4 != null) {
                it = object4;
                session2 = session;
                application = application2;
                string = string2;
                boolean bl = false;
                SpanEvent.View view2 = new SpanEvent.View(it instanceof String ? (String)it : null);
                string2 = string;
                application2 = application;
                session = session2;
                view = view2;
            } else {
                view = null;
            }
            SpanEvent.View view3 = view;
            SpanEvent.Session session3 = session;
            SpanEvent.Application application3 = application2;
            String string3 = string2;
            dd = new SpanEvent.Dd(string3, application3, session3, view3);
            Map<String, Object> map2 = event.getTags();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"event.tags");
            Map<String, Object> $this$mapValues$iv = map2;
            boolean $i$f$mapValues = false;
            Map<String, Object> bl = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it2;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl3 = false;
                string = it2.getValue().toString();
                map4.put(k, string);
            }
            Map tags = destination$iv$iv;
            meta = new LinkedHashMap();
            Map<String, String> map5 = event.getBaggage();
            Intrinsics.checkNotNullExpressionValue(map5, (String)"event.baggage");
            meta.putAll(map5);
            meta.putAll(tags);
            String string4 = this.resolveSpanLinks(event);
            if (string4 == null) break block9;
            String it3 = string4;
            boolean bl4 = false;
            meta.put(SPAN_LINKS_KEY, it3);
        }
        return new SpanEvent.Meta(datadogContext.getVersion(), dd, new SpanEvent.Span(), new SpanEvent.Tracer(datadogContext.getSdkVersion()), usrMeta, networkInfoMeta, meta);
    }

    /*
     * WARNING - void declaration
     */
    private final String resolveSpanLinks(DDSpan model) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        if (model.getLinks().isEmpty()) {
            return null;
        }
        List<AgentSpanLink> list = model.getLinks();
        Intrinsics.checkNotNullExpressionValue(list, (String)"model.links");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AgentSpanLink agentSpanLink = (AgentSpanLink)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(this.resolveSpanLink((AgentSpanLink)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        JsonArray initial$iv = new JsonArray();
        boolean $i$f$fold = false;
        JsonArray accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void link;
            Object item$iv$iv;
            item$iv$iv = (JsonObject)element$iv;
            JsonArray acc = accumulator$iv;
            boolean bl = false;
            acc.add((JsonElement)link);
            accumulator$iv = acc;
        }
        return accumulator$iv.toString();
    }

    private final JsonObject resolveSpanLink(AgentSpanLink link) {
        JsonObject jsonObject;
        String linkedTraceId = link.traceId().toHexString();
        String linkedSpanId = DDSpanId.toHexStringPadded(link.spanId());
        Map<String, String> map2 = link.attributes().asMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"link.attributes().asMap()");
        JsonObject attributes = this.toJson(map2);
        byte flags = link.traceFlags();
        String traceState = link.traceState();
        JsonObject $this$resolveSpanLink_u24lambda_u248 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$resolveSpanLink_u24lambda_u248.addProperty(TRACE_ID_KEY, linkedTraceId);
        $this$resolveSpanLink_u24lambda_u248.addProperty(SPAN_ID_KEY, linkedSpanId);
        $this$resolveSpanLink_u24lambda_u248.add(ATTRIBUTES_KEY, (JsonElement)attributes);
        if (flags != 0) {
            $this$resolveSpanLink_u24lambda_u248.addProperty(FLAGS_KEY, (Number)flags);
        }
        Intrinsics.checkNotNullExpressionValue((Object)traceState, (String)"traceState");
        if (((CharSequence)traceState).length() > 0) {
            $this$resolveSpanLink_u24lambda_u248.addProperty(TRACE_STATE_KEY, traceState);
        }
        JsonObject spanLink = jsonObject;
        return spanLink;
    }

    private final SpanEvent.SimCarrier resolveSimCarrier(NetworkInfo networkInfo) {
        SpanEvent.SimCarrier simCarrier;
        if (networkInfo.getCarrierId() != null || networkInfo.getCarrierName() != null) {
            Long l = networkInfo.getCarrierId();
            simCarrier = new SpanEvent.SimCarrier(l != null ? l.toString() : null, networkInfo.getCarrierName());
        } else {
            simCarrier = null;
        }
        return simCarrier;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Number> resolveMetricsFromSpanContext(DDSpan span) {
        void $this$mapValuesTo$iv$iv;
        Map<String, Object> map2 = span.getTags();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"span.tags");
        Map<String, Object> $this$filterValues$iv = map2;
        boolean $i$f$filterValues = false;
        Map<String, Object> result$iv = new LinkedHashMap();
        for (Map.Entry<String, Object> entry$iv : $this$filterValues$iv.entrySet()) {
            Object it = entry$iv.getValue();
            boolean bl = false;
            if (!(it instanceof Number)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$mapValues$iv = result$iv;
        boolean $i$f$mapValues = false;
        result$iv = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Object v = it.getValue();
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Number");
            Number number = (Number)v;
            map4.put(k, number);
        }
        return MapsKt.toMutableMap((Map)destination$iv$iv);
    }

    private final String takeLeastSignificant64Bits(String $this$takeLeastSignificant64Bits) {
        return StringsKt.takeLast((String)$this$takeLeastSignificant64Bits, (int)16);
    }

    private final JsonObject toJson(Map<String, String> map2) {
        JsonObject jsonObject = new JsonObject();
        Map<String, String> $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            String value = entry.getValue();
            jsonObject.addProperty(key, value);
        }
        return jsonObject;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/trace/internal/domain/event/CoreTracerSpanToSpanEventMapper$Companion;", "", "()V", "ATTRIBUTES_KEY", "", "FLAGS_KEY", "LEAST_SIGNIFICANT_64_BITS_AS_HEX_LENGTH", "", "SPAN_ID_KEY", "SPAN_LINKS_KEY", "TRACE_ID_KEY", "TRACE_STATE_KEY", "dd-sdk-android-trace_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

