/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.tracking;

import android.app.Activity;
import androidx.annotation.MainThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.utils.ComponentPredicateExtKt;
import com.datadog.android.rum.internal.utils.ViewUtilsKt;
import com.datadog.android.rum.tracking.AcceptAllActivities;
import com.datadog.android.rum.tracking.ActivityLifecycleTrackingStrategy;
import com.datadog.android.rum.tracking.ActivityViewTrackingStrategy;
import com.datadog.android.rum.tracking.ComponentPredicate;
import com.datadog.android.rum.tracking.ViewTrackingStrategy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0017J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0017R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/datadog/android/rum/tracking/ActivityViewTrackingStrategy;", "Lcom/datadog/android/rum/tracking/ActivityLifecycleTrackingStrategy;", "Lcom/datadog/android/rum/tracking/ViewTrackingStrategy;", "trackExtras", "", "componentPredicate", "Lcom/datadog/android/rum/tracking/ComponentPredicate;", "Landroid/app/Activity;", "(ZLcom/datadog/android/rum/tracking/ComponentPredicate;)V", "getComponentPredicate$dd_sdk_android_rum_release", "()Lcom/datadog/android/rum/tracking/ComponentPredicate;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "getExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "executor$delegate", "Lkotlin/Lazy;", "getTrackExtras$dd_sdk_android_rum_release", "()Z", "equals", "other", "", "getRumMonitor", "Lcom/datadog/android/rum/RumMonitor;", "hashCode", "", "onActivityResumed", "", "activity", "onActivityStopped", "Companion", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nActivityViewTrackingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActivityViewTrackingStrategy.kt\ncom/datadog/android/rum/tracking/ActivityViewTrackingStrategy\n+ 2 ComponentPredicateExt.kt\ncom/datadog/android/rum/internal/utils/ComponentPredicateExtKt\n*L\n1#1,110:1\n25#2,3:111\n40#2,5:114\n28#2,10:119\n25#2,13:129\n*S KotlinDebug\n*F\n+ 1 ActivityViewTrackingStrategy.kt\ncom/datadog/android/rum/tracking/ActivityViewTrackingStrategy\n*L\n48#1:111,3\n49#1:114,5\n48#1:119,10\n68#1:129,13\n*E\n"})
public final class ActivityViewTrackingStrategy
extends ActivityLifecycleTrackingStrategy
implements ViewTrackingStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean trackExtras;
    @NotNull
    private final ComponentPredicate<Activity> componentPredicate;
    @NotNull
    private final Lazy executor$delegate;
    private static final long STOP_VIEW_DELAY_MS = 200L;

    @JvmOverloads
    public ActivityViewTrackingStrategy(boolean trackExtras, @NotNull ComponentPredicate<Activity> componentPredicate) {
        Intrinsics.checkNotNullParameter(componentPredicate, (String)"componentPredicate");
        this.trackExtras = trackExtras;
        this.componentPredicate = componentPredicate;
        this.executor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ScheduledExecutorService>(this){
            final /* synthetic */ ActivityViewTrackingStrategy this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ScheduledExecutorService invoke() {
                return this.this$0.getSdkCore().createScheduledExecutorService("rum-activity-tracking");
            }
        }));
    }

    public /* synthetic */ ActivityViewTrackingStrategy(boolean bl, ComponentPredicate componentPredicate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            componentPredicate = new AcceptAllActivities();
        }
        this(bl, componentPredicate);
    }

    public final boolean getTrackExtras$dd_sdk_android_rum_release() {
        return this.trackExtras;
    }

    @NotNull
    public final ComponentPredicate<Activity> getComponentPredicate$dd_sdk_android_rum_release() {
        return this.componentPredicate;
    }

    private final ScheduledExecutorService getExecutor() {
        Lazy lazy = this.executor$delegate;
        return (ScheduledExecutorService)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @MainThread
    public void onActivityResumed(@NotNull Activity activity) {
        void $this$runIfValid$iv;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityResumed(activity);
        ComponentPredicate<Activity> componentPredicate = this.componentPredicate;
        InternalLogger internalLogger$iv = this.getInternalLogger$dd_sdk_android_rum_release();
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(activity)) {
            try {
                Activity it = activity;
                boolean bl = false;
                ComponentPredicate<Activity> $this$resolveViewName$iv = this.componentPredicate;
                boolean $i$f$resolveViewName = false;
                String customName$iv = $this$resolveViewName$iv.getViewName(activity);
                CharSequence charSequence = customName$iv;
                String viewName = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ViewUtilsKt.resolveViewUrl(activity) : customName$iv;
                Map<String, Object> attributes = this.trackExtras ? this.convertToRumAttributes(it.getIntent()) : MapsKt.emptyMap();
                RumMonitor rumMonitor2 = this.getRumMonitor();
                if (rumMonitor2 != null) {
                    rumMonitor2.startView(it, viewName, attributes);
                }
            }
            catch (Exception e$iv) {
                Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger$iv, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)ComponentPredicateExtKt.runIfValid.1.INSTANCE, (Throwable)e$iv, (boolean)false, null, (int)48, null);
            }
        }
    }

    @Override
    @MainThread
    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityStopped(activity);
        ConcurrencyExtKt.scheduleSafe((ScheduledExecutorService)this.getExecutor(), (String)"Delayed view stop", (long)200L, (TimeUnit)TimeUnit.MILLISECONDS, (InternalLogger)this.getInternalLogger$dd_sdk_android_rum_release(), () -> ActivityViewTrackingStrategy.onActivityStopped$lambda$2(this, activity));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.datadog.android.rum.tracking.ActivityViewTrackingStrategy");
        ActivityViewTrackingStrategy cfr_ignored_0 = (ActivityViewTrackingStrategy)other;
        if (this.trackExtras != ((ActivityViewTrackingStrategy)other).trackExtras) {
            return false;
        }
        return Intrinsics.areEqual(this.componentPredicate, ((ActivityViewTrackingStrategy)other).componentPredicate);
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.trackExtras);
        result = 31 * result + this.componentPredicate.hashCode();
        return result;
    }

    private final RumMonitor getRumMonitor() {
        return (RumMonitor)this.withSdkCore(getRumMonitor.1.INSTANCE);
    }

    @JvmOverloads
    public ActivityViewTrackingStrategy(boolean trackExtras) {
        this(trackExtras, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final void onActivityStopped$lambda$2(ActivityViewTrackingStrategy this$0, Activity $activity) {
        void $this$runIfValid$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$activity, (String)"$activity");
        ComponentPredicate<Activity> componentPredicate = this$0.componentPredicate;
        InternalLogger internalLogger$iv = this$0.getInternalLogger$dd_sdk_android_rum_release();
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept($activity)) {
            try {
                Activity it = $activity;
                boolean bl = false;
                RumMonitor rumMonitor2 = this$0.getRumMonitor();
                if (rumMonitor2 != null) {
                    RumMonitor.DefaultImpls.stopView$default(rumMonitor2, it, null, 2, null);
                }
            }
            catch (Exception e$iv) {
                Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger$iv, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)ComponentPredicateExtKt.runIfValid.1.INSTANCE, (Throwable)e$iv, (boolean)false, null, (int)48, null);
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/rum/tracking/ActivityViewTrackingStrategy$Companion;", "", "()V", "STOP_VIEW_DELAY_MS", "", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

