/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.resource;

import com.datadog.android.Datadog;
import com.datadog.android.api.SdkCore;
import com.datadog.android.rum.GlobalRumMonitor;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.RumResourceKind;
import com.datadog.android.rum.RumResourceMethod;
import com.datadog.android.rum.internal.domain.event.ResourceTiming;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.resource.RumResourceInputStream;
import java.io.InputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0007\u0018\u0000 52\u00020\u0001:\u00015B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001f\u001a\u00020 H\u0016J4\u0010!\u001a\u0002H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010#\u001a\u00020\u00042\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H\"0%\u00a2\u0006\u0002\b&H\u0002\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020 H\u0016J\b\u0010,\u001a\u00020\rH\u0016J\b\u0010-\u001a\u00020 H\u0016J\u0010\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/H\u0016J \u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020 2\u0006\u00101\u001a\u00020 H\u0016J\b\u00102\u001a\u00020)H\u0016J\u0010\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\tH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0015\u00a8\u00066"}, d2={"Lcom/datadog/android/rum/resource/RumResourceInputStream;", "Ljava/io/InputStream;", "delegate", "url", "", "sdkCore", "Lcom/datadog/android/api/SdkCore;", "(Ljava/io/InputStream;Ljava/lang/String;Lcom/datadog/android/api/SdkCore;)V", "callStart", "", "getDelegate", "()Ljava/io/InputStream;", "failed", "", "getFailed$dd_sdk_android_rum_release", "()Z", "setFailed$dd_sdk_android_rum_release", "(Z)V", "firstByte", "key", "getKey$dd_sdk_android_rum_release", "()Ljava/lang/String;", "lastByte", "getSdkCore", "()Lcom/datadog/android/api/SdkCore;", "size", "getSize$dd_sdk_android_rum_release", "()J", "setSize$dd_sdk_android_rum_release", "(J)V", "getUrl", "available", "", "callWithErrorTracking", "T", "errorMessage", "operation", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "close", "", "mark", "readlimit", "markSupported", "read", "b", "", "off", "len", "reset", "skip", "n", "Companion", "dd-sdk-android-rum_release"})
public final class RumResourceInputStream
extends InputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InputStream delegate;
    @NotNull
    private final String url;
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private final String key;
    private long size;
    private boolean failed;
    private long callStart;
    private long firstByte;
    private long lastByte;
    @NotNull
    private static final RumResourceMethod METHOD = RumResourceMethod.GET;
    @NotNull
    public static final String ERROR_CLOSE = "Error closing input stream";
    @NotNull
    public static final String ERROR_MARK = "Error marking input stream";
    @NotNull
    public static final String ERROR_READ = "Error reading from input stream";
    @NotNull
    public static final String ERROR_RESET = "Error resetting input stream";
    @NotNull
    public static final String ERROR_SKIP = "Error skipping bytes from input stream";

    @JvmOverloads
    public RumResourceInputStream(@NotNull InputStream delegate, @NotNull String url, @NotNull SdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        this.delegate = delegate;
        this.url = url;
        this.sdkCore = sdkCore;
        this.key = this.delegate.getClass().getSimpleName() + "@" + System.identityHashCode(this.delegate);
        RumMonitor rumMonitor2 = GlobalRumMonitor.get(this.sdkCore);
        rumMonitor2.startResource(this.key, METHOD, this.url, (Map<String, ? extends Object>)MapsKt.emptyMap());
        this.callStart = System.nanoTime();
        if (rumMonitor2 instanceof AdvancedRumMonitor) {
            ((AdvancedRumMonitor)rumMonitor2).waitForResourceTiming(this.key);
        }
    }

    public /* synthetic */ RumResourceInputStream(InputStream inputStream, String string, SdkCore sdkCore, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            sdkCore = Datadog.getInstance$default(null, (int)1, null);
        }
        this(inputStream, string, sdkCore);
    }

    @NotNull
    public final InputStream getDelegate() {
        return this.delegate;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final SdkCore getSdkCore() {
        return this.sdkCore;
    }

    @NotNull
    public final String getKey$dd_sdk_android_rum_release() {
        return this.key;
    }

    public final long getSize$dd_sdk_android_rum_release() {
        return this.size;
    }

    public final void setSize$dd_sdk_android_rum_release(long l) {
        this.size = l;
    }

    public final boolean getFailed$dd_sdk_android_rum_release() {
        return this.failed;
    }

    public final void setFailed$dd_sdk_android_rum_release(boolean bl) {
        this.failed = bl;
    }

    @Override
    public int read() {
        if (this.firstByte == 0L) {
            this.firstByte = System.nanoTime();
        }
        return ((Number)this.callWithErrorTracking(ERROR_READ, (Function1)new Function1<InputStream, Integer>(this){
            final /* synthetic */ RumResourceInputStream this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull InputStream $this$callWithErrorTracking) {
                Intrinsics.checkNotNullParameter((Object)$this$callWithErrorTracking, (String)"$this$callWithErrorTracking");
                Integer n = $this$callWithErrorTracking.read();
                RumResourceInputStream rumResourceInputStream = this.this$0;
                int it = ((Number)n).intValue();
                boolean bl = false;
                if (it >= 0) {
                    long l = rumResourceInputStream.getSize$dd_sdk_android_rum_release();
                    rumResourceInputStream.setSize$dd_sdk_android_rum_release(l + 1L);
                }
                RumResourceInputStream.access$setLastByte$p(rumResourceInputStream, System.nanoTime());
                return n;
            }
        })).intValue();
    }

    @Override
    public int read(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this.firstByte == 0L) {
            this.firstByte = System.nanoTime();
        }
        return ((Number)this.callWithErrorTracking(ERROR_READ, (Function1)new Function1<InputStream, Integer>(b, this){
            final /* synthetic */ byte[] $b;
            final /* synthetic */ RumResourceInputStream this$0;
            {
                this.$b = $b;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull InputStream $this$callWithErrorTracking) {
                Intrinsics.checkNotNullParameter((Object)$this$callWithErrorTracking, (String)"$this$callWithErrorTracking");
                Integer n = $this$callWithErrorTracking.read(this.$b);
                RumResourceInputStream rumResourceInputStream = this.this$0;
                int it = ((Number)n).intValue();
                boolean bl = false;
                if (it >= 0) {
                    rumResourceInputStream.setSize$dd_sdk_android_rum_release(rumResourceInputStream.getSize$dd_sdk_android_rum_release() + (long)it);
                }
                RumResourceInputStream.access$setLastByte$p(rumResourceInputStream, System.nanoTime());
                return n;
            }
        })).intValue();
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this.firstByte == 0L) {
            this.firstByte = System.nanoTime();
        }
        return ((Number)this.callWithErrorTracking(ERROR_READ, (Function1)new Function1<InputStream, Integer>(b, off, len, this){
            final /* synthetic */ byte[] $b;
            final /* synthetic */ int $off;
            final /* synthetic */ int $len;
            final /* synthetic */ RumResourceInputStream this$0;
            {
                this.$b = $b;
                this.$off = $off;
                this.$len = $len;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull InputStream $this$callWithErrorTracking) {
                Intrinsics.checkNotNullParameter((Object)$this$callWithErrorTracking, (String)"$this$callWithErrorTracking");
                Integer n = $this$callWithErrorTracking.read(this.$b, this.$off, this.$len);
                RumResourceInputStream rumResourceInputStream = this.this$0;
                int it = ((Number)n).intValue();
                boolean bl = false;
                if (it >= 0) {
                    rumResourceInputStream.setSize$dd_sdk_android_rum_release(rumResourceInputStream.getSize$dd_sdk_android_rum_release() + (long)it);
                }
                RumResourceInputStream.access$setLastByte$p(rumResourceInputStream, System.nanoTime());
                return n;
            }
        })).intValue();
    }

    @Override
    public int available() {
        return ((Number)this.callWithErrorTracking(ERROR_READ, available.1.INSTANCE)).intValue();
    }

    @Override
    public long skip(long n) {
        return ((Number)this.callWithErrorTracking(ERROR_SKIP, (Function1)new Function1<InputStream, Long>(n){
            final /* synthetic */ long $n;
            {
                this.$n = $n;
                super(1);
            }

            @NotNull
            public final Long invoke(@NotNull InputStream $this$callWithErrorTracking) {
                Intrinsics.checkNotNullParameter((Object)$this$callWithErrorTracking, (String)"$this$callWithErrorTracking");
                return $this$callWithErrorTracking.skip(this.$n);
            }
        })).longValue();
    }

    @Override
    public boolean markSupported() {
        return (Boolean)this.callWithErrorTracking(ERROR_READ, markSupported.1.INSTANCE);
    }

    @Override
    public void mark(int readlimit) {
        this.callWithErrorTracking(ERROR_MARK, (Function1)new Function1<InputStream, Unit>(readlimit){
            final /* synthetic */ int $readlimit;
            {
                this.$readlimit = $readlimit;
                super(1);
            }

            public final void invoke(@NotNull InputStream $this$callWithErrorTracking) {
                Intrinsics.checkNotNullParameter((Object)$this$callWithErrorTracking, (String)"$this$callWithErrorTracking");
                $this$callWithErrorTracking.mark(this.$readlimit);
            }
        });
    }

    @Override
    public void reset() {
        this.callWithErrorTracking(ERROR_RESET, reset.1.INSTANCE);
    }

    @Override
    public void close() {
        this.callWithErrorTracking(ERROR_CLOSE, (Function1)new Function1<InputStream, Unit>(this){
            final /* synthetic */ RumResourceInputStream this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull InputStream $this$callWithErrorTracking) {
                Intrinsics.checkNotNullParameter((Object)$this$callWithErrorTracking, (String)"$this$callWithErrorTracking");
                $this$callWithErrorTracking.close();
                RumMonitor monitor = GlobalRumMonitor.get(this.this$0.getSdkCore());
                AdvancedRumMonitor advancedRumMonitor = monitor instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)monitor : null;
                if (advancedRumMonitor != null) {
                    advancedRumMonitor.addResourceTiming(this.this$0.getKey$dd_sdk_android_rum_release(), new ResourceTiming(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, RumResourceInputStream.access$getFirstByte$p(this.this$0) - RumResourceInputStream.access$getCallStart$p(this.this$0), RumResourceInputStream.access$getLastByte$p(this.this$0) - RumResourceInputStream.access$getFirstByte$p(this.this$0), 255, null));
                }
                monitor.stopResource(this.this$0.getKey$dd_sdk_android_rum_release(), null, this.this$0.getSize$dd_sdk_android_rum_release(), RumResourceKind.OTHER, MapsKt.emptyMap());
            }
        });
    }

    private final <T> T callWithErrorTracking(String errorMessage, Function1<? super InputStream, ? extends T> operation) {
        try {
            return (T)operation.invoke((Object)this.delegate);
        }
        catch (Throwable e) {
            if (!this.failed) {
                this.failed = true;
                RumMonitor.DefaultImpls.stopResourceWithError$default(GlobalRumMonitor.get(this.sdkCore), this.key, null, errorMessage, RumErrorSource.SOURCE, e, null, 32, null);
            }
            throw e;
        }
    }

    @JvmOverloads
    public RumResourceInputStream(@NotNull InputStream delegate, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this(delegate, url, null, 4, null);
    }

    public static final /* synthetic */ void access$setLastByte$p(RumResourceInputStream $this, long l) {
        $this.lastByte = l;
    }

    public static final /* synthetic */ long access$getFirstByte$p(RumResourceInputStream $this) {
        return $this.firstByte;
    }

    public static final /* synthetic */ long access$getCallStart$p(RumResourceInputStream $this) {
        return $this.callStart;
    }

    public static final /* synthetic */ long access$getLastByte$p(RumResourceInputStream $this) {
        return $this.lastByte;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/datadog/android/rum/resource/RumResourceInputStream$Companion;", "", "()V", "ERROR_CLOSE", "", "ERROR_MARK", "ERROR_READ", "ERROR_RESET", "ERROR_SKIP", "METHOD", "Lcom/datadog/android/rum/RumResourceMethod;", "getMETHOD$dd_sdk_android_rum_release", "()Lcom/datadog/android/rum/RumResourceMethod;", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RumResourceMethod getMETHOD$dd_sdk_android_rum_release() {
            return METHOD;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

