/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J3\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0006\u0010\u0017\u001a\u00020\u0018J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/datadog/android/rum/model/RumPerfMetric;", "", "min", "", "max", "average", "metricMax", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "getAverage", "()Ljava/lang/Number;", "getMax", "getMetricMax", "getMin", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toJson", "Lcom/google/gson/JsonElement;", "toString", "", "Companion", "dd-sdk-android-rum_release"})
public final class RumPerfMetric {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Number min;
    @NotNull
    private final Number max;
    @NotNull
    private final Number average;
    @Nullable
    private final Number metricMax;

    public RumPerfMetric(@NotNull Number min, @NotNull Number max, @NotNull Number average, @Nullable Number metricMax) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        Intrinsics.checkNotNullParameter((Object)average, (String)"average");
        this.min = min;
        this.max = max;
        this.average = average;
        this.metricMax = metricMax;
    }

    public /* synthetic */ RumPerfMetric(Number number, Number number2, Number number3, Number number4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            number4 = null;
        }
        this(number, number2, number3, number4);
    }

    @NotNull
    public final Number getMin() {
        return this.min;
    }

    @NotNull
    public final Number getMax() {
        return this.max;
    }

    @NotNull
    public final Number getAverage() {
        return this.average;
    }

    @Nullable
    public final Number getMetricMax() {
        return this.metricMax;
    }

    @NotNull
    public final JsonElement toJson() {
        JsonObject json;
        block0: {
            json = new JsonObject();
            json.addProperty("min", this.min);
            json.addProperty("max", this.max);
            json.addProperty("average", this.average);
            Number number = this.metricMax;
            if (number == null) break block0;
            Number metricMaxNonNull = number;
            boolean bl = false;
            json.addProperty("metric_max", metricMaxNonNull);
        }
        return (JsonElement)json;
    }

    @NotNull
    public final Number component1() {
        return this.min;
    }

    @NotNull
    public final Number component2() {
        return this.max;
    }

    @NotNull
    public final Number component3() {
        return this.average;
    }

    @Nullable
    public final Number component4() {
        return this.metricMax;
    }

    @NotNull
    public final RumPerfMetric copy(@NotNull Number min, @NotNull Number max, @NotNull Number average, @Nullable Number metricMax) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        Intrinsics.checkNotNullParameter((Object)average, (String)"average");
        return new RumPerfMetric(min, max, average, metricMax);
    }

    public static /* synthetic */ RumPerfMetric copy$default(RumPerfMetric rumPerfMetric, Number number, Number number2, Number number3, Number number4, int n, Object object) {
        if ((n & 1) != 0) {
            number = rumPerfMetric.min;
        }
        if ((n & 2) != 0) {
            number2 = rumPerfMetric.max;
        }
        if ((n & 4) != 0) {
            number3 = rumPerfMetric.average;
        }
        if ((n & 8) != 0) {
            number4 = rumPerfMetric.metricMax;
        }
        return rumPerfMetric.copy(number, number2, number3, number4);
    }

    @NotNull
    public String toString() {
        return "RumPerfMetric(min=" + this.min + ", max=" + this.max + ", average=" + this.average + ", metricMax=" + this.metricMax + ")";
    }

    public int hashCode() {
        int result = this.min.hashCode();
        result = result * 31 + this.max.hashCode();
        result = result * 31 + this.average.hashCode();
        result = result * 31 + (this.metricMax == null ? 0 : this.metricMax.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RumPerfMetric)) {
            return false;
        }
        RumPerfMetric rumPerfMetric = (RumPerfMetric)other;
        if (!Intrinsics.areEqual((Object)this.min, (Object)rumPerfMetric.min)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.max, (Object)rumPerfMetric.max)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.average, (Object)rumPerfMetric.average)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.metricMax, (Object)rumPerfMetric.metricMax);
    }

    @JvmStatic
    @NotNull
    public static final RumPerfMetric fromJson(@NotNull String jsonString) throws JsonParseException {
        return Companion.fromJson(jsonString);
    }

    @JvmStatic
    @NotNull
    public static final RumPerfMetric fromJsonObject(@NotNull JsonObject jsonObject) throws JsonParseException {
        return Companion.fromJsonObject(jsonObject);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/datadog/android/rum/model/RumPerfMetric$Companion;", "", "()V", "fromJson", "Lcom/datadog/android/rum/model/RumPerfMetric;", "jsonString", "", "fromJsonObject", "jsonObject", "Lcom/google/gson/JsonObject;", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RumPerfMetric fromJson(@NotNull String jsonString) throws JsonParseException {
            Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
            try {
                JsonObject jsonObject = JsonParser.parseString((String)jsonString).getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"jsonObject");
                return this.fromJsonObject(jsonObject);
            }
            catch (IllegalStateException e) {
                throw new JsonParseException("Unable to parse json into type RumPerfMetric", (Throwable)e);
            }
        }

        @JvmStatic
        @NotNull
        public final RumPerfMetric fromJsonObject(@NotNull JsonObject jsonObject) throws JsonParseException {
            Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
            try {
                Number min = jsonObject.get("min").getAsNumber();
                Number max = jsonObject.get("max").getAsNumber();
                Number average = jsonObject.get("average").getAsNumber();
                JsonElement jsonElement = jsonObject.get("metric_max");
                Number metricMax = jsonElement != null ? jsonElement.getAsNumber() : null;
                Intrinsics.checkNotNullExpressionValue((Object)min, (String)"min");
                Intrinsics.checkNotNullExpressionValue((Object)max, (String)"max");
                Intrinsics.checkNotNullExpressionValue((Object)average, (String)"average");
                return new RumPerfMetric(min, max, average, metricMax);
            }
            catch (IllegalStateException e) {
                throw new JsonParseException("Unable to parse json into type RumPerfMetric", (Throwable)e);
            }
            catch (NumberFormatException e) {
                throw new JsonParseException("Unable to parse json into type RumPerfMetric", (Throwable)e);
            }
            catch (NullPointerException e) {
                throw new JsonParseException("Unable to parse json into type RumPerfMetric", (Throwable)e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

