/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.net;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.net.Request;
import com.datadog.android.api.net.RequestFactory;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.core.internal.utils.ByteArrayExtKt;
import com.datadog.android.rum.internal.domain.event.RumViewEventFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ4\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J0\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J*\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/datadog/android/rum/internal/net/RumRequestFactory;", "Lcom/datadog/android/api/net/RequestFactory;", "customEndpointUrl", "", "viewEventFilter", "Lcom/datadog/android/rum/internal/domain/event/RumViewEventFilter;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Ljava/lang/String;Lcom/datadog/android/rum/internal/domain/event/RumViewEventFilter;Lcom/datadog/android/api/InternalLogger;)V", "getCustomEndpointUrl$dd_sdk_android_rum_release", "()Ljava/lang/String;", "buildHeaders", "", "requestId", "clientToken", "source", "sdkVersion", "buildTags", "serviceName", "version", "env", "variant", "buildUrl", "context", "Lcom/datadog/android/api/context/DatadogContext;", "create", "Lcom/datadog/android/api/net/Request;", "batchData", "", "Lcom/datadog/android/api/storage/RawBatchEvent;", "batchMetadata", "", "Companion", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nRumRequestFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RumRequestFactory.kt\ncom/datadog/android/rum/internal/net/RumRequestFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,113:1\n1549#2:114\n1620#2,3:115\n125#3:118\n152#3,3:119\n*S KotlinDebug\n*F\n+ 1 RumRequestFactory.kt\ncom/datadog/android/rum/internal/net/RumRequestFactory\n*L\n44#1:114\n44#1:115,3\n70#1:118\n70#1:119,3\n*E\n"})
public final class RumRequestFactory
implements RequestFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String customEndpointUrl;
    @NotNull
    private final RumViewEventFilter viewEventFilter;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private static final byte[] PAYLOAD_SEPARATOR;

    public RumRequestFactory(@Nullable String customEndpointUrl, @NotNull RumViewEventFilter viewEventFilter, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)viewEventFilter, (String)"viewEventFilter");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.customEndpointUrl = customEndpointUrl;
        this.viewEventFilter = viewEventFilter;
        this.internalLogger = internalLogger;
    }

    @Nullable
    public final String getCustomEndpointUrl$dd_sdk_android_rum_release() {
        return this.customEndpointUrl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Request create(@NotNull DatadogContext context, @NotNull List<RawBatchEvent> batchData, @Nullable byte[] batchMetadata) {
        Collection<byte[]> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(batchData, (String)"batchData");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String requestId = string;
        Iterable iterable = this.viewEventFilter.filterOutRedundantViewEvents(batchData);
        Map<String, String> map = this.buildHeaders(requestId, context.getClientToken(), context.getSource(), context.getSdkVersion());
        String string2 = this.buildUrl(context);
        String string3 = "RUM Request";
        String string4 = requestId;
        boolean $i$f$map = false;
        void var7_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RawBatchEvent rawBatchEvent = (RawBatchEvent)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getData());
        }
        collection = (List)destination$iv$iv;
        String string5 = "text/plain;charset=UTF-8";
        byte[] byArray = ByteArrayExtKt.join$default((Collection)collection, (byte[])PAYLOAD_SEPARATOR, null, null, (InternalLogger)this.internalLogger, (int)6, null);
        Map<String, String> map2 = map;
        String string6 = string2;
        String string7 = string3;
        String string8 = string4;
        return new Request(string8, string7, string6, map2, byArray, string5);
    }

    /*
     * WARNING - void declaration
     */
    private final String buildUrl(DatadogContext context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ddsource", (Object)context.getSource()), TuplesKt.to((Object)"ddtags", (Object)this.buildTags(context.getService(), context.getVersion(), context.getSdkVersion(), context.getEnv(), context.getVariant()))};
        Map queryParams = MapsKt.mapOf((Pair[])pairArray);
        Object object = "%s/api/v2/rum";
        Locale locale = Locale.US;
        Object[] objectArray = new Object[1];
        String string = this.customEndpointUrl;
        if (string == null) {
            string = context.getSite().getIntakeEndpoint();
        }
        objectArray[0] = string;
        String string2 = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
        String intakeUrl = string2;
        object = queryParams;
        String string3 = intakeUrl;
        boolean $i$f$map = false;
        objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey() + "=" + it.getValue());
        }
        return string3 + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", (CharSequence)"?", null, (int)0, null, null, (int)60, null);
    }

    private final Map<String, String> buildHeaders(String requestId, String clientToken, String source, String sdkVersion) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DD-API-KEY", (Object)clientToken), TuplesKt.to((Object)"DD-EVP-ORIGIN", (Object)source), TuplesKt.to((Object)"DD-EVP-ORIGIN-VERSION", (Object)sdkVersion), TuplesKt.to((Object)"DD-REQUEST-ID", (Object)requestId)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final String buildTags(String serviceName, String version, String sdkVersion, String env, String variant) {
        Object[] objectArray = new String[]{"service:" + serviceName, "version:" + version, "sdk_version:" + sdkVersion, "env:" + env};
        List elements = CollectionsKt.mutableListOf((Object[])objectArray);
        if (((CharSequence)variant).length() > 0) {
            elements.add("variant:" + variant);
        }
        return CollectionsKt.joinToString$default((Iterable)elements, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    static {
        byte[] byArray = "\n".getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        PAYLOAD_SEPARATOR = byArray;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/rum/internal/net/RumRequestFactory$Companion;", "", "()V", "PAYLOAD_SEPARATOR", "", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

