/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.instrumentation.gestures;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.rum.GlobalRumMonitor;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesDetectorWrapper;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesUtilsKt;
import com.datadog.android.rum.internal.instrumentation.gestures.WindowCallbackWrapper;
import com.datadog.android.rum.internal.tracking.NoOpInteractionPredicate;
import com.datadog.android.rum.tracking.InteractionPredicate;
import com.datadog.android.rum.tracking.ViewAttributesProvider;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 S2\u00020\u0001:\u0001SB]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0019\u0010&\u001a\u00020'2\u000e\u0010(\u001a\n !*\u0004\u0018\u00010\r0\rH\u0096\u0001J\u0012\u0010)\u001a\u00020'2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0019\u0010,\u001a\u00020'2\u000e\u0010(\u001a\n !*\u0004\u0018\u00010+0+H\u0096\u0001J\u0019\u0010-\u001a\u00020'2\u000e\u0010(\u001a\n !*\u0004\u0018\u00010.0.H\u0096\u0001J\u0012\u0010/\u001a\u00020'2\b\u0010*\u001a\u0004\u0018\u00010\rH\u0016J\u0019\u00100\u001a\u00020'2\u000e\u0010(\u001a\n !*\u0004\u0018\u00010\r0\rH\u0096\u0001J\u0010\u00101\u001a\u0002022\u0006\u0010*\u001a\u00020+H\u0002J\b\u00103\u001a\u000202H\u0002J\u0014\u00104\u001a\u0002022\n\u00105\u001a\u000606j\u0002`7H\u0002J\u0019\u00108\u001a\u0002022\u000e\u0010(\u001a\n !*\u0004\u0018\u00010909H\u0096\u0001J\u0019\u0010:\u001a\u0002022\u000e\u0010(\u001a\n !*\u0004\u0018\u00010909H\u0096\u0001J\t\u0010;\u001a\u000202H\u0096\u0001J\t\u0010<\u001a\u000202H\u0096\u0001J\u001b\u0010=\u001a\u00020'2\u0006\u0010(\u001a\u00020>2\b\b\u0001\u0010?\u001a\u00020@H\u0096\u0001J\u0013\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010(\u001a\u00020>H\u0097\u0001J\t\u0010C\u001a\u000202H\u0096\u0001J\u0018\u0010D\u001a\u00020'2\u0006\u0010E\u001a\u00020>2\u0006\u0010F\u001a\u00020GH\u0016J\u001b\u0010H\u001a\u00020'2\u0006\u0010(\u001a\u00020>2\b\b\u0001\u0010?\u001a\u00020@H\u0096\u0001J\u001b\u0010I\u001a\u0002022\u0006\u0010(\u001a\u00020>2\b\b\u0001\u0010?\u001a\u00020@H\u0096\u0001J'\u0010J\u001a\u00020'2\u0006\u0010(\u001a\u00020>2\n\b\u0001\u0010?\u001a\u0004\u0018\u00010B2\b\b\u0001\u0010K\u001a\u00020@H\u0096\u0001J\t\u0010L\u001a\u00020'H\u0096\u0001J\u0019\u0010L\u001a\u00020'2\u000e\u0010(\u001a\n !*\u0004\u0018\u00010M0MH\u0096\u0001J\u0019\u0010N\u001a\u0002022\u000e\u0010(\u001a\n !*\u0004\u0018\u00010O0OH\u0096\u0001J\u0011\u0010P\u001a\u0002022\u0006\u0010(\u001a\u00020'H\u0096\u0001J\u001b\u0010Q\u001a\u0004\u0018\u0001092\u000e\u0010(\u001a\n !*\u0004\u0018\u00010R0RH\u0097\u0001J#\u0010Q\u001a\u0004\u0018\u0001092\u000e\u0010(\u001a\n !*\u0004\u0018\u00010R0R2\u0006\u0010?\u001a\u00020>H\u0097\u0001R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001dR\"\u0010\u001f\u001a\u0010\u0012\f\u0012\n !*\u0004\u0018\u00010\u00030\u00030 X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006T"}, d2={"Lcom/datadog/android/rum/internal/instrumentation/gestures/WindowCallbackWrapper;", "Landroid/view/Window$Callback;", "window", "Landroid/view/Window;", "sdkCore", "Lcom/datadog/android/api/SdkCore;", "wrappedCallback", "gesturesDetector", "Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesDetectorWrapper;", "interactionPredicate", "Lcom/datadog/android/rum/tracking/InteractionPredicate;", "copyEvent", "Lkotlin/Function1;", "Landroid/view/MotionEvent;", "targetAttributesProviders", "", "Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Landroid/view/Window;Lcom/datadog/android/api/SdkCore;Landroid/view/Window$Callback;Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesDetectorWrapper;Lcom/datadog/android/rum/tracking/InteractionPredicate;Lkotlin/jvm/functions/Function1;[Lcom/datadog/android/rum/tracking/ViewAttributesProvider;Lcom/datadog/android/api/InternalLogger;)V", "getCopyEvent", "()Lkotlin/jvm/functions/Function1;", "getInteractionPredicate", "()Lcom/datadog/android/rum/tracking/InteractionPredicate;", "getInternalLogger", "()Lcom/datadog/android/api/InternalLogger;", "getSdkCore", "()Lcom/datadog/android/api/SdkCore;", "getTargetAttributesProviders", "()[Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "[Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "windowReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "getWindowReference$dd_sdk_android_rum_release", "()Ljava/lang/ref/WeakReference;", "getWrappedCallback", "()Landroid/view/Window$Callback;", "dispatchGenericMotionEvent", "", "p0", "dispatchKeyEvent", "event", "Landroid/view/KeyEvent;", "dispatchKeyShortcutEvent", "dispatchPopulateAccessibilityEvent", "Landroid/view/accessibility/AccessibilityEvent;", "dispatchTouchEvent", "dispatchTrackballEvent", "handleBackEvent", "", "handleRemoteControlActionEvent", "logOrRethrowWrappedCallbackException", "e", "Ljava/lang/NullPointerException;", "Lkotlin/NullPointerException;", "onActionModeFinished", "Landroid/view/ActionMode;", "onActionModeStarted", "onAttachedToWindow", "onContentChanged", "onCreatePanelMenu", "", "p1", "Landroid/view/Menu;", "onCreatePanelView", "Landroid/view/View;", "onDetachedFromWindow", "onMenuItemSelected", "featureId", "item", "Landroid/view/MenuItem;", "onMenuOpened", "onPanelClosed", "onPreparePanel", "p2", "onSearchRequested", "Landroid/view/SearchEvent;", "onWindowAttributesChanged", "Landroid/view/WindowManager$LayoutParams;", "onWindowFocusChanged", "onWindowStartingActionMode", "Landroid/view/ActionMode$Callback;", "Companion", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nWindowCallbackWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowCallbackWrapper.kt\ncom/datadog/android/rum/internal/instrumentation/gestures/WindowCallbackWrapper\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,180:1\n26#2:181\n13579#3,2:182\n*S KotlinDebug\n*F\n+ 1 WindowCallbackWrapper.kt\ncom/datadog/android/rum/internal/instrumentation/gestures/WindowCallbackWrapper\n*L\n35#1:181\n132#1:182,2\n*E\n"})
public final class WindowCallbackWrapper
implements Window.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private final Window.Callback wrappedCallback;
    @NotNull
    private final GesturesDetectorWrapper gesturesDetector;
    @NotNull
    private final InteractionPredicate interactionPredicate;
    @NotNull
    private final Function1<MotionEvent, MotionEvent> copyEvent;
    @NotNull
    private final ViewAttributesProvider[] targetAttributesProviders;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final WeakReference<Window> windowReference;
    @NotNull
    public static final String BACK_DEFAULT_TARGET_NAME = "back";
    public static final boolean EVENT_CONSUMED = true;

    public WindowCallbackWrapper(@NotNull Window window, @NotNull SdkCore sdkCore, @NotNull Window.Callback wrappedCallback, @NotNull GesturesDetectorWrapper gesturesDetector, @NotNull InteractionPredicate interactionPredicate, @NotNull Function1<? super MotionEvent, MotionEvent> copyEvent, @NotNull ViewAttributesProvider[] targetAttributesProviders, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)wrappedCallback, (String)"wrappedCallback");
        Intrinsics.checkNotNullParameter((Object)gesturesDetector, (String)"gesturesDetector");
        Intrinsics.checkNotNullParameter((Object)interactionPredicate, (String)"interactionPredicate");
        Intrinsics.checkNotNullParameter(copyEvent, (String)"copyEvent");
        Intrinsics.checkNotNullParameter((Object)targetAttributesProviders, (String)"targetAttributesProviders");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.sdkCore = sdkCore;
        this.wrappedCallback = wrappedCallback;
        this.gesturesDetector = gesturesDetector;
        this.interactionPredicate = interactionPredicate;
        this.copyEvent = copyEvent;
        this.targetAttributesProviders = targetAttributesProviders;
        this.internalLogger = internalLogger;
        this.windowReference = new WeakReference<Window>(window);
    }

    public /* synthetic */ WindowCallbackWrapper(Window window, SdkCore sdkCore, Window.Callback callback, GesturesDetectorWrapper gesturesDetectorWrapper, InteractionPredicate interactionPredicate, Function1 function1, ViewAttributesProvider[] viewAttributesProviderArray, InternalLogger internalLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            interactionPredicate = new NoOpInteractionPredicate();
        }
        if ((n & 0x20) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 0x40) != 0) {
            boolean $i$f$emptyArray = false;
            viewAttributesProviderArray = new ViewAttributesProvider[]{};
        }
        this(window, sdkCore, callback, gesturesDetectorWrapper, interactionPredicate, (Function1<? super MotionEvent, MotionEvent>)function1, viewAttributesProviderArray, internalLogger);
    }

    @NotNull
    public final SdkCore getSdkCore() {
        return this.sdkCore;
    }

    @NotNull
    public final Window.Callback getWrappedCallback() {
        return this.wrappedCallback;
    }

    @NotNull
    public final InteractionPredicate getInteractionPredicate() {
        return this.interactionPredicate;
    }

    @NotNull
    public final Function1<MotionEvent, MotionEvent> getCopyEvent() {
        return this.copyEvent;
    }

    @NotNull
    public final ViewAttributesProvider[] getTargetAttributesProviders() {
        return this.targetAttributesProviders;
    }

    @NotNull
    public final InternalLogger getInternalLogger() {
        return this.internalLogger;
    }

    public boolean dispatchGenericMotionEvent(MotionEvent p0) {
        return this.wrappedCallback.dispatchGenericMotionEvent(p0);
    }

    public boolean dispatchKeyShortcutEvent(KeyEvent p0) {
        return this.wrappedCallback.dispatchKeyShortcutEvent(p0);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent p0) {
        return this.wrappedCallback.dispatchPopulateAccessibilityEvent(p0);
    }

    public boolean dispatchTrackballEvent(MotionEvent p0) {
        return this.wrappedCallback.dispatchTrackballEvent(p0);
    }

    public void onActionModeFinished(ActionMode p0) {
        this.wrappedCallback.onActionModeFinished(p0);
    }

    public void onActionModeStarted(ActionMode p0) {
        this.wrappedCallback.onActionModeStarted(p0);
    }

    public void onAttachedToWindow() {
        this.wrappedCallback.onAttachedToWindow();
    }

    public void onContentChanged() {
        this.wrappedCallback.onContentChanged();
    }

    public boolean onCreatePanelMenu(int p0, @NonNull @NotNull Menu p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return this.wrappedCallback.onCreatePanelMenu(p0, p1);
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public View onCreatePanelView(int p0) {
        return this.wrappedCallback.onCreatePanelView(p0);
    }

    public void onDetachedFromWindow() {
        this.wrappedCallback.onDetachedFromWindow();
    }

    public boolean onMenuOpened(int p0, @NonNull @NotNull Menu p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return this.wrappedCallback.onMenuOpened(p0, p1);
    }

    public void onPanelClosed(int p0, @NonNull @NotNull Menu p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        this.wrappedCallback.onPanelClosed(p0, p1);
    }

    public boolean onPreparePanel(int p0, @Nullable @org.jetbrains.annotations.Nullable View p1, @NonNull @NotNull Menu p2) {
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return this.wrappedCallback.onPreparePanel(p0, p1, p2);
    }

    public boolean onSearchRequested() {
        return this.wrappedCallback.onSearchRequested();
    }

    public boolean onSearchRequested(SearchEvent p0) {
        return this.wrappedCallback.onSearchRequested(p0);
    }

    public void onWindowAttributesChanged(WindowManager.LayoutParams p0) {
        this.wrappedCallback.onWindowAttributesChanged(p0);
    }

    public void onWindowFocusChanged(boolean p0) {
        this.wrappedCallback.onWindowFocusChanged(p0);
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public ActionMode onWindowStartingActionMode(ActionMode.Callback p0) {
        return this.wrappedCallback.onWindowStartingActionMode(p0);
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public ActionMode onWindowStartingActionMode(ActionMode.Callback p0, int p1) {
        return this.wrappedCallback.onWindowStartingActionMode(p0, p1);
    }

    @NotNull
    public final WeakReference<Window> getWindowReference$dd_sdk_android_rum_release() {
        return this.windowReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchTouchEvent(@org.jetbrains.annotations.Nullable MotionEvent event) {
        boolean bl;
        if (event != null) {
            MotionEvent copy = (MotionEvent)this.copyEvent.invoke((Object)event);
            try {
                this.gesturesDetector.onTouchEvent(copy);
            }
            catch (Exception e) {
                Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)dispatchTouchEvent.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            }
            finally {
                copy.recycle();
            }
        } else {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)dispatchTouchEvent.2.INSTANCE, null, (boolean)false, null, (int)56, null);
        }
        try {
            bl = this.wrappedCallback.dispatchTouchEvent(event);
        }
        catch (NullPointerException e) {
            this.logOrRethrowWrappedCallbackException(e);
            bl = true;
        }
        return bl;
    }

    public boolean onMenuItemSelected(int featureId, @NotNull MenuItem item) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Window window = (Window)this.windowReference.get();
        String resourceId = GesturesUtilsKt.resourceIdName((Context)(window != null ? window.getContext() : null), item.getItemId());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"action.target.classname", (Object)item.getClass().getCanonicalName()), TuplesKt.to((Object)"action.target.resource_id", (Object)resourceId), TuplesKt.to((Object)"action.target.title", (Object)item.getTitle())};
        Map attributes = MapsKt.mutableMapOf((Pair[])pairArray);
        GlobalRumMonitor.get(this.sdkCore).addAction(RumActionType.TAP, GesturesUtilsKt.resolveTargetName(this.interactionPredicate, item), attributes);
        try {
            bl = this.wrappedCallback.onMenuItemSelected(featureId, item);
        }
        catch (NullPointerException e) {
            this.logOrRethrowWrappedCallbackException(e);
            bl = true;
        }
        return bl;
    }

    public boolean dispatchKeyEvent(@org.jetbrains.annotations.Nullable KeyEvent event) {
        boolean bl;
        if (event == null) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)dispatchKeyEvent.1.INSTANCE, null, (boolean)false, null, (int)56, null);
        } else if (event.getKeyCode() == 4 && event.getAction() == 1) {
            this.handleBackEvent(event);
        } else if (event.getKeyCode() == 23 && event.getAction() == 1) {
            this.handleRemoteControlActionEvent();
        }
        try {
            bl = this.wrappedCallback.dispatchKeyEvent(event);
        }
        catch (NullPointerException e) {
            this.logOrRethrowWrappedCallbackException(e);
            bl = true;
        }
        return bl;
    }

    private final void handleRemoteControlActionEvent() {
        block1: {
            Window window = (Window)this.windowReference.get();
            Window window2 = window;
            if (window2 == null || (window2 = window2.getCurrentFocus()) == null) break block1;
            Window it = window2;
            boolean bl = false;
            String resourceIdName = GesturesUtilsKt.resourceIdName(window.getContext(), it.getId());
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"action.target.classname", (Object)GesturesUtilsKt.targetClassName((View)it)), TuplesKt.to((Object)"action.target.resource_id", (Object)resourceIdName)};
            Map attributes = MapsKt.mutableMapOf((Pair[])pairArray);
            ViewAttributesProvider[] $this$forEach$iv = this.targetAttributesProviders;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                ViewAttributesProvider element$iv;
                ViewAttributesProvider provider = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                provider.extractAttributes((View)it, attributes);
            }
            String targetName = GesturesUtilsKt.resolveTargetName(this.interactionPredicate, it);
            GlobalRumMonitor.get(this.sdkCore).addAction(RumActionType.CLICK, targetName, attributes);
        }
    }

    private final void handleBackEvent(KeyEvent event) {
        String customTargetName = this.interactionPredicate.getTargetName(event);
        CharSequence charSequence = customTargetName;
        String targetName = charSequence == null || charSequence.length() == 0 ? BACK_DEFAULT_TARGET_NAME : customTargetName;
        GlobalRumMonitor.get(this.sdkCore).addAction(RumActionType.BACK, targetName, MapsKt.emptyMap());
    }

    private final void logOrRethrowWrappedCallbackException(NullPointerException e) {
        String string = e.getMessage();
        if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Parameter specified as non-null is null", (boolean)false, (int)2, null) : false)) {
            throw e;
        }
        InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)logOrRethrowWrappedCallbackException.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/rum/internal/instrumentation/gestures/WindowCallbackWrapper$Companion;", "", "()V", "BACK_DEFAULT_TARGET_NAME", "", "EVENT_CONSUMED", "", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

