/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.instrumentation.gestures;

import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import com.datadog.android.core.internal.utils.NumberExtKt;
import com.datadog.android.rum.tracking.InteractionPredicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0016\u0010\t\u001a\u00020\u0001*\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\fH\u0000\u00a8\u0006\r"}, d2={"idAsStringHexa", "", "id", "", "resolveTargetName", "interactionPredicate", "Lcom/datadog/android/rum/tracking/InteractionPredicate;", "target", "", "resourceIdName", "Landroid/content/Context;", "targetClassName", "Landroid/view/View;", "dd-sdk-android-rum_release"})
public final class GesturesUtilsKt {
    @NotNull
    public static final String resolveTargetName(@NotNull InteractionPredicate interactionPredicate, @NotNull Object target) {
        Intrinsics.checkNotNullParameter((Object)interactionPredicate, (String)"interactionPredicate");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String customTargetName = interactionPredicate.getTargetName(target);
        CharSequence charSequence = customTargetName;
        return !(charSequence == null || charSequence.length() == 0) ? customTargetName : "";
    }

    @NotNull
    public static final String resourceIdName(@Nullable Context $this$resourceIdName, int id) {
        String string;
        try {
            Context context = $this$resourceIdName;
            string = context != null && (context = context.getResources()) != null ? context.getResourceEntryName(id) : null;
            string = string == null ? GesturesUtilsKt.idAsStringHexa(id) : string;
        }
        catch (Resources.NotFoundException e) {
            string = GesturesUtilsKt.idAsStringHexa(id);
        }
        return string;
    }

    @NotNull
    public static final String targetClassName(@NotNull View $this$targetClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$targetClassName, (String)"<this>");
        String string = $this$targetClassName.getClass().getCanonicalName();
        if (string == null) {
            String string2 = $this$targetClassName.getClass().getSimpleName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.javaClass.simpleName");
        }
        return string;
    }

    private static final String idAsStringHexa(int id) {
        return "0x" + NumberExtKt.toHexString((int)id);
    }
}

