/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.instrumentation.gestures;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AbsListView;
import android.widget.ScrollView;
import androidx.core.view.ScrollingView;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.rum.GlobalRumMonitor;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.instrumentation.gestures.GestureListenerCompat;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesListener;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesUtilsKt;
import com.datadog.android.rum.internal.tracking.NoOpInteractionPredicate;
import com.datadog.android.rum.tracking.InteractionPredicate;
import com.datadog.android.rum.tracking.ViewAttributesProvider;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\b\b\u0000\u0018\u0000 S2\u00020\u0001:\u0001SBK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u001d2\u0006\u0010$\u001a\u00020%H\u0002J\"\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010\u001d2\u0006\u0010$\u001a\u00020%H\u0002J\u001a\u0010(\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u001d2\u0006\u0010$\u001a\u00020%H\u0002J\"\u0010)\u001a\u0004\u0018\u00010\u001d2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u0018H\u0002J\"\u0010,\u001a\u0004\u0018\u00010\u001d2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u0018H\u0002J\u001a\u0010-\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u001d2\u0006\u0010.\u001a\u00020%H\u0002J6\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u0002012\u0006\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00182\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001d032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u00104\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00182\u0006\u00105\u001a\u00020\u0014H\u0002J\u0010\u00106\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001dH\u0002J\u0010\u00107\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001dH\u0002J\u0010\u00108\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001dH\u0002J\u0010\u00109\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001dH\u0002J\u0010\u0010:\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020%H\u0016J*\u0010;\u001a\u00020\u001f2\b\u0010<\u001a\u0004\u0018\u00010%2\u0006\u0010=\u001a\u00020%2\u0006\u0010>\u001a\u00020\u00182\u0006\u0010?\u001a\u00020\u0018H\u0016J\u0010\u0010@\u001a\u00020\"2\u0006\u0010.\u001a\u00020%H\u0016J*\u0010A\u001a\u00020\u001f2\b\u0010<\u001a\u0004\u0018\u00010%2\u0006\u0010B\u001a\u00020%2\u0006\u0010C\u001a\u00020\u00182\u0006\u0010D\u001a\u00020\u0018H\u0016J\u0010\u0010E\u001a\u00020\"2\u0006\u0010.\u001a\u00020%H\u0016J\u0010\u0010F\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020%H\u0016J\u000e\u0010G\u001a\u00020\"2\u0006\u0010H\u001a\u00020%J\b\u0010I\u001a\u00020\"H\u0002J0\u0010J\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010L0K2\u0006\u0010M\u001a\u00020\u001d2\u0006\u0010N\u001a\u00020\u00162\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0010\u0010O\u001a\u00020\u00162\u0006\u0010P\u001a\u00020%H\u0002J\u0010\u0010Q\u001a\u00020\"2\u0006\u0010R\u001a\u00020\u001dH\u0002R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\u00020\u001f*\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 \u00a8\u0006T"}, d2={"Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesListener;", "Lcom/datadog/android/rum/internal/instrumentation/gestures/GestureListenerCompat;", "sdkCore", "Lcom/datadog/android/api/SdkCore;", "windowReference", "Ljava/lang/ref/WeakReference;", "Landroid/view/Window;", "attributesProviders", "", "Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "interactionPredicate", "Lcom/datadog/android/rum/tracking/InteractionPredicate;", "contextRef", "Ljava/lang/ref/Reference;", "Landroid/content/Context;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/SdkCore;Ljava/lang/ref/WeakReference;[Lcom/datadog/android/rum/tracking/ViewAttributesProvider;Lcom/datadog/android/rum/tracking/InteractionPredicate;Ljava/lang/ref/Reference;Lcom/datadog/android/api/InternalLogger;)V", "[Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "coordinatesContainer", "", "gestureDirection", "", "onTouchDownXPos", "", "onTouchDownYPos", "scrollEventType", "Lcom/datadog/android/rum/RumActionType;", "scrollTargetReference", "Landroid/view/View;", "isVisible", "", "(Landroid/view/View;)Z", "closeScrollAsTap", "", "decorView", "onUpEvent", "Landroid/view/MotionEvent;", "closeScrollOrSwipeEvent", "type", "closeScrollOrSwipeEventIfAny", "findTargetForScroll", "x", "y", "findTargetForTap", "handleTapUp", "e", "handleViewGroup", "view", "Landroid/view/ViewGroup;", "stack", "Ljava/util/LinkedList;", "hitTest", "container", "isJetpackComposeView", "isScrollableView", "isValidScrollableTarget", "isValidTapTarget", "onDown", "onFling", "startDownEvent", "endUpEvent", "velocityX", "velocityY", "onLongPress", "onScroll", "currentMoveEvent", "distanceX", "distanceY", "onShowPress", "onSingleTapUp", "onUp", "event", "resetScrollEventParameters", "resolveAttributes", "", "", "scrollTarget", "targetId", "resolveGestureDirection", "endEvent", "sendTapEventWithTarget", "target", "Companion", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nGesturesListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GesturesListener.kt\ncom/datadog/android/rum/internal/instrumentation/gestures/GesturesListener\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,372:1\n26#2:373\n1#3:374\n13579#4,2:375\n13579#4,2:377\n*S KotlinDebug\n*F\n+ 1 GesturesListener.kt\ncom/datadog/android/rum/internal/instrumentation/gestures/GesturesListener\n*L\n34#1:373\n173#1:375,2\n201#1:377,2\n*E\n"})
public final class GesturesListener
extends GestureListenerCompat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private final WeakReference<Window> windowReference;
    @NotNull
    private final ViewAttributesProvider[] attributesProviders;
    @NotNull
    private final InteractionPredicate interactionPredicate;
    @NotNull
    private final Reference<Context> contextRef;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final int[] coordinatesContainer;
    @Nullable
    private RumActionType scrollEventType;
    @NotNull
    private String gestureDirection;
    @NotNull
    private WeakReference<View> scrollTargetReference;
    private float onTouchDownXPos;
    private float onTouchDownYPos;
    @NotNull
    public static final String SCROLL_DIRECTION_LEFT = "left";
    @NotNull
    public static final String SCROLL_DIRECTION_RIGHT = "right";
    @NotNull
    public static final String SCROLL_DIRECTION_UP = "up";
    @NotNull
    public static final String SCROLL_DIRECTION_DOWN = "down";
    @NotNull
    private static final String MSG_NO_TARGET_TAP = "We could not find a valid target for the TAP event. The DecorView was empty and either transparent or not clickable for this Activity.";
    @NotNull
    private static final String MSG_NO_TARGET_SCROLL_SWIPE = "We could not find a valid target for the SCROLL or SWIPE event. The DecorView was empty and either transparent or not clickable for this Activity.";

    public GesturesListener(@NotNull SdkCore sdkCore, @NotNull WeakReference<Window> windowReference, @NotNull ViewAttributesProvider[] attributesProviders, @NotNull InteractionPredicate interactionPredicate, @NotNull Reference<Context> contextRef, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(windowReference, (String)"windowReference");
        Intrinsics.checkNotNullParameter((Object)attributesProviders, (String)"attributesProviders");
        Intrinsics.checkNotNullParameter((Object)interactionPredicate, (String)"interactionPredicate");
        Intrinsics.checkNotNullParameter(contextRef, (String)"contextRef");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.sdkCore = sdkCore;
        this.windowReference = windowReference;
        this.attributesProviders = attributesProviders;
        this.interactionPredicate = interactionPredicate;
        this.contextRef = contextRef;
        this.internalLogger = internalLogger;
        this.coordinatesContainer = new int[2];
        this.gestureDirection = "";
        this.scrollTargetReference = new WeakReference<Object>(null);
    }

    public /* synthetic */ GesturesListener(SdkCore sdkCore, WeakReference weakReference, ViewAttributesProvider[] viewAttributesProviderArray, InteractionPredicate interactionPredicate, Reference reference, InternalLogger internalLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            boolean $i$f$emptyArray = false;
            viewAttributesProviderArray = new ViewAttributesProvider[]{};
        }
        if ((n & 8) != 0) {
            interactionPredicate = new NoOpInteractionPredicate();
        }
        this(sdkCore, weakReference, viewAttributesProviderArray, interactionPredicate, reference, internalLogger);
    }

    public void onShowPress(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    public boolean onSingleTapUp(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Window window = (Window)this.windowReference.get();
        View decorView = window != null ? window.getDecorView() : null;
        this.handleTapUp(decorView, e);
        return false;
    }

    public boolean onDown(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.resetScrollEventParameters();
        this.onTouchDownXPos = e.getX();
        this.onTouchDownYPos = e.getY();
        return false;
    }

    public final void onUp(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Window window = (Window)this.windowReference.get();
        View decorView = window != null ? window.getDecorView() : null;
        this.closeScrollOrSwipeEventIfAny(decorView, event);
        this.resetScrollEventParameters();
    }

    @Override
    public boolean onFling(@Nullable MotionEvent startDownEvent, @NotNull MotionEvent endUpEvent, float velocityX, float velocityY) {
        Intrinsics.checkNotNullParameter((Object)endUpEvent, (String)"endUpEvent");
        this.scrollEventType = RumActionType.SWIPE;
        return false;
    }

    @Override
    public boolean onScroll(@Nullable MotionEvent startDownEvent, @NotNull MotionEvent currentMoveEvent, float distanceX, float distanceY) {
        Intrinsics.checkNotNullParameter((Object)currentMoveEvent, (String)"currentMoveEvent");
        RumMonitor rumMonitor2 = GlobalRumMonitor.get(this.sdkCore);
        Window window = (Window)this.windowReference.get();
        if (window == null || (window = window.getDecorView()) == null) {
            return false;
        }
        Window decorView = window;
        if (this.scrollEventType == null) {
            View scrollTarget;
            View view;
            MotionEvent motionEvent = startDownEvent;
            if (motionEvent != null) {
                MotionEvent it = motionEvent;
                boolean bl = false;
                view = this.findTargetForScroll((View)decorView, it.getX(), startDownEvent.getY());
            } else {
                view = scrollTarget = null;
            }
            if (scrollTarget != null) {
                this.scrollTargetReference = new WeakReference<View>(scrollTarget);
                String targetId = GesturesUtilsKt.resourceIdName(this.contextRef.get(), scrollTarget.getId());
                Map<String, Object> attributes = this.resolveAttributes(scrollTarget, targetId, null);
                rumMonitor2.startAction(RumActionType.SCROLL, GesturesUtilsKt.resolveTargetName(this.interactionPredicate, scrollTarget), attributes);
                this.scrollEventType = RumActionType.SCROLL;
            } else {
                return false;
            }
        }
        return false;
    }

    public void onLongPress(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    private final void closeScrollOrSwipeEventIfAny(View decorView, MotionEvent onUpEvent) {
        RumActionType type = this.scrollEventType;
        if (type == null) {
            this.closeScrollAsTap(decorView, onUpEvent);
        } else {
            this.closeScrollOrSwipeEvent(type, decorView, onUpEvent);
        }
    }

    private final void closeScrollAsTap(View decorView, MotionEvent onUpEvent) {
        View upTarget;
        View downTarget;
        if (decorView != null && (downTarget = this.findTargetForTap(decorView, this.onTouchDownXPos, this.onTouchDownYPos)) == (upTarget = this.findTargetForTap(decorView, onUpEvent.getX(), onUpEvent.getY())) && downTarget != null) {
            this.sendTapEventWithTarget(downTarget);
        }
    }

    private final void closeScrollOrSwipeEvent(RumActionType type, View decorView, MotionEvent onUpEvent) {
        RumMonitor registeredRumMonitor = GlobalRumMonitor.get(this.sdkCore);
        View scrollTarget = (View)this.scrollTargetReference.get();
        if (decorView == null || scrollTarget == null) {
            return;
        }
        String targetId = GesturesUtilsKt.resourceIdName(this.contextRef.get(), scrollTarget.getId());
        Map<String, Object> attributes = this.resolveAttributes(scrollTarget, targetId, onUpEvent);
        registeredRumMonitor.stopAction(type, GesturesUtilsKt.resolveTargetName(this.interactionPredicate, scrollTarget), attributes);
    }

    private final Map<String, Object> resolveAttributes(View scrollTarget, String targetId, MotionEvent onUpEvent) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"action.target.classname", (Object)GesturesUtilsKt.targetClassName(scrollTarget)), TuplesKt.to((Object)"action.target.resource_id", (Object)targetId)};
        Map attributes = MapsKt.mutableMapOf((Pair[])pairArray);
        if (onUpEvent != null) {
            this.gestureDirection = this.resolveGestureDirection(onUpEvent);
            attributes.put("action.gesture.direction", this.gestureDirection);
        }
        ViewAttributesProvider[] $this$forEach$iv = this.attributesProviders;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ViewAttributesProvider element$iv;
            ViewAttributesProvider it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.extractAttributes(scrollTarget, attributes);
        }
        return attributes;
    }

    private final void resetScrollEventParameters() {
        this.scrollTargetReference.clear();
        this.scrollEventType = null;
        this.gestureDirection = "";
        this.onTouchDownYPos = 0.0f;
        this.onTouchDownXPos = 0.0f;
    }

    private final void handleTapUp(View decorView, MotionEvent e) {
        block1: {
            if (decorView == null) break block1;
            View view = this.findTargetForTap(decorView, e.getX(), e.getY());
            if (view != null) {
                View target = view;
                boolean bl = false;
                this.sendTapEventWithTarget(target);
            }
        }
    }

    private final void sendTapEventWithTarget(View target) {
        String targetId = GesturesUtilsKt.resourceIdName(this.contextRef.get(), target.getId());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"action.target.classname", (Object)GesturesUtilsKt.targetClassName(target)), TuplesKt.to((Object)"action.target.resource_id", (Object)targetId)};
        Map attributes = MapsKt.mutableMapOf((Pair[])pairArray);
        ViewAttributesProvider[] $this$forEach$iv = this.attributesProviders;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ViewAttributesProvider element$iv;
            ViewAttributesProvider it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.extractAttributes(target, attributes);
        }
        GlobalRumMonitor.get(this.sdkCore).addAction(RumActionType.TAP, GesturesUtilsKt.resolveTargetName(this.interactionPredicate, target), attributes);
    }

    private final View findTargetForTap(View decorView, float x, float y) {
        LinkedList<View> queue = new LinkedList<View>();
        queue.addFirst(decorView);
        View target = null;
        boolean notifyMissingTarget = true;
        while (!((Collection)queue).isEmpty()) {
            View view = (View)queue.removeFirst();
            if (queue.isEmpty()) {
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
                if (this.isJetpackComposeView(view)) {
                    notifyMissingTarget = false;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
            if (this.isValidTapTarget(view)) {
                target = view;
            }
            if (!(view instanceof ViewGroup)) continue;
            this.handleViewGroup((ViewGroup)view, x, y, queue, this.coordinatesContainer);
        }
        if (target == null && notifyMissingTarget) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)findTargetForTap.1.INSTANCE, null, (boolean)false, null, (int)56, null);
        }
        return target;
    }

    private final View findTargetForScroll(View decorView, float x, float y) {
        LinkedList<View> queue = new LinkedList<View>();
        queue.add(decorView);
        boolean notifyMissingTarget = true;
        while (!((Collection)queue).isEmpty()) {
            View view = (View)queue.removeFirst();
            if (queue.isEmpty()) {
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
                if (this.isJetpackComposeView(view)) {
                    notifyMissingTarget = false;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
            if (this.isValidScrollableTarget(view)) {
                return view;
            }
            if (!(view instanceof ViewGroup)) continue;
            this.handleViewGroup((ViewGroup)view, x, y, queue, this.coordinatesContainer);
        }
        if (notifyMissingTarget) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)findTargetForScroll.1.INSTANCE, null, (boolean)false, null, (int)56, null);
        }
        return null;
    }

    private final void handleViewGroup(ViewGroup view, float x, float y, LinkedList<View> stack, int[] coordinatesContainer) {
        if (!this.isVisible((View)view)) {
            return;
        }
        int n = view.getChildCount();
        for (int i = 0; i < n; ++i) {
            View child = view.getChildAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
            if (!this.hitTest(child, x, y, coordinatesContainer)) continue;
            stack.add(child);
        }
    }

    private final boolean isValidTapTarget(View view) {
        return view.isClickable() && this.isVisible(view);
    }

    private final boolean isValidScrollableTarget(View view) {
        return this.isVisible(view) && this.isScrollableView(view);
    }

    private final boolean isScrollableView(View view) {
        return ScrollingView.class.isAssignableFrom(view.getClass()) || AbsListView.class.isAssignableFrom(view.getClass()) || ScrollView.class.isAssignableFrom(view.getClass());
    }

    private final boolean hitTest(View view, float x, float y, int[] container) {
        view.getLocationInWindow(container);
        int vx = container[0];
        int vy = container[1];
        int w = view.getWidth();
        int h = view.getHeight();
        return !(x < (float)vx || x > (float)(vx + w) || y < (float)vy || y > (float)(vy + h));
    }

    private final String resolveGestureDirection(MotionEvent endEvent) {
        float diffX = endEvent.getX() - this.onTouchDownXPos;
        float diffY = endEvent.getY() - this.onTouchDownYPos;
        return Math.abs(diffX) > Math.abs(diffY) ? (diffX > 0.0f ? SCROLL_DIRECTION_RIGHT : SCROLL_DIRECTION_LEFT) : (diffY > 0.0f ? SCROLL_DIRECTION_DOWN : SCROLL_DIRECTION_UP);
    }

    private final boolean isJetpackComposeView(View view) {
        String string = view.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"view::class.java.name");
        return StringsKt.startsWith$default((String)string, (String)"androidx.compose.ui.platform.ComposeView", (boolean)false, (int)2, null);
    }

    private final boolean isVisible(View $this$isVisible) {
        return $this$isVisible.getVisibility() == 0;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesListener$Companion;", "", "()V", "MSG_NO_TARGET_SCROLL_SWIPE", "", "getMSG_NO_TARGET_SCROLL_SWIPE$dd_sdk_android_rum_release", "()Ljava/lang/String;", "MSG_NO_TARGET_TAP", "getMSG_NO_TARGET_TAP$dd_sdk_android_rum_release", "SCROLL_DIRECTION_DOWN", "SCROLL_DIRECTION_LEFT", "SCROLL_DIRECTION_RIGHT", "SCROLL_DIRECTION_UP", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getMSG_NO_TARGET_TAP$dd_sdk_android_rum_release() {
            return MSG_NO_TARGET_TAP;
        }

        @NotNull
        public final String getMSG_NO_TARGET_SCROLL_SWIPE$dd_sdk_android_rum_release() {
            return MSG_NO_TARGET_SCROLL_SWIPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

